<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\HistoriqueTravaux;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Historiquetravaux controller.
 *
 * @Route("historiquetravaux/{_locale}", defaults = {"_locale" = "fr"})
 */
class HistoriqueTravauxController extends Controller
{
    /**
     * Lists all historiqueTravaux entities.
     *
     * @Route("/", name="historiquetravaux_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $historiqueTravauxes = $em->getRepository('AMLASqrBundle:HistoriqueTravaux')->findAll();

        return $this->render('historiquetravaux/index.html.twig', array(
            'historiqueTravauxes' => $historiqueTravauxes,
        ));
    }

    /**
     * Creates a new historiqueTravaux entity.
     *
     * @Route("/new", name="historiquetravaux_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $historiqueTravaux = new Historiquetravaux();
        $form = $this->createForm('AMLA\SqrBundle\Form\HistoriqueTravauxType', $historiqueTravaux);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($historiqueTravaux);
            $em->flush();

            return $this->redirectToRoute('historiquetravaux_show', array('id' => $historiqueTravaux->getId()));
        }

        return $this->render('historiquetravaux/new.html.twig', array(
            'historiqueTravaux' => $historiqueTravaux,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a historiqueTravaux entity.
     *
     * @Route("/{id}", name="historiquetravaux_show")
     * @Method("GET")
     */
    public function showAction(HistoriqueTravaux $historiqueTravaux)
    {
        $deleteForm = $this->createDeleteForm($historiqueTravaux);

        return $this->render('historiquetravaux/show.html.twig', array(
            'historiqueTravaux' => $historiqueTravaux,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing historiqueTravaux entity.
     *
     * @Route("/{id}/edit", name="historiquetravaux_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, HistoriqueTravaux $historiqueTravaux)
    {
        $deleteForm = $this->createDeleteForm($historiqueTravaux);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\HistoriqueTravauxType', $historiqueTravaux);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('historiquetravaux_edit', array('id' => $historiqueTravaux->getId()));
        }

        return $this->render('historiquetravaux/edit.html.twig', array(
            'historiqueTravaux' => $historiqueTravaux,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a historiqueTravaux entity.
     *
     * @Route("/{id}", name="historiquetravaux_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, HistoriqueTravaux $historiqueTravaux)
    {
        $form = $this->createDeleteForm($historiqueTravaux);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($historiqueTravaux);
            $em->flush();
        }

        return $this->redirectToRoute('historiquetravaux_index');
    }

    /**
     * Creates a form to delete a historiqueTravaux entity.
     *
     * @param HistoriqueTravaux $historiqueTravaux The historiqueTravaux entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(HistoriqueTravaux $historiqueTravaux)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('historiquetravaux_delete', array('id' => $historiqueTravaux->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
