<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Freevending;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Freevending controller.
 *
 * @Route("freevending/{_locale}", defaults = {"_locale" = "fr"})
 */
class FreevendingController extends Controller
{
    /**
     * Lists all freevending entities.
     *
     * @Route("/", name="freevending_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $freevendings = $em->getRepository('AMLASqrBundle:Freevending')->findAll();

        return $this->render('freevending/index.html.twig', array(
            'freevendings' => $freevendings,
        ));
    }

    /**
     * Lists all freevending entities.
     *
     * @Route("/mine", name="freevending_index_mine")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();
        $fournisseur = $this->getUser()->getCompagnyId();
        //dump($fournisseur);die;
        $freevendings = $em->getRepository('AMLASqrBundle:Freevending')->findOneBy(['fournisseur'=>$fournisseur]);

        return $this->render('freevending/index_mine.html.twig', array(
            'freevending' => $freevendings,
        ));
    }

    /**
     * Creates a new freevending entity.
     *
     * @Route("/new", name="freevending_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $freevending = new Freevending();
        $form = $this->createForm('AMLA\SqrBundle\Form\FreevendingType', $freevending);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($freevending);
            $em->flush();

            return $this->redirectToRoute('freevending_show', array('id' => $freevending->getId()));
        }

        return $this->render('freevending/new.html.twig', array(
            'freevending' => $freevending,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new freevending entity.
     *
     * @Route("/new/approvisionnement", name="freevending_approvisionnement")
     * @Method({"GET", "POST"})
     */
    public function newApprovisionnementAction(Request $request)
    {
        $freevending = new Freevending();
        $form = $this->createForm('AMLA\SqrBundle\Form\FreevendingApprovisionnementType', $freevending);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($freevending);
            $em->flush();

            return $this->redirectToRoute('freevending_show', array('id' => $freevending->getId()));
        }

        return $this->render('freevending/new_approvisionnement.html.twig', array(
            'freevending' => $freevending,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a freevending entity.
     *
     * @Route("/{id}", name="freevending_show")
     * @Method("GET")
     */
    public function showAction(Freevending $freevending)
    {
        $deleteForm = $this->createDeleteForm($freevending);

        return $this->render('freevending/show.html.twig', array(
            'freevending' => $freevending,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing freevending entity.
     *
     * @Route("/{id}/edit", name="freevending_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Freevending $freevending)
    {
        $deleteForm = $this->createDeleteForm($freevending);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FreevendingType', $freevending);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('freevending_edit', array('id' => $freevending->getId()));
        }

        return $this->render('freevending/edit.html.twig', array(
            'freevending' => $freevending,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a freevending entity.
     *
     * @Route("/{id}", name="freevending_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Freevending $freevending)
    {
        $form = $this->createDeleteForm($freevending);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($freevending);
            $em->flush();
        }

        return $this->redirectToRoute('freevending_index');
    }

    /**
     * Creates a form to delete a freevending entity.
     *
     * @param Freevending $freevending The freevending entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Freevending $freevending)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('freevending_delete', array('id' => $freevending->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
