<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Alerte;
use AMLA\SqrBundle\Entity\Account;
use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\Entity\BanqueAssocie;
use AMLA\SqrBundle\Entity\FournisseurBanque;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;

/**
 * Fournissseur controller.
 *
 * @Route("fournisseur/{_locale}", defaults = {"_locale" = "fr"})
 */
class FournissseurController extends Controller
{
    /**
     * Lists all fournissseur entities.
     *
     * @Route("/", name="fournisseur_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        
        $this->updateFournisseurStatus();
        
        $fournissseurs = $em->getRepository('AMLASqrBundle:Fournissseur')->findAll();
        return $this->render('fournissseur/all.html.twig', array(
            'fournissseurs' => $fournissseurs,
        ));
    }

    /**
     * Lists all fournissseur entities.
     *
     * @Route("/entities/mine", name="fournisseur_grid_index")
     * @Method("GET")
     */
    public function indexGridAction()
    {
        $em = $this->getDoctrine()->getManager();
        
        $this->updateFournisseurStatus();
        $compagny = $this->getUser()->getCompagnyId();
        if ($compagny) {
            # code...
            $fournissseurs = $em->getRepository('AMLASqrBundle:Fournissseur')->findBy(['parentCompagny'=>$compagny]);
            return $this->render('fournissseur/mine_grid.html.twig', array(
                'fournissseurs' => $fournissseurs,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }               
    }

    /**
     * Lists all fournissseur entities.
     *
     * @Route("/related/companies", name="fournisseur_related_companies_index")
     *  @Method({"GET", "POST"})
     */
    public function indexGetRelatedCompaniesrAction(Request $request)
    {
        $niu = $request->get('niu');
        $raisonSociale = $request->get('raisonSociale');
        
        $em = $this->getDoctrine()->getManager();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$niu, 'raisonSociale'=>$raisonSociale]);
        if($fournisseur)
		{
            $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournisseur->getId()]);
            
            /*
            $fournissseursRelationAffaire = array();
            foreach ($fmoas as $fmoa)
            {
                $fournissseursRelationAffaire[] = $fmoa->getFournisseur();
            }*/

			$fournissseurs = array();
			foreach ($fmoas as $fmoa) 
			{
				//dump($fmoa);
                $fournissseurs[] = 
                [
					'raisonSociale'=>$fmoa->getFournisseur()->getRaisonSociale(),
					'sigle'=>$fmoa->getFournisseur()->getSigle(),
					'niu'=>$fmoa->getFournisseur()->getNiu(),
					'email'=>$fmoa->getFournisseur()->getAdresseEmail(),
					'telephone'=>$fmoa->getFournisseur()->getTelephoneMobile(),
				];
			}
        }else
        {
			$fournissseurs = 0;
		}

        $response = new JsonResponse($fournissseurs);
        return $response;
    }

    
    /**
     * Lists all fournissseur entities.
     *
     * @Route("/info/niu", name="fournisseur_detail_from_niu")
     *  @Method({"GET", "POST"})
     */
    public function indexFournisseurInfoFromNiuAction(Request $request)
    {
        $niu = $request->get('niu');
        //$raisonSociale = $request->get('raisonSociale');
        
        $em = $this->getDoctrine()->getManager();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$niu]);
        if($fournisseur)
		{
            $fournissseurDetail= [
                'raisonSociale'=>$fournisseur->getRaisonSociale(),
                'sigle'=>$fournisseur->getSigle(),
                'niu'=>$fournisseur->getNiu(),
                'email'=>$fournisseur->getAdresseEmail(),
                'telephone'=>$fournisseur->getTelephoneMobile(),
                'boitePostale'=>$fournisseur->getBoitePostale(),
                'regisreCommerce'=>$fournisseur->getNumeroRegistreCommerce(),
                //'formeJuridique'=>$fournisseur->getTelephoneMobile(),
                //'regimeFiscal'=>$fournisseur->getRegimeFiscal(),
                'quartier'=>$fournisseur->getQuartier(),
                'lieuDit'=>$fournisseur->getLieuDit(),
                //'activitePrincipale'=>(empty($fournisseur->getActivitePrincipale()->getLibelle())) ? 'Non défini(e)' : $fournisseur->getActivitePrincipale()->getLibelle(),
                //'commune'=>(empty($fournisseur->getCommune()->getLibelle())) ? 'Non défini(e)' : $fournisseur->getCommune()->getLibelle(),
                //'centreImpot'=>(empty($fournisseur->getCentrerattachement()->getIntitule())) ? 'Non défini(e)' : $fournisseur->getCentrerattachement()->getIntitule(),
            ];
        }else
        {
			$fournissseurDetail = 0;
		}

        $response = new JsonResponse($fournissseurDetail);
        return $response;
    }

    /**
     * Creates a new fournissseur entity.
     *
     * @Route("/new", name="fournisseur_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $fournissseur = new Fournissseur();
        $banqueAssocie = new BanqueAssocie();
        $fournisseurBanque = new FournisseurBanque();

        $form = $this->createForm('AMLA\SqrBundle\Form\FournissseurType', $fournissseur);
        $form->handleRequest($request);
        $banqueform = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $banqueAssocie);
        $banqueform->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid() && $banqueform->isSubmitted() && $banqueform->isValid()) 
        {
            //dump($fournissseur);dump($banqueAssocie);die();

            $em = $this->getDoctrine()->getManager();

            $fournisseurBanque->setFournisseur($fournissseur);
            $fournisseurBanque->setBanque($banqueAssocie);
            $em->persist($fournissseur);
            $em->persist($banqueAssocie);
            $em->persist($fournisseurBanque);

            $em->flush();

            return $this->redirectToRoute('fournisseur_show', array('id' => $fournissseur->getId()));
        }

        return $this->render('fournissseur/new.html.twig', array(
            'fournissseur' => $fournissseur,
            'banqueAssocie'=>$banqueAssocie,
            'form' => $form->createView(),
            'banqueform' => $banqueform->createView(),
        ));
    }

    /**
     * Creates a new fournissseur entity.
     *
     * @Route("/new/entites", name="fournisseur_new_grid")
     * @Method({"GET", "POST"})
     */
    public function newGridAction(Request $request)
    {
        /*$fournissseur = new Fournissseur();
        $banqueAssocie = new BanqueAssocie();
        $fournisseurBanque = new FournisseurBanque();

        $form = $this->createForm('AMLA\SqrBundle\Form\FournissseurGridType', $fournissseur);
        $form->handleRequest($request);
        $banqueform = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $banqueAssocie);
        $banqueform->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid() && $banqueform->isSubmitted() && $banqueform->isValid()) 
        {
            //dump($fournissseur);dump($banqueAssocie);die();

            $em = $this->getDoctrine()->getManager();

            $fournisseurBanque->setFournisseur($fournissseur);
            $fournisseurBanque->setBanque($banqueAssocie);
            $em->persist($fournissseur);
            $em->persist($banqueAssocie);
            $em->persist($fournisseurBanque);

            $em->flush();

            return $this->redirectToRoute('fournisseur_show', array('id' => $fournissseur->getId()));
        }*/

        $fournissseur = new Fournissseur();
        $account = new Account();
        $banqueAssocie = new BanqueAssocie();
        $fournisseurBanque = new FournisseurBanque();

        $em = $this->getDoctrine()->getManager();
        $form = $this->createForm('AMLA\SqrBundle\Form\FournissseurType', $fournissseur);
        $form->handleRequest($request);
        $acform = $this->createForm('AMLA\SqrBundle\Form\AccountSubEntityGridType', $account);
        $acform->handleRequest($request);
        $banqueform = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $banqueAssocie);
        $banqueform->handleRequest($request);
        if (($form->isSubmitted() && $form->isValid()) && ($banqueform->isSubmitted() && $banqueform->isValid()) && ($acform->isSubmitted() && $acform->isValid())) 
        {
            $fournissseurExist = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$fournissseur->getNiu()]);
            if(!$fournissseurExist)
            {
                if($fournissseur->getLogo() != '')
                {
                    // $file stores the uploaded PDF file
                    /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                    $file = $fournissseur->getLogo();

                    $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                    // Move the file to the directory where brochures are stored
                    try {
                        $file->move(
                            $this->getParameter('logo_entreprise_directory'),
                            $fileName
                        );
                    } catch (FileException $e) {
                        // ... handle exception if something happens during file upload
                    }

                    // updates the 'brochure' property to store the PDF file name
                    // instead of its contents
                    $fournissseur->setLogo($fileName);
                    // ... persist the $product variable or any other work
                }

                //$password = $account->getPassword();
                //$options = ['cost' => 15];
                //$encoded = password_hash($password,PASSWORD_BCRYPT,$options);
                //$account->setPassword($encoded);
                $compagny = $this->getUser()->getCompagnyId();

                $account->setEmail($fournissseur->getAdresseEmail());
                $account->setCompagnyId($compagny);
                $em->persist($account);
                $fournissseur->setAccount($account);
                $fournissseur->setParentCompagny($compagny);
                $pays = $fournissseur->getCommune()->getVille()->getPays();
                $fournissseur->setPays($pays->getAlpha3());
                $em->persist($fournissseur);
                $em->persist($banqueAssocie);
                $fournisseurBanque->setBanque($banqueAssocie);
                $fournisseurBanque->setFournisseur($fournissseur);
                $em->persist($fournisseurBanque);
                $em->flush();
                $this->addFlash('info','Compte créé avec succès!');
                return $this->redirectToRoute('fournisseur_grid_index');
            }else
            {
                $this->addFlash('danger','Ce NIU est déjà utilisé !.');
            }
        }

        return $this->render('fournissseur/new_grid.html.twig', array(
            'fournissseur' => $fournissseur,
            'banqueAssocie'=>$banqueAssocie,
            'form' => $form->createView(),           
            'banqueform' => $banqueform->createView(),
            'acform' => $acform->createView(),
        ));
    }

    /**
     * Lists all fournissseur entities.
     *
     * @Route("/mine", name="fournisseur_mine")
     * @Method("GET")
     */
    public function mineAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();

        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournisseur->getId()]);
        
        $fournissseurs = array();
        foreach ($fmoas as $fmoa) 
        {
            $fournissseurs[] = $fmoa->getFournisseur();
        }
        
        return $this->render('fournissseur/index.html.twig', array(
            'fournissseurs' => $fournissseurs,
        ));
    }

    

    /**
     * Lists all fournissseur entities.
     *
     * @Route("/statut", name="fournisseur_statut_mine")
     * @Method("GET")
     */
    public function statutMineAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournisseur->getId()]);
        $fournissseurs = array();
        foreach ($fmoas as $fmoa) 
        {
            $fournissseurs[] = $fmoa->getFournisseur();
        }        

        return $this->render('fournissseur/statut_fournisseur.html.twig', array(
            'fournissseurs' => $fournissseurs,
        ));
    }

    /**
     * Lists all fournissseur entities.
     *
     * @Route("/criteria", name="fournisseur_criteria")
     * @Method("GET")
     */
    public function lejoueurAction(Request $request)
    {
        $portee = $request->get('portee');
        $paysid = $request->get('pays');
        $capital = $request->get('capital');
        //dump($request);
        //die;
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $paysfournisseur = $fournisseur->getPays();
        //$paysentitys = [];
        //$payscodes = [];
        $fmoas = [];
        $tmpfmoas = [];
        $fournisseurs = [];
        //On recupère dans la BD toutes entités pays correspondantes à la requête
        if ($paysid != NULL) 
        {
            //foreach($paysids as $paysid){
                $paysentity = $em->getRepository('AMLASqrBundle:Pays')->findOneBy(['id'=>$paysid]); 
            //}
        }else
        {
            $paysentity = NULL;
        } 
        
        //On récupère le code de tous ces pays
        if($paysentity != NULL){
            //foreach ($paysentitys as $paysentity) {
                $payscode = $paysentity->getAlpha3();
            //}
        }else{
            $payscode = NULL;
        }

        if($portee == 'national')
        {
            $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->getFournisseur($fournisseur,$paysfournisseur,$capital);
            if($fmoas != NULL)
            {
                foreach ($fmoas as $fmoa) 
                {
                    $fournisseurs[] = array(
                        'id'=>$fmoa->getFournisseur()->getId(),
                        'raisonSociale'=>$fmoa->getFournisseur()->getRaisonSociale(),
                    );
                }
            }else
            {
                $fournisseurs = NULL;
            }
            
        }else
        {
            //foreach ($payscodes as $payscode) {
                $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->getFournisseur($fournisseur,$payscode,$capital);
                //array_push($tmpfmoas,$tmpfmoas);
            //} 
            //foreach ($tmpfmoas as $moas) {
                foreach ($fmoas as $fmoa) 
                {
                    $fournisseurs[] = array(
                        'id'=>$fmoa->getFournisseur()->getId(),
                        'raisonSociale'=>$fmoa->getFournisseur()->getRaisonSociale(),
                    );
                }
            //}
        }
        //dump($fournisseurs);die;
        $rep = json_encode($fournisseurs);
        return new Response($rep);
    }
    

    /**
     * Finds and displays a fournissseur entity.
     *
     * @Route("/{id}", name="fournisseur_show")
     * @Method("GET")
     */
    public function showAction(Fournissseur $fournissseur)
    {
        $deleteForm = $this->createDeleteForm($fournissseur);

        $em = $this->getDoctrine()->getManager();

        $fournisseurbanks = $em->getRepository('AMLASqrBundle:FournisseurBanque')->findBy(array('fournisseur'=>$fournissseur));

        $banks=array();
        foreach($fournisseurbanks as $fournisseurbank)
        {
            $banks[]= $fournisseurbank->getBanque();
        }

        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(array('fournisseur'=>$fournissseur),['referenceANR'=>'ASC']);

        //dump($banks);die;

        return $this->render('fournissseur/show.html.twig', array(
            'fournissseur' => $fournissseur,
            'banks'=>$banks,
            'anrs'=>$anrs,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a fournissseur entity.
     *
     * @Route("/{id}/bank/access", name="fournisseur_show_bank")
     * @Method("GET")
     */
    public function showBankAccessAction(Fournissseur $fournissseur)
    {
        $deleteForm = $this->createDeleteForm($fournissseur);

        $em = $this->getDoctrine()->getManager();

        $fournisseurbanks = $em->getRepository('AMLASqrBundle:FournisseurBanque')->findBy(array('fournisseur'=>$fournissseur));

        $banks=array();
        foreach($fournisseurbanks as $fournisseurbank)
        {
            $banks[]= $fournisseurbank->getBanque();
        }

        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(array('fournisseur'=>$fournissseur),['referenceANR'=>'ASC']);

        //get relation d'affaire
        $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournissseur->getId()]);

        $fournissseursRelationAffaire = array();
        foreach ($fmoas as $fmoa)
        {
            $fournissseursRelationAffaire[] = $fmoa->getFournisseur();
        }

        //get fournisseur bon de commande reçu
        $bonCommandesRecu = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeReceive($fournissseur);

        // get bon de commandes émis
        $bonCommandesEmis = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeSent($fournissseur);
        //dump($banks);die;


        return $this->render('fournissseur/show_banque.html.twig', array(
            'fournissseur' => $fournissseur,
            'banks'=>$banks,
            'anrs'=>$anrs,
            'bonCommandesRecu'=>$bonCommandesRecu,
            'bonCommandesEmis'=>$bonCommandesEmis,
            'fournissseursRelationAffaire'=>$fournissseursRelationAffaire,
            'delete_form' => $deleteForm->createView(),
        ));
    }


    /**
     * Finds and displays a fournissseur entity.
     *
     * @Route("/{id}/impot", name="fournisseur_show_impot")
     * @Method("GET")
     */
    public function showImpotsAction(Fournissseur $fournissseur)
    {
        $deleteForm = $this->createDeleteForm($fournissseur);

        $em = $this->getDoctrine()->getManager();

        $fournisseurbanks = $em->getRepository('AMLASqrBundle:FournisseurBanque')->findBy(array('fournisseur'=>$fournissseur));

        $banks=array();
        foreach($fournisseurbanks as $fournisseurbank)
        {
            $banks[]= $fournisseurbank->getBanque();
        }

        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(array('fournisseur'=>$fournissseur),['referenceANR'=>'ASC']);

        //get relation d'affaire
        $fmoas = $em->getRepository('AMLASqrBundle:FournisseurMoa')->findBy(['moa'=>$fournissseur->getId()]);

        $fournissseursRelationAffaire = array();
        foreach ($fmoas as $fmoa)
        {
            $fournissseursRelationAffaire[] = $fmoa->getFournisseur();
        }

        //get fournisseur bon de commande reçu
        $bonCommandesRecu = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeReceive($fournissseur);

        // get bon de commandes émis
        $bonCommandesEmis = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeSent($fournissseur);
        //dump($banks);die;

        /**************Add Notification */
        $alerte = New Alerte();
        $alerte->setTitle('Alerte : Ouverture de la fiche du contribuable'.$fournissseur->getRaisonSociale(). ' - ' .$fournissseur->getSigle(). ' - ' .$fournissseur->getNiu() );
        $alerte->setDescription('La fiche du contribuable '.$fournissseur->getRaisonSociale(). ' - ' .$fournissseur->getSigle(). ' - ' .$fournissseur->getNiu().' vient d\'être ouverte par un agent des impôts dont le nom est'. $this->getUser()->fullName());
        $em->persist($alerte);
        $em->flush($alerte);
        /**************End Add Notification */

        return $this->render('fournissseur/show_impot.html.twig', array(
            'fournissseur' => $fournissseur,
            'banks'=>$banks,
            'anrs'=>$anrs,
            'bonCommandesRecu'=>$bonCommandesRecu,
            'bonCommandesEmis'=>$bonCommandesEmis,
            'fournissseursRelationAffaire'=>$fournissseursRelationAffaire,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Find and send an JSON Response of a fournisseur entity through his id
     * 
     * @Route("/find/find", name="fournisseur_find")
     * @Method({"GET","POST"})
     */
    public function findAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $id = $request->get('id');
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($id);
        $rep = array();
        $rep[] = (object) array(
            'raisonSociale'=>$fournisseur->getRaisonSociale(),
            'sigle'=>$fournisseur->getSigle(),
            'niu'=>$fournisseur->getNiu(),
            'numeroRegistreCommmerce'=>$fournisseur->getNumeroRegistreCommerce(),
            'quartier'=>$fournisseur->getQuartier(),
            'lieuDit'=>$fournisseur->getLieuDit(),
            'regimeFiscal'=>$fournisseur->getRegimeFiscal()->getIntitule(),
            'personneAContacter'=>$fournisseur->getPersonneAContacter(),
            'telephoneMobile'=>$fournisseur->getTelephoneMobile(),
            'telephoneFixe'=>$fournisseur->getTelephoneFixe(),
            'adresseEmail'=>$fournisseur->getAdresseEmail(),
            'boitePostale'=>$fournisseur->getBoitePostale(),
            'activitePrincipale'=>$fournisseur->getActivitePrincipale(),
            'formeJuridique'=>$fournisseur->getFormeJuridique()->getIntitule(),
            'centreRattachement'=>$fournisseur->getCentreRattachement()->getIntitule(),
            'commune'=>$fournisseur->getCommune(),
            'dateCreated'=>$fournisseur->getDateCreated(),
        );

        $fournisseurbanks = $em->getRepository('AMLASqrBundle:FournisseurBanque')->findBy(array('fournisseur'=>$fournisseur));

        $banks = array();
        foreach($fournisseurbanks as $fournisseurbank)
        {
            $banks[] = (object) array(
                'id'=>$fournisseurbank->getBanque()->getId(),
                'institutionBancaire'=>$fournisseurbank->getBanque()->getInstitutionBancaire()->getNomBanque(),
                'codeBanque'=>$fournisseurbank->getBanque()->getCodeBanque(),
                'codeGuichet'=>$fournisseurbank->getBanque()->getCodeGuichet(),
                'numeroCompte'=>$fournisseurbank->getBanque()->getNumeroCompte(),
                'cleRib'=>$fournisseurbank->getBanque()->getCleRib(),
                'numeroIban'=>$fournisseurbank->getBanque()->getNumeroIban(),
                'codeSwift'=>$fournisseurbank->getBanque()->getCodeSwift(),
            );
            
        }

        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(array('fournisseur'=>$fournisseur));

        $anrTabs = array();
        $datenow = new \DateTime('now');
        foreach($anrs as $anr)
        {
            $anrTabs[] = (object) array(
                'referenceANR' => $anr->getReferenceANR(),
                'debut' => $anr->getDateDebut(),
                'fin' => $anr->getDateFin(),
                'statut'=> $anr->getDateFin() < $datenow ? 'Expiré' : 'Valide',
                'dateEnregistrement' => $anr->getDateCreated(),
            );

        }

        $atds = $em->getRepository('AMLASqrBundle:Atd')->findBy(array('misEnCause'=>$fournisseur));

        $atdTabs = array();
        $datenow = new \DateTime('now');
        foreach($atds as $atd)
        {
            $atdTabs[] = (object) array(
                'emeteur' => $atd->getEmeteur()->getRaisonSociale(),
                'misencause' => $atd->getMisEnCause()->getRaisonSociale(),
                'montant'=> $atd->getMontant(),
                'dateCreation' => $atd->getDateCreated(),
            );

        }
        

       // $rep = new JsonResponse($rep);
        $response = array();
        $response[] = array(
            'fournisseur' => $rep,
            'banks' => $banks,
            'anrs' => $anrTabs,
            'atds' => $atdTabs,
        );
        
        return new JsonResponse($response);

    }

    /**
     * Displays a form to edit an existing fournissseur entity.
     *
     * @Route("/{id}/edit", name="fournisseur_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Fournissseur $fournissseur)
    {
        $deleteForm = $this->createDeleteForm($fournissseur);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FournissseurType', $fournissseur);
        $editForm->handleRequest($request);

        $em = $this->getDoctrine()->getManager();

        $fournisseurbanks = $em->getRepository('AMLASqrBundle:FournisseurBanque')->findBy(array('fournisseur'=>$fournissseur));

        $banks=array();
        foreach($fournisseurbanks as $fournisseurbank)
        {
            $banks[]= $fournisseurbank->getBanque();
        }

        $forms = array();
        foreach($banks as $bank )
        {
            $forms[] = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $bank)->createView();
        }
        //dump($request);die;

        if ($editForm->isSubmitted() && $editForm->isValid())
        {

            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('fournisseur_edit', array('id' => $fournissseur->getId()));
        }

        return $this->render('fournissseur/edit.html.twig', array(
            'fournissseur' => $fournissseur,
            'forms'=>$forms,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Get all fournisseur that've already submitted
     * 
     *@Route("/pending/pending",name="fournisseur_pending")
     *@Method({"GET","POST"})
     */
    public function pendingAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $soumissions = $em->getRepository('AMLASqrBundle:SoummissionOffre')->getSoumissionUser($fournisseur);
        $fournisseurs = array();

        foreach($soumissions as $soumission)
        {
            $fournisseurs[] = $soumission->getFournisseur();
        }

        return $this->render('fournissseur/pending.html.twig', array(
            'fournissseurs' => $fournisseurs,
        ));

    }

    /**
     * Deletes a fournissseur entity.
     *
     * @Route("/{id}", name="fournisseur_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Fournissseur $fournissseur)
    {
        $form = $this->createDeleteForm($fournissseur);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($fournissseur);
            $em->flush();
        }

        return $this->redirectToRoute('fournisseur_index');
    }

    /**
     * Creates a form to delete a fournissseur entity.
     *
     * @param Fournissseur $fournissseur The fournissseur entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Fournissseur $fournissseur)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('fournisseur_delete', array('id' => $fournissseur->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
    
    private function updateFournisseurStatus()
    {
        $em = $this->getDoctrine()->getManager();
        $fournissseus = $em->getRepository('AMLASqrBundle:Fournissseur')->findAll();
        foreach($fournissseus as $fournissseur)
        {
            $niu = $fournissseur->getNiu();

            //get ATD status for selected contribuable
            $atd = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(['misEnCause'=>$niu]);

            //get AMR status for selected contribuable
            $amr = $em->getRepository('AMLASqrBundle:AMR')->findOneBy(['niu'=>$niu, 'statut'=>1]);

            //Get contribuable status at Impots servers
            $url = 'http://teledeclaration-dgi.cm:1020/api/Contribuable2?niu='.$niu.'&idshare_application=ENEO';
            //dump($url);
            $ch = curl_init();
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_POST => 0,
                //CURLOPT_POSTFIELDS => '',
                CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
                CURLOPT_RETURNTRANSFER => true,
            ];
            curl_setopt_array($ch, $options);
            $responseContribuable = curl_exec($ch);
            $responseContribuable = json_decode($responseContribuable,true);
            curl_close($ch);
            
            if(!empty($responseContribuable))
            {
                $etatImpot = $responseContribuable[0]['etat'];
            }else
            {
                $etatImpot = null;
            }

            $fournissseur->setStatutContribuable($etatImpot);

            // mise à jour du statut ATD
            if($atd)
            {
                $fournissseur->setStatutAtd('Existence ATD'); 
            }else
            {
                $fournissseur->setStatutAtd('Absence ATD'); 
            }

            //mise à jour du statut AMR
            if($amr)
            {
                $fournissseur->setStatutAmr('En recouvrement'); 
            }else
            {
                $fournissseur->setStatutAmr('Rien a signaler');
            }     
			
			//mise à jour du statut ANR
            /*            
            if($amr)
            {
                $fournissseur->setStatutAmr('En recouvrement'); 
            }else
            {
                $fournissseur->setStatutAmr('Rien a signaler');
            }*/ 
            
            $em->persist($fournissseur);
            $em->flush();

            
        }
        return 1;
    }

    /**
     * @return string
     */
    private function generateUniqueFileName()
    {
        // md5() reduces the similarity of the file names generated by
        // uniqid(), which is based on timestamps
        return md5(uniqid());
    }
    
}
