<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FournisseurHabilite;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Fournisseurhabilite controller.
 *
 * @Route("fournisseurhabilite/{_locale}", defaults = {"_locale" = "fr"})
 */
class FournisseurHabiliteController extends Controller
{
    /**
     * Lists all fournisseurHabilite entities.
     *
     * @Route("/", name="fournisseurhabilite_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $fournisseurHabilites = $em->getRepository('AMLASqrBundle:FournisseurHabilite')->findAll();

        return $this->render('fournisseurhabilite/index.html.twig', array(
            'fournisseurHabilites' => $fournisseurHabilites,
        ));
    }
    /**
     * Lists all fournisseurHabilite entities.
     *
     * @Route("/suspendu/temp", name="fournisseurhabilite_index_suspendu")
     * @Method("GET")
     */
    public function indexSuspendusAction()
    {
        $em = $this->getDoctrine()->getManager();

        $fournisseurHabilites = $em->getRepository('AMLASqrBundle:FournisseurHabilite')->findBy(['status'=>0]);

        return $this->render('fournisseurhabilite/suspendus.html.twig', array(
            'fournisseurHabilites' => $fournisseurHabilites,
        ));
    }

    

    /**
     * Creates a new fournisseurHabilite entity.
     *
     * @Route("/new", name="fournisseurhabilite_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $fournisseurHabilite = new Fournisseurhabilite();
        $form = $this->createForm('AMLA\SqrBundle\Form\FournisseurHabiliteType', $fournisseurHabilite);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($fournisseurHabilite);
            $em->flush();

            return $this->redirectToRoute('fournisseurhabilite_show', array('id' => $fournisseurHabilite->getId()));
        }

        return $this->render('fournisseurhabilite/new.html.twig', array(
            'fournisseurHabilite' => $fournisseurHabilite,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a fournisseurHabilite entity.
     *
     * @Route("/{id}", name="fournisseurhabilite_show")
     * @Method("GET")
     */
    public function showAction(FournisseurHabilite $fournisseurHabilite)
    {
        $deleteForm = $this->createDeleteForm($fournisseurHabilite);

        return $this->render('fournisseurhabilite/show.html.twig', array(
            'fournisseurHabilite' => $fournisseurHabilite,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing fournisseurHabilite entity.
     *
     * @Route("/{id}/edit", name="fournisseurhabilite_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FournisseurHabilite $fournisseurHabilite)
    {
        $deleteForm = $this->createDeleteForm($fournisseurHabilite);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FournisseurHabiliteType', $fournisseurHabilite);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('fournisseurhabilite_edit', array('id' => $fournisseurHabilite->getId()));
        }

        return $this->render('fournisseurhabilite/edit.html.twig', array(
            'fournisseurHabilite' => $fournisseurHabilite,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a fournisseurHabilite entity.
     *
     * @Route("/{id}", name="fournisseurhabilite_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FournisseurHabilite $fournisseurHabilite)
    {
        $form = $this->createDeleteForm($fournisseurHabilite);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($fournisseurHabilite);
            $em->flush();
        }

        return $this->redirectToRoute('fournisseurhabilite_index');
    }

    /**
     * Creates a form to delete a fournisseurHabilite entity.
     *
     * @param FournisseurHabilite $fournisseurHabilite The fournisseurHabilite entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FournisseurHabilite $fournisseurHabilite)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('fournisseurhabilite_delete', array('id' => $fournisseurHabilite->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
