<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FournisseurBanqueAccess;
use AMLA\SqrBundle\Entity\Notification;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Fournisseurbanqueaccess controller.
 *
 * @Route("fournisseurbanqueaccess/{_locale}", defaults = {"_locale" = "fr"})
 */
class FournisseurBanqueAccessController extends Controller
{
    /**
     * Lists all fournisseurBanqueAccess entities.
     *
     * @Route("/", name="fournisseurbanqueaccess_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        //dump($this->getUser());die;

        $fournisseurBanqueAccesses = $em->getRepository('AMLASqrBundle:FournisseurBanqueAccess')->findAll();
        if($this->getUser()->getRole()==3)
        {
            $template = 'fournisseurbanqueaccess/index_banque.html.twig';
        }elseif($this->getUser()->getRole()==1)
        {
            $template = 'fournisseurbanqueaccess/index.html.twig';
        }else{
            $this->addFlash('danger','Vous n\'avez pas accès à cette ressource');

            return $this->redirectToRoute('dashboard_index');
        }

        return $this->render($template, array(
            'fournisseurBanqueAccesses' => $fournisseurBanqueAccesses,
            'fournissseur' => $this->getUser()->getFournisseurs()[0],
        ));
    }

    /**
     * Lists all fournisseurBanqueAccess entities.
     *
     * @Route("/home/board", name="fournisseurbanqueaccess_home")
     * @Method("GET")
     */
    public function homeAction()
    {
        return $this->render('fournisseurbanqueaccess/home.html.twig', array(
            'fournissseur' => $this->getUser()->getFournisseurs()[0],
        ));
    }

    /**
     * Lists all fournisseurBanqueAccess entities.
     *
     * @Route("/home/board/bank", name="fournisseurbanqueaccess_home_bank")
     * @Method("GET")
     */
    public function homeBankAction()
    {
        return $this->render('fournisseurbanqueaccess/home_bank.html.twig', array(
            'fournissseur' => $this->getUser()->getFournisseurs()[0],
        ));
    }

    /**
     * Creates a new fournisseurBanqueAccess entity.
     *
     * @Route("/new", name="fournisseurbanqueaccess_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $fournisseurBanqueAccess = new Fournisseurbanqueaccess();
        $form = $this->createForm('AMLA\SqrBundle\Form\FournisseurBanqueAccessType', $fournisseurBanqueAccess);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();
            //dump($request);die;
            $niu = $request->get('amla_sqrbundle_fournisseurbanqueaccess')['niu'];
            $raisonSociale = $request->get('amla_sqrbundle_fournisseurbanqueaccess')['raisonSociale'];
            //$fournisseur = null;
            if(!empty($niu) && !empty($raisonSociale)){
                dump('niu et raison');
                $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$niu, 'raisonSociale'=>$raisonSociale]);
            }elseif($niu && empty($raisonSociale)){
                dump('niu');
                $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$niu]);
            }elseif($raisonSociale && empty($niu)){
                dump('raison');
                $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$raisonSociale]);
            }

            if(!empty($fournisseur))
            {
                $fournisseurBanqueAccess->setBanque($this->getUser()->getFournisseurs()[0]);
                $fournisseurBanqueAccess->setFournisseur($fournisseur);
                $em->persist($fournisseurBanqueAccess);


                /**************Add Notification for cancel payment  */
                $notificationO = New Notification();
                $notificationO->setTitle('Demande de mise en relation');
                $notificationO->setDescription('Vous avez reçu une demande d\'accès à vos données émis par la banque dénomée '.$fournisseurBanqueAccess->getBanque()->getRaisonSociale().' - '.$fournisseurBanqueAccess->getBanque()->getSigle().'. Vous pouvez consulter le détail dans la section banque/accès aux données');
                $notificationO->setFournisseur($fournisseur);
                $em->persist($notificationO);
                /**************End Add Notification */
                $em->flush();

                $this->addFlash('info','Demande envoyée avec succès!');

                return $this->redirectToRoute('fournisseurbanqueaccess_show', array('id' => $fournisseurBanqueAccess->getId()));
            }else
            {
                $this->addFlash('danger','Une erreur est survenue. Vérifiez le formulaire SVP...');
            }
        }

        return $this->render('fournisseurbanqueaccess/new.html.twig', array(
            'fournisseurBanqueAccess' => $fournisseurBanqueAccess,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a fournisseurBanqueAccess entity.
     *
     * @Route("/{id}", name="fournisseurbanqueaccess_show")
     * @Method("GET")
     */
    public function showAction(FournisseurBanqueAccess $fournisseurBanqueAccess)
    {
        $deleteForm = $this->createDeleteForm($fournisseurBanqueAccess);

        return $this->render('fournisseurbanqueaccess/show.html.twig', array(
            'fournisseurBanqueAccess' => $fournisseurBanqueAccess,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a fournisseurBanqueAccess entity.
     *
     * @Route("/{id}/{action}", name="fournisseurbanqueaccess_valider")
     * @Method("GET")
     */
    public function validateAction(FournisseurBanqueAccess $fournisseurBanqueAccess, $action)
    {
        $em = $this->getDoctrine()->getManager();
        if($action==1)
        {
            $fournisseurBanqueAccess->setStatut(1);
            /**************Add Notification for approve request  */
            $notificationO = New Notification();
            $notificationO->setTitle('Validation de la demande de mise en relation');
            $notificationO->setDescription('La demande d\'accès aux données que vous ave émise pour le fournisseur '.$fournisseurBanqueAccess->getFournisseur()->getRaisonSociale().' - '.$fournisseurBanqueAccess->getBanque()->getSigle().' a été approuvée.');
            $notificationO->setFournisseur($fournisseurBanqueAccess->getBanque());
            $em->persist($notificationO);
            /**************End Add Notification */
        }elseif($action==2)
        {
            $fournisseurBanqueAccess->setStatut(2);
            /**************Add Notification for cancel request  */
            $notificationO = New Notification();
            $notificationO->setTitle('Rejet de la demande de mise en relation');
            $notificationO->setDescription('La demande d\'accès aux données que vous ave émise pour le fournisseur '.$fournisseurBanqueAccess->getFournisseur()->getRaisonSociale().' - '.$fournisseurBanqueAccess->getBanque()->getSigle().' a été rejetée.');
            $notificationO->setFournisseur($fournisseurBanqueAccess->getBanque());
            $em->persist($notificationO);
            /**************End Add Notification */
        }

        $em->persist($fournisseurBanqueAccess);
        $em->flush();
        $this->addFlash('info','Statut de la demande mise à jour avec succès');
        return $this->redirectToRoute('fournisseurbanqueaccess_index');
    }

    /**
     * Displays a form to edit an existing fournisseurBanqueAccess entity.
     *
     * @Route("/{id}/edit", name="fournisseurbanqueaccess_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FournisseurBanqueAccess $fournisseurBanqueAccess)
    {
        $deleteForm = $this->createDeleteForm($fournisseurBanqueAccess);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FournisseurBanqueAccessType', $fournisseurBanqueAccess);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('fournisseurbanqueaccess_edit', array('id' => $fournisseurBanqueAccess->getId()));
        }

        return $this->render('fournisseurbanqueaccess/edit.html.twig', array(
            'fournisseurBanqueAccess' => $fournisseurBanqueAccess,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a fournisseurBanqueAccess entity.
     *
     * @Route("/{id}", name="fournisseurbanqueaccess_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FournisseurBanqueAccess $fournisseurBanqueAccess)
    {
        $form = $this->createDeleteForm($fournisseurBanqueAccess);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($fournisseurBanqueAccess);
            $em->flush();
        }

        return $this->redirectToRoute('fournisseurbanqueaccess_index');
    }

    /**
     * Creates a form to delete a fournisseurBanqueAccess entity.
     *
     * @param FournisseurBanqueAccess $fournisseurBanqueAccess The fournisseurBanqueAccess entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FournisseurBanqueAccess $fournisseurBanqueAccess)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('fournisseurbanqueaccess_delete', array('id' => $fournisseurBanqueAccess->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
