<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FineItem;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Fineitem controller.
 *
 * @Route("fineitem/{_locale}", defaults = {"_locale" = "fr"})
 */
class FineItemController extends Controller
{
    /**
     * Lists all fineItem entities.
     *
     * @Route("/", name="fineitem_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $fineItems = $em->getRepository('AMLASqrBundle:FineItem')->findAll();

        return $this->render('fineitem/index.html.twig', array(
            'fineItems' => $fineItems,
        ));
    }

    /**
     * Creates a new fineItem entity.
     *
     * @Route("/new", name="fineitem_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $fineItem = new Fineitem();
        $form = $this->createForm('AMLA\SqrBundle\Form\FineItemType', $fineItem);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($fineItem);
            $em->flush();

            return $this->redirectToRoute('fineitem_show', array('id' => $fineItem->getId()));
        }

        return $this->render('fineitem/new.html.twig', array(
            'fineItem' => $fineItem,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a fineItem entity.
     *
     * @Route("/{id}", name="fineitem_show")
     * @Method("GET")
     */
    public function showAction(FineItem $fineItem)
    {
        $deleteForm = $this->createDeleteForm($fineItem);

        return $this->render('fineitem/show.html.twig', array(
            'fineItem' => $fineItem,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing fineItem entity.
     *
     * @Route("/{id}/edit", name="fineitem_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FineItem $fineItem)
    {
        $deleteForm = $this->createDeleteForm($fineItem);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FineItemType', $fineItem);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('fineitem_edit', array('id' => $fineItem->getId()));
        }

        return $this->render('fineitem/edit.html.twig', array(
            'fineItem' => $fineItem,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a fineItem entity.
     *
     * @Route("/{id}", name="fineitem_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FineItem $fineItem)
    {
        $form = $this->createDeleteForm($fineItem);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($fineItem);
            $em->flush();
        }

        return $this->redirectToRoute('fineitem_index');
    }

    /**
     * Creates a form to delete a fineItem entity.
     *
     * @param FineItem $fineItem The fineItem entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FineItem $fineItem)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('fineitem_delete', array('id' => $fineItem->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
