<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Fine;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\Entity\CheckQr;
use AMLA\SqrBundle\API\SqrApi as SqrApi;

/**
 * Fine controller.
 *
 * @Route("fine") 
 */
class FineController extends Controller
{
    /**
     * Lists all fine entities.
     *
     * @Route("/", name="fine_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $fines = $em->getRepository('AMLASqrBundle:Fine')->findAll();

        return $this->render('fine/index.html.twig', array(
            'fines' => $fines,
        ));
    }

    /**
     * Creates a new fine entity.
     *
     * @Route("/new", name="fine_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $fine = new Fine();
        $form = $this->createForm('AMLA\SqrBundle\Form\FineType', $fine);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();


                $cle = $this->container->getParameter('api_key');
                $piece = 'Amende';
                $proprietaire = $fine->getEmail().'/'.$fine->getTelephone();

                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece, 
                    'proprietaire' => $proprietaire, 
                                   
                );

                $container = $this->container;
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                
                if($res[0])
                {
                    $qr = $res[0]->qr;
                    $num = $res[0]->niu; 
                }
                
                $newname = 'Amende_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $fine->setTransactionNumber($checkqr); 

                //Génération du Bordereau avec MPDF
                $target = __DIR__.'/../../../../web/generated/Amendes/';
                $name = 'amende-'.$num.'.pdf';

                /*$pdf = $this->renderView('amende/docEmission.html.twig', array(
                    'atd' => $atd,
                    'emeteur'=>$emeteur,
                    'imageqr'=> $atd->getQrCode()->getChemin(),
                    'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                ));

                try
                {
                    $mpdf = new \Mpdf\Mpdf();
                    $mpdf->WriteHtml($pdf);
                    if (file_exists($target) != 1) 
                    {
                        mkdir($target,0777,true);
                        $mpdf->Output($target.$name, 'F');
                    }else
                    {
                        $mpdf->Output($target.$name, 'F');
                    }

                }catch(MpdfException $e)
                {
                    die($e->getMessage());
                    $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'amende');
                }                
*/
            $fine->setTotal('1200');
            $em->persist($checkqr);
            $em->persist($fine);
            $em->flush();

            // On envoie le mot de passe par mail
                $message = (new \Swift_Message('CHECKTATOO : Notification d\'amende'))
                    ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO']) // sender
                    ->setTo($fine->getEmail())       // recipient
                    /*->setBody('Vos paramètres de connexion à la plateforme CHECKTATOO sont
                        Login:'  . $user->getLoginUser().'
                        Mot de passe : ' . $passss);*/
                    ->setBody(
                        $this->renderView(
                        // app/Resources/views/Emails/registration.html.twig
                            'fine/email_send.html.twig',
                            array('fine' =>$fine )
                        ),
                        'text/html'
                    );
                $this->get('mailer')->send($message);


            return $this->redirectToRoute('fine_show', array('id' => $fine->getId()));
        }

        return $this->render('fine/new.html.twig', array(
            'fine' => $fine,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a fine entity.
     *
     * @Route("/{id}", name="fine_show")
     * @Method("GET")
     */
    public function showAction(Fine $fine)
    {
        $deleteForm = $this->createDeleteForm($fine);

        return $this->render('fine/show.html.twig', array(
            'fine' => $fine,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a fine entity.
     *
     * @Route("/{id}/paiement", name="fine_valider")
     * @Method("GET")
     */
    public function validerAction(Fine $fine)
    {
        $deleteForm = $this->createDeleteForm($fine);

        return $this->render('fine/valider.html.twig', array(
            'fine' => $fine,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing fine entity.
     *
     * @Route("/{id}/edit", name="fine_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Fine $fine)
    {
        $deleteForm = $this->createDeleteForm($fine);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FineType', $fine);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('fine_edit', array('id' => $fine->getId()));
        }

        return $this->render('fine/edit.html.twig', array(
            'fine' => $fine,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a fine entity.
     *
     * @Route("/{id}", name="fine_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Fine $fine)
    {
        $form = $this->createDeleteForm($fine);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($fine);
            $em->flush();
        }

        return $this->redirectToRoute('fine_index');
    }

    /**
     * Creates a form to delete a fine entity.
     *
     * @param Fine $fine The fine entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Fine $fine)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('fine_delete', array('id' => $fine->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
