<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FineCategory;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Finecategory controller.
 *
 * @Route("finecategory/{_locale}", defaults = {"_locale" = "fr"})
 */
class FineCategoryController extends Controller
{
    /**
     * Lists all fineCategory entities.
     *
     * @Route("/", name="finecategory_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $fineCategories = $em->getRepository('AMLASqrBundle:FineCategory')->findAll();

        return $this->render('finecategory/index.html.twig', array(
            'fineCategories' => $fineCategories,
        ));
    }

    /**
     * Creates a new fineCategory entity.
     *
     * @Route("/new", name="finecategory_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $fineCategory = new Finecategory();
        $form = $this->createForm('AMLA\SqrBundle\Form\FineCategoryType', $fineCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($fineCategory);
            $em->flush();

            return $this->redirectToRoute('finecategory_show', array('id' => $fineCategory->getId()));
        }

        return $this->render('finecategory/new.html.twig', array(
            'fineCategory' => $fineCategory,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a fineCategory entity.
     *
     * @Route("/{id}", name="finecategory_show")
     * @Method("GET")
     */
    public function showAction(FineCategory $fineCategory)
    {
        $deleteForm = $this->createDeleteForm($fineCategory);

        return $this->render('finecategory/show.html.twig', array(
            'fineCategory' => $fineCategory,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing fineCategory entity.
     *
     * @Route("/{id}/edit", name="finecategory_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FineCategory $fineCategory)
    {
        $deleteForm = $this->createDeleteForm($fineCategory);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FineCategoryType', $fineCategory);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('finecategory_edit', array('id' => $fineCategory->getId()));
        }

        return $this->render('finecategory/edit.html.twig', array(
            'fineCategory' => $fineCategory,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a fineCategory entity.
     *
     * @Route("/{id}", name="finecategory_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FineCategory $fineCategory)
    {
        $form = $this->createDeleteForm($fineCategory);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($fineCategory);
            $em->flush();
        }

        return $this->redirectToRoute('finecategory_index');
    }

    /**
     * Creates a form to delete a fineCategory entity.
     *
     * @param FineCategory $fineCategory The fineCategory entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FineCategory $fineCategory)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('finecategory_delete', array('id' => $fineCategory->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
