<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FactureSpontane;
use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\Entity\FactureSpontaneArticle;
use AMLA\SqrBundle\Entity\FactureSpontaneService;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 

/**
 * Facturespontane controller.
 *
 * @Route("factureinstantane/{_locale}", defaults = {"_locale" = "fr"})
 */
class FactureSpontaneController extends Controller
{
    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/", name="facturespontane_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findAll();

        return $this->render('factureinstantanee/index.html.twig', array(
            'factureSpontanes' => $factureSpontanes,
        ));
    }

    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/dashboard", name="facturespontane_dashboard")
     * @Method("GET")
     */
    public function dashboardAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findAll();

        return $this->render('facturesecurise/dashboard.html.twig', array(
            
        ));
    }

    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/mine", name="facturespontane_mine_index")
     * @Method("GET")
     */
    public function mineIndexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['account'=>$this->getUser()], ['id'=>'DESC']);

        return $this->render('factureinstantanee/mine.html.twig', array(
            'factureSpontanes' => $factureSpontanes,
        ));
    }



    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/attente/paiement", name="facturespontane_pending_index_secure")
     * @Method("GET")
     */
    public function pendingIndexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['account'=>$this->getUser(), 'statut'=>0], ['id'=>'DESC']);

        return $this->render('facturesecurise/mine_en_attente.html.twig', array(
            'factureSpontanes' => $factureSpontanes,
        ));
    }


    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/emises/secure", name="facturespontane_emises_index_secure")
     * @Method("GET")
     */
    public function emisesIndexSecureAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();

            $fournisseur = $this->getUser()->getCompagnyId();

            $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['account'=>$this->getUser()], ['id'=>'DESC']);

            return $this->render('facturesecurise/emises.html.twig', array(
                'factureSpontanes' => $factureSpontanes,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }


    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/recues/secure", name="facturespontane_recues_index_secure")
     * @Method("GET")
     */
    public function recuesIndexSecureAction()
    {
        if($this->getUser() && !empty($this->getUser()->getRole())) 
        {
            $em = $this->getDoctrine()->getManager();
            $fournisseur = $this->getUser()->getCompagnyId();

            //$factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['account'=>$this->getUser()], ['id'=>'DESC']);
            $factureSpontanes = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['fournisseur'=>$fournisseur], ['id'=>'DESC']);

            return $this->render('facturesecurise/recues.html.twig', array(
                'factureSpontanes' => $factureSpontanes,
            ));
        }else
        {
            $this->get('session')->getFlashBag()->add('danger', 'Désolé : vous n\'avez pas accès à cette ressource');
            return $this->redirectToRoute('dashboard_index');
        }
    }

    /**
     * Lists all factureSpontane entities.
     *
     * @Route("/other", name="facturespontane_other_index")
     * @Method("GET")
     */
    public function otherIndexAction()
    {
        $em = $this->getDoctrine()->getManager();
        //dump($this->getUser());die;

        $factureSpontaneNiu = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['beneficiaireNiu'=>$this->getUser()->getFournisseurs()[0]->getNiu()], ['id'=>'DESC']);

        $factureSpontaneRs = $em->getRepository('AMLASqrBundle:FactureSpontane')->findBy(['beneficiaireSocialReason'=>$this->getUser()->getFournisseurs()[0]->getRaisonSociale()], ['id'=>'DESC']);

       $factureSpontanes = array_unique(array_merge($factureSpontaneNiu,$factureSpontaneRs), SORT_REGULAR);

        return $this->render('factureinstantanee/other.html.twig', array(
            'factureSpontanes' => $factureSpontanes,
        ));
    }

     /**
     * Pay and update object.
     *
     * @Route("/pay/update", name="facturespontane_pay_update")
     * @Method({"GET", "POST"})
     */
    public function payAction(Request $request )
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpId = $request->get('factureSpId');
        $payMode = $request->get('payMode');
        $telephone = $request->get('telephone');

       $factureSpontane = $em->getRepository('AMLASqrBundle:FactureSpontane')->findOneBy(['id'=>$factureSpId]);
        if ($factureSpontane) 
        {
           # code...
            /*$factureSpontane->setPayNumber();
            $factureSpontane->setPayMode();*/
            $factureSpontane->setStatut(1);
            $em->persist($factureSpontane);
            $em->flush();
            $reply = 1;

            //$this->addFlash('info','Paiement effectué avec succès!');
            //$this->get('session')->getFlashBag()->add('info', 'Paiement effectué avec succès!');

        }else
        {
            $reply = 0;
        }
               
        $response = $reply;
        $response = new JsonResponse($response);
        return $response;
    }

    /**
     * Pay and update object.
     *
     * @Route("/pay/om", name="facturespontane_pay_om_pay")
     * @Method({"GET", "POST"})
     */
    public function initiatePaymentAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $cle =  $cle = $this->getParameter('api_key');
        $numero = $request->get('telephone');
        $factureSpId = $request->get('factureSpId');
        $payerMessage = 'Test';        
        $payeeNote = 'Test ';

        $factureSpontane = $em->getRepository('AMLASqrBundle:FactureSpontane')->findOneBy(['id'=>$factureSpId]);
        if($factureSpontane)
        {
            $amount = intVal($factureSpontane->getNetApayer());
            $clientEId =$factureSpontane->getQrCode()->getNumero();
            //dump($factureSpontane->getQrCode()->getNumero());die;
            $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
            try 
            {   
                $em = $this->getDoctrine()->getManager();
    
                $response = $client->request('POST', $this->getParameter('epayment_base_url').'mtn/initiate/payment/MTN', [
                   'form_params'=> [ 
                        "cle"=>$cle,
                        "amount"=>$amount,
                        "currency"=>"XAF",
                        "clientEId"=>$clientEId,
                        "partyId"=> $numero,
                        /*"payer"=> [
                            "partyIdType"=>"MSISDN",
                            //"partyId"=> "237673126161",
                            "partyId"=> $numero,
                        ],*/
                        "payerMessage"=>$payerMessage,
                        "payeeNote"=>$payeeNote,
                    ]
                ]);
    
                 /*$code =  $response->getStatusCode(); # 200
                $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                
                $ret = json_decode($body, true);  
                if($ret['uuid'] == 'null' || $ret['status_code'] =='Application non autorisé ou Clé API incorrecte'){
                    $reply = 0;
                }else{
                    $reply = 1;
                }
                //dump($ret);die;
               
                 
            } catch (\GuzzleHttp\Exception\ConnectException $th)
            {
               //die('bam');
               throw $th;
              // $rep ='ERREUR';
              //die();
              $reply = 0;
            }
        }
       
        /*$tabRetour = array(
            'uuid' => (empty($uuid)) ? 'null' : $uuid,
            'status_code' => (empty($rep)) ? 'KO' : $rep,
        );*/
        $response = $reply;
        $response = new JsonResponse($reply);
        return $response;
    }

     /**
     * Pay and update object.
     *
     * @Route("/pay/cancel", name="facturespontane_pay_cancel")
     * @Method({"GET", "POST"})
     */
    public function cancelPayAction(Request $request )
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpId = $request->get('factureSpId');

       $factureSpontane = $em->getRepository('AMLASqrBundle:FactureSpontane')->findOneBy(['id'=>$factureSpId]);
        if ($factureSpontane) 
        {
            $factureSpontane->setStatut(2);
            $em->persist($factureSpontane);            

            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontane->getAccount()->getFournisseurs()[0]->getNiu()]);
           
            if (empty($frnisseur)) 
            {
                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontane->getAccount()->getFournisseurs()[0]->getRaisonSociale()]);
            }
                
            if(!empty($frnisseur))
            {
                /**************Add Notification for cancel payment  */
                $notificationO = New Notification();
                $notificationO->setTitle('Rejet paiement facture instantanée '.$factureSpontane->getQrCode()->getNumero());
                $notificationO->setDescription('Votre facture instantanée émise dont la référence est '.$factureSpontane->getQrCode()->getNumero().' a été rejetée. Vous pouvez consulter le détail dans la section facture instantanées reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }
            
            $em->flush();
            $reply = 1;

        }else
        {
            $reply = 0;
        }
               
        $response = $reply;
        $response = new JsonResponse($response);
        return $response;
    }

    /**
     * Creates a new factureSpontane entity.
     *
     * @Route("/new", name="facturespontane_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {        
       
        $factureSpontane = new FactureSpontane();
        $form = $this->createForm('AMLA\SqrBundle\Form\FactureSpontaneType', $factureSpontane);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $qte = $request->get('qte');
            $prix = $request->get('prixht'); 
            $tva = $request->get('tva');
            $ir = $request->get('ir'); 
            $designation = $request->get('designation');
            $numeroEncaissement = $request->get('numeroEncaissement');
            $banqueAssocie = $request->get('banqueAssocie');
            $numCompte = $request->get('numCompte');

            switch ($factureSpontane->getModeReglement()) {
                case 'ORANGE':
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'VIREMENT':
                    $factureSpontane->setBanqueReglement($banqueAssocie);
                    $factureSpontane->setNumcomptebanqueReglement($numCompte);                    
                break;
                case 'ORABANK':

                    break;
                case 'MOMO':                    
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'TOUT':

                    break;
                default:
                  //...''
            }


            /*dump($request); dump($factureSpontane->getModeReglement());
            dump($factureSpontane);die;*/
            //dump($request);die;
            for($i = 0; $i < count($designation); $i++)
            {
                $factureSpontaneArticle = new FactureSpontaneArticle();
                $factureSpontaneArticle->setFactureSpontane($factureSpontane);
                $factureSpontaneArticle->setNomArticle($designation[$i]);
                $factureSpontaneArticle->setQuantite($qte[$i]);
                $factureSpontaneArticle->setPrix($prix[$i]);
                $factureSpontaneArticle->setPrixHT($qte[$i] * $prix[$i]);
                $factureSpontaneArticle->setTva(($qte[$i] * $prix[$i]) * $tva / 100);
                $factureSpontaneArticle->setPrixTtc($factureSpontaneArticle->getPrixHT() + $factureSpontaneArticle->getTva());
                $em->persist($factureSpontaneArticle);
                //dump($factureSpontaneArticle);
                //$em->flush();
                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneArticle->getTva());
                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneArticle->getPrixHT());
                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneArticle->getPrixTtc());
            }
            
            //die;
            $factureSpontane->setStatut(0);
            $factureSpontane->setTva($tva);
            $factureSpontane->setIr($ir);
            $factureSpontane->setIrMontant(($factureSpontane->getMontantTotalHt() * $ir) / 100);
            $factureSpontane->setNetApayer(($factureSpontane->getMontantTotalTtc() - $factureSpontane->getIrMontant()));
            $factureSpontane->setAccount($this->getUser());
           

            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontane->getBeneficiaireNiu()]);

            if (empty($frnisseur)) 
            {
                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontane->getBeneficiaireSocialReason()]);
            }
                
            if(!empty($frnisseur))
            {
                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('Reception Facture instantanée');
                $notificationO->setDescription('Une facture instantanée a été émis à votre endroit par le fournisseur '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' dont la référence est'.$factureSpontane->getReference(). '. Vous pouvez consulter le détail dans la section facture spontanée reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }
             /**************Add Notification for sent Bill */
             $notificationI = New Notification();
             $notificationI->setTitle('Emission facture instantanée');
             $notificationI->setDescription('Vous avez émis une nouvelle facture instantanée au fournisseur '.$factureSpontane->getBeneficiaireSocialReason().' '. $factureSpontane->getBeneficiaireNiu().'. La référence pour la facture est '.$factureSpontane->getReference());
             $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
             $em->persist($notificationI);
             /**************End Add Notification */
           

            $cle = $this->getParameter('api_key');
            $piece = 'Facture instantanée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontane->getBeneficiaireNiu().'-'.$factureSpontane->getBeneficiaireSocialReason();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0]){

                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'FACTURE_instantane_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $factureSpontane->setQrCode($checkqr); 
           
            //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/FacturesInstantane/';
            //$target = __DIR__.'/../../../../web/generated/Factures/facture_'.$factureSpontane->getId().'/emetteur_'.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().'/destinataire'.$factureSpontane->getBeneficiaireSocialReason().'/';
            
            $name = $num.'.pdf';
            /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
            die; */
           
            $factureSpontane->setPdf('generated/FacturesInstantane/'.$name);
            $em->persist($checkqr);
            $em->persist($factureSpontane);
            $em->flush(); 
            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
             $pdf = $this->renderView('print/facture_instantane.html.twig', array(
                'factureSpontane' =>$factureSpontane,
                'factureSpontaneArticles' => $factureSpontaneArticles,                
                'imageqr'=> $factureSpontane->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));
            try{
                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) {

                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else{
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e){

                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la facture');
            }

            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture instantanée'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSpontane->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSpontanee.html.twig',array(
                        'factureSpontane' =>$factureSpontane,
                        'factureSpontaneArticles' => $factureSpontaneArticles,
                    )
                ),
                'text/html'
            );
            //->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg);

            return $this->redirectToRoute('facturespontane_show', array('id' => $factureSpontane->getId()));
        }

        return $this->render('factureinstantanee/new.html.twig', array(
            'factureSpontane' => $factureSpontane,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new factureSpontane entity.
     *
     * @Route("/new/secure", name="facturespontane_new_secure")
     * @Method({"GET", "POST"})
     */
    public function newSecureAction(Request $request)
    {        
        $factureSpontane = new FactureSpontane();
        $form = $this->createForm('AMLA\SqrBundle\Form\FactureSecuriseType', $factureSpontane);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $qte = $request->get('qte');
            $prix = $request->get('prixht'); 
            $tva = $request->get('tva');
            $ir = $request->get('ir'); 
            $designation = $request->get('designation');
            $numeroEncaissement = $request->get('numeroEncaissement');
            $banqueAssocie = $request->get('banqueAssocie');
            $numCompte = $request->get('numCompte');


            $qteService = $request->get('qteService');
            $prixhtService = $request->get('prixhtService');
            $designationService = $request->get('designationService');

            switch ($factureSpontane->getModeReglement()) 
            {
                case 'ORANGE':
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'VIREMENT':
                    $factureSpontane->setBanqueReglement($banqueAssocie);
                    $factureSpontane->setNumcomptebanqueReglement($numCompte);                    
                break;
                case 'ORABANK':
                    break;
                case 'MOMO':                    
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'TOUT':

                    break;
                default:
                  //...''
            }

            /*dump($request); dump($factureSpontane->getModeReglement());
            dump($factureSpontane);die;*/
            //dump($request);die;
            // for products
            for($i = 0; $i < count($designation); $i++)
            {
                $factureSpontaneArticle = new FactureSpontaneArticle();
                $factureSpontaneArticle->setFactureSpontane($factureSpontane);
                $factureSpontaneArticle->setNomArticle($designation[$i]);
                $factureSpontaneArticle->setQuantite($qte[$i]);
                $factureSpontaneArticle->setPrix($prix[$i]);
                $factureSpontaneArticle->setPrixHT($qte[$i] * $prix[$i]);
                $factureSpontaneArticle->setTva(($qte[$i] * $prix[$i]) * $tva / 100);
                $factureSpontaneArticle->setPrixTtc($factureSpontaneArticle->getPrixHT() + $factureSpontaneArticle->getTva());
                $em->persist($factureSpontaneArticle);
                //dump($factureSpontaneArticle);
                //$em->flush();
                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneArticle->getTva());
                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneArticle->getPrixHT());
                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneArticle->getPrixTtc());
            }
            
            // for services
            for($i = 0; $i < count($designationService); $i++)
            {
                $factureSpontaneService = new FactureSpontaneService();
                $factureSpontaneService->setFactureSpontane($factureSpontane);
                $factureSpontaneService->setDesignation($designationService[$i]);
                $factureSpontaneService->setQuantite($qteService[$i]);
                $factureSpontaneService->setPrix($prixhtService[$i]);
                $factureSpontaneService->setPrixHT($qteService[$i] * $prixhtService[$i]);
                $factureSpontaneService->setTva(($qteService[$i] * $prixhtService[$i]) * $tva / 100);
                $factureSpontaneService->setPrixTtc($factureSpontaneService->getPrixHT() + $factureSpontaneService->getTva());
                $em->persist($factureSpontaneService);
                //dump($factureSpontaneService);
                //$em->flush();
                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneService->getTva());
                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneService->getPrixHT());
                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneService->getPrixTtc());
            }
            //die;
            $factureSpontane->setAttn($factureSpontane->getBeneficiaireSocialReason());
            $factureSpontane->setStatut(0);
            $factureSpontane->setTva($tva);
            $factureSpontane->setIr($ir);
            $factureSpontane->setIrMontant(($factureSpontane->getMontantTotalHt() * $ir) / 100);
            $factureSpontane->setNetApayer(($factureSpontane->getMontantTotalTtc() - $factureSpontane->getIrMontant()));
            $factureSpontane->setResteAPayer($factureSpontane->getNetApayer());

            $factureSpontane->setAccount($this->getUser());           

            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontane->getBeneficiaireNiu()]);

            if (empty($frnisseur)) 
            {
                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontane->getBeneficiaireSocialReason()]);
            }
                
            // check if subscribed to in bill and if parameters permitt
            /*
            if ($frnisseur && $frnisseur->getIsBillInOnly()==1) 
            {
                // code...
                $this->get('session')->getFlashBag()->add('danger', 'Impossible de facturer le contribuable '.$frnisseur->getRaisonSociale().' - '.$frnisseur->getNiu(). 'Il ne peut recevoir que les factures éditées à partir du service IN BILL');
                return $this->redirectToRoute('dashboard_index');
            }
            */

            if(!empty($frnisseur))
            {
                $factureSpontane->setFournisseur($frnisseur); 

                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('Reception Facture instantanée');
                $notificationO->setDescription('Une facture instantanée a été émis à votre endroit par le fournisseur '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' dont la référence est'.$factureSpontane->getReference(). '. Vous pouvez consulter le détail dans la section facture sécurisé reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }
             /**************Add Notification for sent Bill */
             $notificationI = New Notification();
             $notificationI->setTitle('Emission facture instantanée');
             $notificationI->setDescription('Vous avez émis une nouvelle facture instantanée au fournisseur '.$factureSpontane->getBeneficiaireSocialReason().' '. $factureSpontane->getBeneficiaireNiu().'. La référence pour la facture est '.$factureSpontane->getReference());
             $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
             $em->persist($notificationI);
             /**************End Add Notification */
           

            $cle = $this->getParameter('api_key');
            $piece = 'Facture instantanée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontane->getBeneficiaireNiu().'-'.$factureSpontane->getBeneficiaireSocialReason();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'FACTURE_instantane_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //Génération du facture avec MPDF
            $name = 'FACTURE_SECURISE'.$num.'.pdf';
            $target = __DIR__.'/../../../../web/Production_documentaire/factures/';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $factureSpontane->setQrCode($checkqr); 

            $factureSpontane->setPdf('Production_documentaire/factures/'.$name);
            $em->persist($checkqr);
            $em->persist($factureSpontane);
            $em->flush(); 
           
            $pdf = $this->renderView('api/bill.html.twig', array(
                // 'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                //'impotVerif' => $impotVerif,   
                'imageqr'=> $factureSpontane->getQrCode()->getChemin(),
                'factureSpontane'=>$factureSpontane,
                'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
            ));

            try
            {

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1)
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la facture');
                die($e->getMessage());
            }

            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture sécurisé'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSpontane->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSecurise.html.twig',array(
                        'factureSpontane' =>$factureSpontane,
                        'factureSpontaneArticles' => $factureSpontaneArticles,
                    )
                ),
                'text/html'
            )
            ->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg);           
            
            return $this->redirectToRoute('facturespontane_show_securise', array('id' => $factureSpontane->getId()));
        }

        return $this->render('facturesecurise/new.html.twig', array(
            'factureSpontane' => $factureSpontane,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new factureSpontane entity.
     *
     * @Route("/new/secure/publique", name="facturespontane_new_secure_publique")
     * @Method({"GET", "POST"})
     */
    public function newSecurePubliqueAction(Request $request)
    {        
       
        $factureSpontane = new FactureSpontane();
        $form = $this->createForm('AMLA\SqrBundle\Form\FactureSecuriseType', $factureSpontane);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $qte = $request->get('qte');
            $prix = $request->get('prixht'); 
            $tva = $request->get('tva');
            $ir = $request->get('ir'); 
            $designation = $request->get('designation');
            $numeroEncaissement = $request->get('numeroEncaissement');
            $banqueAssocie = $request->get('banqueAssocie');
            $numCompte = $request->get('numCompte');

            switch ($factureSpontane->getModeReglement()) {
                case 'ORANGE':
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'VIREMENT':
                    $factureSpontane->setBanqueReglement($banqueAssocie);
                    $factureSpontane->setNumcomptebanqueReglement($numCompte);                    
                break;
                case 'ORABANK':
                    break;
                case 'MOMO':                    
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'TOUT':

                    break;
                default:
                  //...''
            }


            /*dump($request); dump($factureSpontane->getModeReglement());
            dump($factureSpontane);die;*/
            //dump($request);die;
            for($i = 0; $i < count($designation); $i++)
            {
                $factureSpontaneArticle = new FactureSpontaneArticle();
                $factureSpontaneArticle->setFactureSpontane($factureSpontane);
                $factureSpontaneArticle->setNomArticle($designation[$i]);
                $factureSpontaneArticle->setQuantite($qte[$i]);
                $factureSpontaneArticle->setPrix($prix[$i]);
                $factureSpontaneArticle->setPrixHT($qte[$i] * $prix[$i]);
                $factureSpontaneArticle->setTva(($qte[$i] * $prix[$i]) * $tva / 100);
                $factureSpontaneArticle->setPrixTtc($factureSpontaneArticle->getPrixHT() + $factureSpontaneArticle->getTva());
                $em->persist($factureSpontaneArticle);
                //dump($factureSpontaneArticle);
                //$em->flush();
                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneArticle->getTva());
                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneArticle->getPrixHT());
                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneArticle->getPrixTtc());
            }
            
            //die;
            $factureSpontane->setAttn($factureSpontane->getBeneficiaireSocialReason());
            $factureSpontane->setStatut(0);
            $factureSpontane->setTva($tva);
            $factureSpontane->setIr($ir);
            $factureSpontane->setIrMontant(($factureSpontane->getMontantTotalHt() * $ir) / 100);
            $factureSpontane->setNetApayer(($factureSpontane->getMontantTotalTtc() - $factureSpontane->getIrMontant()));
            $factureSpontane->setAccount($this->getUser());
           

            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontane->getBeneficiaireNiu()]);

            if (empty($frnisseur)) 
            {
                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontane->getBeneficiaireSocialReason()]);
            }
                
            if(!empty($frnisseur))
            {
                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('Reception Facture instantanée');
                $notificationO->setDescription('Une facture instantanée a été émis à votre endroit par le fournisseur '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' dont la référence est'.$factureSpontane->getReference(). '. Vous pouvez consulter le détail dans la section facture spontanée reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }
             /**************Add Notification for sent Bill */
             $notificationI = New Notification();
             $notificationI->setTitle('Emission facture instantanée');
             $notificationI->setDescription('Vous avez émis une nouvelle facture instantanée au fournisseur '.$factureSpontane->getBeneficiaireSocialReason().' '. $factureSpontane->getBeneficiaireNiu().'. La référence pour la facture est '.$factureSpontane->getReference());
             $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
             $em->persist($notificationI);
             /**************End Add Notification */
           

            $cle = $this->getParameter('api_key');
            $piece = 'Facture instantanée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontane->getBeneficiaireNiu().'-'.$factureSpontane->getBeneficiaireSocialReason();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0]){

                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'FACTURE_instantane_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //Génération du facture avec MPDF
            $name = 'FACTURE_SECURISE'.$num.'.pdf';
            $target = __DIR__.'/../../../../web/Production_documentaire/factures/';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $factureSpontane->setQrCode($checkqr); 

            $factureSpontane->setPdf('Production_documentaire/factures/'.$name);
            $em->persist($checkqr);
            $em->persist($factureSpontane);
            $em->flush(); 
           
            $pdf = $this->renderView('api/bill.html.twig', array(
                // 'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                //'impotVerif' => $impotVerif,   
                'imageqr'=> $factureSpontane->getQrCode()->getChemin(),
                'factureSpontane'=>$factureSpontane,
                //'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1)
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la facture');
                die($e->getMessage());
            }


            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture sécurisé'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSpontane->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSecurise.html.twig',array(
                        'factureSpontane' =>$factureSpontane,
                        'factureSpontaneArticles' => $factureSpontaneArticles,
                    )
                ),
                'text/html'
            )
            ->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg);           
            
            return $this->redirectToRoute('facturespontane_show_securise', array('id' => $factureSpontane->getId()));
        }

        return $this->render('facturesecurise/new_publique.html.twig', array(
            'factureSpontane' => $factureSpontane,
            'form' => $form->createView(),
        ));
    }
    /**
     * Finds and displays a factureSpontane entity.
     *
     * @Route("/{id}", name="facturespontane_show")
     * @Method("GET")
     */
    public function showAction(FactureSpontane $factureSpontane)
    {
        $em = $this->getDoctrine()->getManager();
        $deleteForm = $this->createDeleteForm($factureSpontane);

        $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);

        return $this->render('factureinstantanee/show.html.twig', array(
            'factureSpontane' => $factureSpontane,
            'delete_form' => $deleteForm->createView(),
            'factureSpontaneArticles' => $factureSpontaneArticles,
        ));
    }

    /**
     * Finds and displays a factureSpontane entity.
     *
     * @Route("/{id}/secure", name="facturespontane_show_securise")
     * @Method("GET")
     */
    public function showSecureAction(FactureSpontane $factureSpontane)
    {
        $em = $this->getDoctrine()->getManager();
        $deleteForm = $this->createDeleteForm($factureSpontane);

        $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);

        return $this->render('facturesecurise/show.html.twig', array(
            'factureSpontane' => $factureSpontane,
            'delete_form' => $deleteForm->createView(),
            'factureSpontaneArticles' => $factureSpontaneArticles,
        ));
    }


    /**
     * Finds and displays a factureSpontane entity.
     *
     * @Route("/{id}/secure/payment", name="facturespontane_show_secure_payment")
     * @Method("GET")
     */
    public function showSecurePaymentAction(FactureSpontane $factureSpontane)
    {

        return $this->render('facturesecurise/show_public.html.twig', array(
            'factureSpontane' => $factureSpontane,
        ));
    }


    /**
     * Displays a form to edit an existing factureSpontane entity.
     *
     * @Route("/{id}/edit", name="facturespontane_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FactureSpontane $factureSpontane)
    {
        $deleteForm = $this->createDeleteForm($factureSpontane);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FactureSpontaneType', $factureSpontane);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) 
        {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('facturespontane_edit', array('id' => $factureSpontane->getId()));
        }

        return $this->render('factureinstantanee/edit.html.twig', array(
            'factureSpontane' => $factureSpontane,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a factureSpontane entity.
     *
     * @Route("/{id}", name="facturespontane_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FactureSpontane $factureSpontane)
    {
        $form = $this->createDeleteForm($factureSpontane);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();
            $em->remove($factureSpontane);
            $em->flush();
        }

        return $this->redirectToRoute('facturespontane_index');
    }

    /**
     * Creates a form to delete a factureSpontane entity.
     *
     * @param FactureSpontane $factureSpontane The factureSpontane entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FactureSpontane $factureSpontane)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('facturespontane_delete', array('id' => $factureSpontane->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
