<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FactureSpontaneArticle;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Facturespontanearticle controller.
 *
 * @Route("facturespontanearticle/{_locale}", defaults = {"_locale" = "fr"})
 */
class FactureSpontaneArticleController extends Controller
{
    /**
     * Lists all factureSpontaneArticle entities.
     *
     * @Route("/", name="facturespontanearticle_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findAll();

        return $this->render('factureinstantaneearticle/index.html.twig', array(
            'factureSpontaneArticles' => $factureSpontaneArticles,
        ));
    }

    /**
     * Creates a new factureSpontaneArticle entity.
     *
     * @Route("/new", name="facturespontanearticle_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $factureSpontaneArticle = new FactureSpontaneArticle();
        $form = $this->createForm('AMLA\SqrBundle\Form\FactureSpontaneArticleType', $factureSpontaneArticle);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($factureSpontaneArticle);
            $em->flush();

            return $this->redirectToRoute('facturespontanearticle_show', array('id' => $factureSpontaneArticle->getId()));
        }

        return $this->render('factureinstantaneearticle/new.html.twig', array(
            'factureSpontaneArticle' => $factureSpontaneArticle,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a factureSpontaneArticle entity.
     *
     * @Route("/{id}", name="facturespontanearticle_show")
     * @Method("GET")
     */
    public function showAction(FactureSpontaneArticle $factureSpontaneArticle)
    {
        $deleteForm = $this->createDeleteForm($factureSpontaneArticle);

        return $this->render('factureinstantaneearticle/show.html.twig', array(
            'factureSpontaneArticle' => $factureSpontaneArticle,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing factureSpontaneArticle entity.
     *
     * @Route("/{id}/edit", name="facturespontanearticle_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FactureSpontaneArticle $factureSpontaneArticle)
    {
        $deleteForm = $this->createDeleteForm($factureSpontaneArticle);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FactureSpontaneArticleType', $factureSpontaneArticle);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('facturespontanearticle_edit', array('id' => $factureSpontaneArticle->getId()));
        }

        return $this->render('factureinstantaneearticle/edit.html.twig', array(
            'factureSpontaneArticle' => $factureSpontaneArticle,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a factureSpontaneArticle entity.
     *
     * @Route("/{id}", name="facturespontanearticle_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FactureSpontaneArticle $factureSpontaneArticle)
    {
        $form = $this->createDeleteForm($factureSpontaneArticle);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($factureSpontaneArticle);
            $em->flush();
        }

        return $this->redirectToRoute('factureinstantaneearticle_index');
    }

    /**
     * Creates a form to delete a factureSpontaneArticle entity.
     *
     * @param FactureSpontaneArticle $factureSpontaneArticle The factureSpontaneArticle entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FactureSpontaneArticle $factureSpontaneArticle)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('factureinstantaneearticle_delete', array('id' => $factureSpontaneArticle->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
