<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\FactureSimple;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 

/**
 * Facturesimple controller.
 *
 * @Route("facturesimple/{_locale}", defaults = {"_locale" = "fr"})
 */
class FactureSimpleController extends Controller
{
    /**
     * Lists all factureSimple entities.
     *
     * @Route("/", name="facturesimple_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        //$this->status = 0;//0=En attente // 1= Payée // 2=rejetée
        $factureSimpleNonTraites = $em->getRepository('AMLASqrBundle:FactureSimple')->findBy(['status'=>0]);
        if ($factureSimpleNonTraites) 
        {
            # code...
            foreach ($factureSimpleNonTraites as $key) 
            {
            # code...
                $rep = $this->updateStatus($key);
            }
        }

        $factureSimples = $em->getRepository('AMLASqrBundle:FactureSimple')->findBy([],['id'=>'DESC']);

        return $this->render('facturesimple/index.html.twig', array(
            'factureSimples' => $factureSimples,
            //'repl'
        ));
    }
    
    /**
     * Lists all factureSimple entities.
     *
     * @Route("/", name="facturesimple_mine_index")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factureSimples = $em->getRepository('AMLASqrBundle:FactureSimple')->findBy(['account'=>$this->getAccount()]);

        return $this->render('facturesimple/index.html.twig', array(
            'factureSimples' => $factureSimples,
        ));
    }

    /**
     * Creates a new factureSimple entity.
     *
     * @Route("/new", name="facturesimple_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $factureSimple = new Facturesimple();
        $form = $this->createForm('AMLA\SqrBundle\Form\FactureSimpleSecuriseType', $factureSimple);
        $form->handleRequest($request);

        //dump($factureSimple);die;
        if ($form->isSubmitted() && $form->isValid()) 
        {
            //$res = preg_replace("/\++$/", "", $factureSimple->getNumber());
            //$res = rtrim($factureSimple->getNumber(), "+");
            //$res = str_replace("+", "", $factureSimple->getNumber());
            //dump($factureSimple->getNumber());dump($res);die;
            $em = $this->getDoctrine()->getManager();
            
            $cle = $this->getParameter('api_key');
            $piece = 'Facture instantanée';
            $proprietaire = $this->getUser()->fullName();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 

                $newname = 'FACTURE_simple_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $factureSimple->setQrCode($checkqr); 
                //dump($factureSimple);die;

                switch ($factureSimple->getCanal())
                {
                    case 'MOMO':

                        $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                        try 
                        {                  
                            $response = $client->request('POST', $this->getParameter('epayment_base_url').'mtn/initiate/payment/MTN', [
                            'form_params'=> [ 
                                    "cle"=>$cle,
                                    "amount"=>intVal($factureSimple->getAmount()),
                                    "currency"=>"XAF",
                                    "clientEId"=>$num,
                                    "partyId"=> str_replace("+", "", $factureSimple->getNumber())/*$factureSimple->getNumber()*/,
                                    'proprietaire' => $proprietaire, 
                                    /*"payer"=> [
                                        "partyIdType"=>"MSISDN",
                                        //"partyId"=> "237673126161",
                                        "partyId"=> $numero,
                                    ],*/
                                    "payerMessage"=>'Paiement Facture Simple',
                                    "payeeNote"=>'Paiement Facture Simple',
                                ]
                            ]);
                
                            /*$code =  $response->getStatusCode(); # 200
                            $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                            $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                            
                            $ret = json_decode($body, true);  
                            
                        } catch (\GuzzleHttp\Exception\ConnectException $th)
                        {
                            //die('bam');
                            throw $th;
                            // $rep ='ERREUR';
                            //die();
                            $reply = 0;
                        }

                        break; 
                    case 'ORANGE':
                        $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                        try 
                        {                  
                            $response = $client->request('POST', $this->getParameter('epayment_base_url').'orange/initiate/payment/orange', [
                            'form_params'=> [ 
                                    "cle"=>$cle,
                                    "amount"=>intVal($factureSimple->getAmount()),
                                    "clientEId"=>$num,
                                    "number"=> str_replace("+237", "", $factureSimple->getNumber())
                                ]
                            ]);
                
                            $body =  (string)$response->getBody();                             
                            $ret = json_decode($body, true);  
                            
                        } catch (\GuzzleHttp\Exception\ConnectException $th)
                        {
                            //die('bam');
                            throw $th;
                            // $rep ='ERREUR';
                            //die();
                            $reply = 0;
                        }

                        break;                    
                    default:
                        # code...
                        break;
                }
                //dump($ret);
                if($ret['status_code'] =="Application non autorisé ou Clé API incorrecte" || $ret['status_code'] =="Erreur lors de la transaction. Essayez à nouveau" || $ret['status_code'] =="Paramètre(s) manquant(s)" || $ret['status_code'] =="Erreur lors de la génération du jeton de paiement")
                {
                    $reply = 0;
                    $this->get('session')->getFlashBag()->add('warning', "Impossible de traiter la demande, l'une des parties est momentanement hors service. Veuillez réessayer plus tard...");
                }else
                {
                    $factureSimple->setAccount($this->getUSer());
                    $factureSimple->setPayRef($ret['uuid']);
                    $em->persist($checkqr);
                    $em->persist($factureSimple);
                    $em->flush(); //transaction_ref
                    return $this->redirectToRoute('facturesimple_show', array('id' => $factureSimple->getId()));
                }
                //dump($factureSimple);die;
                
            }
        }

        return $this->render('facturesimple/new.html.twig', array(
            'factureSimple' => $factureSimple,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a factureSimple entity.
     *
     * @Route("/{id}", name="facturesimple_show")
     * @Method("GET")
     */
    public function showAction(FactureSimple $factureSimple)
    {
        $deleteForm = $this->createDeleteForm($factureSimple);
        $em = $this->getDoctrine()->getManager();
        /* 
            $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
            try 
            {                  
                $response = $client->request('POST', 'http://payment.authentinov.com/mtn/client/request/status', 
                [
                    'form_params'=> 
                    [ 
                        "cle"=>$this->getParameter('api_key'),
                        "clientEId"=>$factureSimple->getQrCode()->getNumero(),
                    ]
                ]);

                //$code =  $response->getStatusCode(); # 200
                
                //$header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'
                $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                $ret = json_decode($body, true);  

               // dump($ret);dump($ret['date_paid']['date']);die;
                if($ret['request_id'] == 'null' || $ret['status'] == 'status')
                {
                    $reply = 0;
                }else
                {
                    if ($ret['status']=='SUCCESSFUL') 
                    {
                        # code...
                        if($ret['date_paid'] == 'null')
                        {
                            # code...
                            $date = new \Datetime();
                        }else
                        {
                            $date =new \Datetime($ret['date_paid']['date']);
                        }
                        $factureSimple->setStatus(1);
                        $factureSimple->setDatePaid($date);
                        $em->persist($factureSimple);
                    }elseif($ret['status']=='FAILED')
                    {
                        # code...
                        # code...
                        if ($ret['date_paid'] == 'null') 
                        {
                            # code...
                            $date = new \Datetime();
                        }else
                        {
                            $date =new \Datetime($ret['date_paid']['date']);
                        }
                        $factureSimple->setStatus(2);
                        $factureSimple->setDatePaid($date);
                        $em->persist($factureSimple);
                    }

                    $em->flush();
                    //*$em->persist($checkqr);
                    $reply = 1;
                }
                //dump($ret);die;                
                
            } catch (\GuzzleHttp\Exception\ConnectException $th)
            {
                //die('bam');
                throw $th;
                // $rep ='ERREUR';
                //die();
                $reply = 0;
            }
        */
        $rep = $this->updateStatus($factureSimple);

        return $this->render('facturesimple/show.html.twig', array(
            'factureSimple' => $factureSimple,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing factureSimple entity.
     *
     * @Route("/{id}/edit", name="facturesimple_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, FactureSimple $factureSimple)
    {
        $deleteForm = $this->createDeleteForm($factureSimple);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FactureSimpleType', $factureSimple);
        $editForm->handleRequest($request);

        if($editForm->isSubmitted() && $editForm->isValid())
        {
            $this->getDoctrine()->getManager()->flush();
            return $this->redirectToRoute('facturesimple_edit', array(
                'id' => $factureSimple->getId()
            ));
        }

        return $this->render('facturesimple/edit.html.twig', array(
            'factureSimple' => $factureSimple,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a factureSimple entity.
     *
     * @Route("/{id}", name="facturesimple_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, FactureSimple $factureSimple)
    {
        $form = $this->createDeleteForm($factureSimple);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $em->remove($factureSimple);
            $em->flush();
        }

        return $this->redirectToRoute('facturesimple_index');
    }

    /**
     * Creates a form to delete a factureSimple entity.
     *
     * @param FactureSimple $factureSimple The factureSimple entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(FactureSimple $factureSimple)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('facturesimple_delete', array('id' => $factureSimple->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    private function updateStatus (FactureSimple $key)
    {
        $em = $this->getDoctrine()->getManager();

        switch ($key->getCanal()) 
        {
            case 'MOMO':
                $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                try 
                {                  
                    $response = $client->request('POST', 'http://payment.authentinov.com/mtn/client/request/status', [
                    'form_params'=> [ 
                            "cle"=>$this->getParameter('api_key'),
                            "clientEId"=>$key->getQrCode()->getNumero(),
                        ]
                    ]);

                    /*$code =  $response->getStatusCode(); # 200

                    $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                    $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                    $ret = json_decode($body, true);  

                   // dump($ret);dump($ret['date_paid']['date']);die;
                    if($ret['request_id'] == 'null' || $ret['status'] =='status')
                    {
                        $reply = 0;
                    }else
                    {
                        if ($ret['status']=='SUCCESSFUL') 
                        {
                            # code...
                            if ($ret['date_paid'] == 'null') 
                            {
                                # code...
                                $date = new \Datetime();
                            }else
                            {
                                $date =new \Datetime($ret['date_paid']['date']);
                            }
                            $key->setStatus(1);
                            $key->setDatePaid($date);
                            $em->persist($key);
                        }elseif ($ret['status']=='FAILED') 
                        {
                            # code...
                            # code...
                            if ($ret['date_paid'] == 'null') 
                            {
                                # code...
                                $date = new \Datetime();
                            }else
                            {
                                $date =new \Datetime($ret['date_paid']['date']);
                            }
                            $key->setStatus(2);
                            $key->setDatePaid($date);
                            $em->persist($key);
                        }

                        $em->flush();
                        //*$em->persist($checkqr);
                        $reply = 1;
                    }
                    //dump($ret);die;                
                    
                } catch (\GuzzleHttp\Exception\ConnectException $th)
                {
                    //die('bam');
                    throw $th;
                    // $rep ='ERREUR';
                    //die();
                    $reply = 0;
                }
                break;
            case 'ORANGE':
                $client = new \GuzzleHttp\Client([ 'timeout'=> 10.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                try 
                {                  
                    $response = $client->request('POST', 'http://payment.authentinov.com/orange/client/request/status', [
                    'form_params'=> [ 
                            "cle"=>$this->getParameter('api_key'),
                            "clientEId"=>$key->getPayRef(),
                        ]
                    ]);

                    /*$code =  $response->getStatusCode(); # 200

                    $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                    $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                    $ret = json_decode($body, true);  

                   // dump($ret);dump($ret['date_paid']['date']);die;
                    if($ret['request_id'] == 'null' || $ret['status'] =='status')
                    {
                        $reply = 0;
                    }else
                    {
                        date_default_timezone_set('Africa/Douala');
                        $date = new \Datetime();
                        # code...
                        /*if ($ret['date_paid'] == 'null') 
                        {
                            # code...
                            $date = new \Datetime();
                        }else
                        {
                            $date =new \Datetime($ret['date_paid']['date']);
                        }*/

                        if ($ret['status']=='SUCCESSFULL') 
                        {
                            $key->setStatus(1);
                            $key->setDatePaid($date);
                            $em->persist($key);
                        }elseif ($ret['status']=='FAILED' || $ret['status']=='CANCELLED') 
                        {
                            $key->setStatus(2);
                            $key->setDatePaid($date);
                            $em->persist($key);
                        }

                        $em->flush();
                        //*$em->persist($checkqr);
                        $reply = 1;
                    }
                    //dump($ret);die;                
                    
                } catch (\GuzzleHttp\Exception\ConnectException $th)
                {
                    //die('bam');
                    throw $th;
                    // $rep ='ERREUR';
                    //die();
                    $reply = 0;
                }

                break;
            
            default:
                # code...
                break;
        }

        return $reply;
    }
}
