<?php

namespace AMLA\SqrBundle\Controller;


use AMLA\SqrBundle\Entity\IsParam;
use Mpdf\Mpdf;
use Mpdf\MpdfException;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\LabelAlignment;
use AMLA\SqrBundle\Entity\TvaParam;
use AMLA\SqrBundle\Entity\Facture;
use AMLA\SqrBundle\Entity\CheckQr;
use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\Facturesimple;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use Endroid\QrCode\ErrorCorrectionLevel;
use AMLA\SqrBundle\Entity\FactureSpontane;
use AMLA\SqrBundle\Entity\ReceptionTravaux;
use Endroid\QrCode\Response\QrCodeResponse;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\Entity\FactureSpontaneArticle;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Facture controller.
 *
 * @Route("facture/{_locale}", defaults = {"_locale" = "fr"})
 */
class FactureController extends Controller
{
    /**
     * Lists all facture entities.
     *
     * @Route("/", name="facture_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $factures = $em->getRepository('AMLASqrBundle:Facture')->findAll();

        return $this->render('facture/index.html.twig', array(
            'factures' => $factures,
        ));
    }

    /**
     * Lists all facture entities.
     *
     * @Route("/recus", name="facture_recus")
     * @Method("GET")
     */
    public function facturesRecusAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        //$factures = $em->getRepository('AMLASqrBundle:Facture')->findAll();
        $factures = $em->getRepository('AMLASqrBundle:Facture')->getFactureReceive($fournisseur);
        return $this->render('facture/facturerecus.html.twig', array(
            'factures' => $factures,
        ));
    }
    
    /**
     * Lists all facture entities.
     *
     * @Route("/emis", name="facture_emis")
     * @Method("GET")
     */
    public function facturesEmisAction()
    {
        $em = $this->getDoctrine()->getManager(); 

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        //$factures = $em->getRepository('AMLASqrBundle:Facture')->findAll();
        $factures = $em->getRepository('AMLASqrBundle:Facture')->getFactureSent($fournisseur);

        return $this->render('facture/factureemis.html.twig', array(
            'factures' => $factures,
        ));
    }

    /**
     * Lists all facture entities.
     *
     * @Route("/nouveaux", name="facture_nouveaux")
     * @Method({"GET", "POST"})
     */
    public function facturesNewAction(Request $request)
    {
        //dump($request);die;
        $em = $this->getDoctrine()->getManager();

        $tvaParam = $em->getRepository('AMLASqrBundle:TvaParam')->findOneBy(['id'=>1]);
        if(!$tvaParam)
        {
            $tvaParam = new TvaParam();
            $tvaParam->setTva('19.25');
            $em->persist($tvaParam);
            $em->flush();
        }

        $isParams = $em->getRepository('AMLASqrBundle:IsParam')->findAll();
        if(empty($isParams))
        {
            $isTab = [20, 15, 14, 10, 5, 2];
            foreach($isTab as $tab)
            {
                $isParam = $em->getRepository('AMLASqrBundle:IsParam')->findBy(['isRate'=>$tab]);
                if(empty($isParam))
                {
                    $isRate = new IsParam();
                    $isRate->setIsRate($tab);
                    $em->persist($isRate);
                }
            }
            $em->flush();
        }
        $isParams = $em->getRepository('AMLASqrBundle:isParam')->findAll();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        //$receptionTravauxes = $em->getRepository('AMLASqrBundle:ReceptionTravaux')->getTravauxRealises($fournisseur);

        //Facture Simple
        $factureSpontane = new FactureSpontane();
        $formFactureSpontane = $this->createForm('AMLA\SqrBundle\Form\FactureSpontaneType', $factureSpontane);
        $formFactureSpontane->handleRequest($request);

        if ($formFactureSpontane->isSubmitted() && $formFactureSpontane->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $qte = $request->get('qte');
            $prix = $request->get('prixht'); 
            $tva = $request->get('tva');
            $ir = $request->get('ir'); 
            $designation = $request->get('designation');
            $numeroEncaissement = $request->get('numeroEncaissement');
            $banqueAssocie = $request->get('banqueAssocie');
            $numCompte = $request->get('numCompte');

            switch ($factureSpontane->getModeReglement()) 
            {
                case 'ORANGE':
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'VIREMENT':
                    $factureSpontane->setBanqueReglement($banqueAssocie);
                    $factureSpontane->setNumcomptebanqueReglement($numCompte);                    
                break;
                case 'ORABANK':

                    break;
                case 'MOMO':                    
                    $factureSpontane->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'TOUT':

                    break;
                default:
                  //...''
            }

            /*dump($request); dump($factureSpontane->getModeReglement());
            dump($factureSpontane);die;*/
            //dump($request);die;
            for($i = 0; $i < count($designation); $i++)
            {
                $factureSpontaneArticle = new FactureSpontaneArticle();
                $factureSpontaneArticle->setFactureSpontane($factureSpontane);
                $factureSpontaneArticle->setNomArticle($designation[$i]);
                $factureSpontaneArticle->setQuantite($qte[$i]);
                $factureSpontaneArticle->setPrix($prix[$i]);
                $factureSpontaneArticle->setPrixHT($qte[$i] * $prix[$i]);
                $factureSpontaneArticle->setTva(($qte[$i] * $prix[$i]) * $tva / 100);
                $factureSpontaneArticle->setPrixTtc($factureSpontaneArticle->getPrixHT() + $factureSpontaneArticle->getTva());
                $em->persist($factureSpontaneArticle);
                //dump($factureSpontaneArticle);
                //$em->flush();
                $factureSpontane->setMontantTotalTva($factureSpontane->getMontantTotalTva() + $factureSpontaneArticle->getTva());
                $factureSpontane->setMontantTotalHt($factureSpontane->getMontantTotalHt() + $factureSpontaneArticle->getPrixHT());
                $factureSpontane->setMontantTotalTtc($factureSpontane->getMontantTotalTtc() + $factureSpontaneArticle->getPrixTtc());
            }
            
            //die;
            $factureSpontane->setStatut(0);
            $factureSpontane->setTva($tva);
            $factureSpontane->setIr($ir);
            $factureSpontane->setIrMontant(($factureSpontane->getMontantTotalHt() * $ir) / 100);
            $factureSpontane->setNetApayer(($factureSpontane->getMontantTotalTtc() - $factureSpontane->getIrMontant()));
            $factureSpontane->setAccount($this->getUser());
           

            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontane->getBeneficiaireNiu()]);

            if (empty($frnisseur)) 
            {
                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontane->getBeneficiaireSocialReason()]);
            }
                
            if(!empty($frnisseur))
            {
                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('Reception Facture instantanée');
                $notificationO->setDescription('Une facture instantanée a été émis à votre endroit par le fournisseur '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' dont la référence est'.$factureSpontane->getReference(). '. Vous pouvez consulter le détail dans la section facture spontanée reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }
                /**************Add Notification for sent Bill */
                $notificationI = New Notification();
                $notificationI->setTitle('Emission facture instantanée');
                $notificationI->setDescription('Vous avez émis une nouvelle facture instantanée au fournisseur '.$factureSpontane->getBeneficiaireSocialReason().' '. $factureSpontane->getBeneficiaireNiu().'. La référence pour la facture est '.$factureSpontane->getReference());
                $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
                $em->persist($notificationI);
                /**************End Add Notification */
           
            $cle = $this->getParameter('api_key');
            $piece = 'Facture instantanée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontane->getBeneficiaireNiu().'-'.$factureSpontane->getBeneficiaireSocialReason();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'FACTURE_instantane_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $factureSpontane->setQrCode($checkqr); 
           
            //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/FacturesInstantane/';
            //$target = __DIR__.'/../../../../web/generated/Factures/facture_'.$factureSpontane->getId().'/emetteur_'.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().'/destinataire'.$factureSpontane->getBeneficiaireSocialReason().'/';
            
            $name = $num.'.pdf';
            /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
            die; */
           
            $factureSpontane->setPdf('generated/FacturesInstantane/'.$name);
            $em->persist($checkqr);
            $em->persist($factureSpontane);
            $em->flush(); 
            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontane]);
             $pdf = $this->renderView('print/facture_instantane.html.twig', array(
                'factureSpontane' =>$factureSpontane,
                'factureSpontaneArticles' => $factureSpontaneArticles,                
                'imageqr'=> $factureSpontane->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));
            try{
                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) 
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la facture');
            }

            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture simple'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSpontane->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSpontanee.html.twig',array(
                        'factureSpontane' =>$factureSpontane,
                        'factureSpontaneArticles' => $factureSpontaneArticles,
                    )
                ),
                'text/html'
            );
            //->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg);

            return $this->redirectToRoute('facturespontane_show', array('id' => $factureSpontane->getId()));
        }

        // Facture OTC
        $factureSimple = new Facturesimple();
        $formFactureOtc = $this->createForm('AMLA\SqrBundle\Form\FactureSimpleType', $factureSimple);
        $formFactureOtc->handleRequest($request);

        if ($formFactureOtc->isSubmitted() && $formFactureOtc->isValid()) 
        {
            //$res = preg_replace("/\++$/", "", $factureSimple->getNumber());
            //$res = rtrim($factureSimple->getNumber(), "+");
            //$res = str_replace("+", "", $factureSimple->getNumber());
            //dump($factureSimple->getNumber());dump($res);die;
            $em = $this->getDoctrine()->getManager();
            
            $cle = $this->getParameter('api_key');
            $piece = 'Facture OTC';
            $proprietaire = $this->getUser()->fullName();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 

                $newname = 'FACTURE_simple_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $factureSimple->setQrCode($checkqr); 
                //dump($factureSimple);die;

                switch ($factureSimple->getCanal())
                {
                    case 'MOMO':

                        $client = new \GuzzleHttp\Client([ 'timeout'=> 160.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                        try 
                        {                  
                            $response = $client->request('POST', $this->getParameter('epayment_base_url').'mtn/initiate/payment/MTN', [
                            'form_params'=> [ 
                                    "cle"=>$cle,
                                    "amount"=>intVal($factureSimple->getAmount()),
                                    "currency"=>"XAF",
                                    "clientEId"=>$num,
                                    "partyId"=> str_replace("+", "", $factureSimple->getNumber())/*$factureSimple->getNumber()*/,
                                    'proprietaire' => $proprietaire, 
                                    /*"payer"=> [
                                        "partyIdType"=>"MSISDN",
                                        //"partyId"=> "237673126161",
                                        "partyId"=> $numero,
                                    ],*/
                                    "payerMessage"=>'Paiement Facture Simple',
                                    "payeeNote"=>'Paiement Facture Simple',
                                ]
                            ]);
                
                            /*$code =  $response->getStatusCode(); # 200
                            $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                            $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                            
                            $ret = json_decode($body, true);  
                            
                        } catch (\GuzzleHttp\Exception\ConnectException $th)
                        {
                            //die('bam');
                            throw $th;
                            // $rep ='ERREUR';
                            //die();
                            $reply = 0;
                        }

                        break; 
                    case 'ORANGE':
                        $client = new \GuzzleHttp\Client([ 'timeout'=> 160.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                        try 
                        {                  
                            $response = $client->request('POST', $this->getParameter('epayment_base_url').'orange/initiate/payment/orange', [
                            'form_params'=> [ 
                                    "cle"=>$cle,
                                    "amount"=>intVal($factureSimple->getAmount()),
                                    "clientEId"=>$num,
                                    "number"=> str_replace("+237", "", $factureSimple->getNumber())
                                ]
                            ]);
                
                            $body =  (string)$response->getBody();                             
                            $ret = json_decode($body, true);  
                            
                        } catch (\GuzzleHttp\Exception\ConnectException $th)
                        {
                            //die('bam');
                            throw $th;
                            // $rep ='ERREUR';
                            //die();
                            $reply = 0;
                        }

                        break;                    
                    default:
                        # code...
                        break;
                }

                if($ret['status_code'] =="Application non autorisé ou Clé API incorrecte" || $ret['status_code'] =="Erreur lors de la transaction. Essayez à nouveau" || $ret['status_code'] =="Paramètre(s) manquant(s)" || $ret['status_code'] =="Erreur lors de la génération du jeton de paiement")
                {
                    $reply = 0;
                    $factureSimple->setStatus(2);
                }else
                {
                    $factureSimple->setPayRef($ret['uuid']);
                }
                //dump($ret);die;
                $factureSimple->setAccount($this->getUSer());
                $em->persist($checkqr);
                $em->persist($factureSimple);
                $em->flush(); //transaction_ref

                return $this->redirectToRoute('facturesimple_show', array('id' => $factureSimple->getId()));
            }
        }


        // Facture OTC
        $factureSimpleSecurise = new Facturesimple();
        $formFactureOtcSecurise = $this->createForm('AMLA\SqrBundle\Form\FactureSimpleSecuriseType', $factureSimple);
        $formFactureOtcSecurise->handleRequest($request);

        if ($formFactureOtcSecurise->isSubmitted() && $formFactureOtcSecurise->isValid()) 
        {
            //$res = preg_replace("/\++$/", "", $factureSimple->getNumber());
            //$res = rtrim($factureSimple->getNumber(), "+");
            //$res = str_replace("+", "", $factureSimple->getNumber());
            //dump($factureSimple->getNumber());dump($res);die;
            $em = $this->getDoctrine()->getManager();
            
            $cle = $this->getParameter('api_key');
            $piece = 'Facture OTC';
            $proprietaire = $this->getUser()->fullName();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 

                $newname = 'FACTURE_simple_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $factureSimpleSecurise->setQrCode($checkqr); 
                //dump($factureSimple);die;

                switch ($factureSimpleSecurise->getCanal())
                {
                    case 'MOMO':

                        $client = new \GuzzleHttp\Client([ 'timeout'=> 160.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                        try 
                        {                  
                            $response = $client->request('POST', $this->getParameter('epayment_base_url').'mtn/initiate/payment/MTN', [
                            'form_params'=> [ 
                                    "cle"=>$cle,
                                    "amount"=>intVal($factureSimpleSecurise->getAmount()),
                                    "currency"=>"XAF",
                                    "clientEId"=>$num,
                                    "partyId"=> str_replace("+237", "", $factureSimpleSecurise->getNumber())/*$factureSimpleSecurise->getNumber()*/,
                                    'proprietaire' => $proprietaire, 
                                    /*"payer"=> [
                                        "partyIdType"=>"MSISDN",
                                        //"partyId"=> "237673126161",
                                        "partyId"=> $numero,
                                    ],*/
                                    "payerMessage"=>'Paiement Facture Simple',
                                    "payeeNote"=>'Paiement Facture Simple',
                                ]
                            ]);
                
                            /*$code =  $response->getStatusCode(); # 200
                            $header =  $response->getHeaderLine('content-type'); # 'application/json; charset=utf8'*/
                            $body =  (string)$response->getBody(); # '{"id": 1420053, "name": "guzzle", ...}'
                            
                            $ret = json_decode($body, true);  
                            
                        } catch (\GuzzleHttp\Exception\ConnectException $th)
                        {
                            //die('bam');
                            throw $th;
                            // $rep ='ERREUR';
                            //die();
                            $reply = 0;
                        }

                        break; 
                    case 'ORANGE':
                        $client = new \GuzzleHttp\Client([ 'timeout'=> 160.0, 'verify' =>$this->get('kernel')->getRootDir().'/../web/SSL/cacert.pem']);
                        try 
                        {                  
                            $response = $client->request('POST', $this->getParameter('epayment_base_url').'orange/initiate/payment/orange', [
                            'form_params'=> [ 
                                    "cle"=>$cle,
                                    "amount"=>intVal($factureSimpleSecurise->getAmount()),
                                    "clientEId"=>$num,
                                    "number"=> str_replace("+237", "", $factureSimpleSecurise->getNumber())
                                ]
                            ]);
                
                            $body =  (string)$response->getBody();                             
                            $ret = json_decode($body, true);  
                            
                        } catch (\GuzzleHttp\Exception\ConnectException $th)
                        {
                            //die('bam');
                            throw $th;
                            // $rep ='ERREUR';
                            //die();
                            $reply = 0;
                        }

                        break;                    
                    default:
                        # code...
                        break;
                }

                if($ret['status_code'] =="Application non autorisé ou Clé API incorrecte" || $ret['status_code'] =="Erreur lors de la transaction. Essayez à nouveau" || $ret['status_code'] =="Paramètre(s) manquant(s)" || $ret['status_code'] =="Erreur lors de la génération du jeton de paiement")
                {
                    $reply = 0;
                    $factureSimpleSecurise->setStatus(2);
                }else
                {
                    $factureSimpleSecurise->setPayRef($ret['uuid']);
                }

                $factureSimpleSecurise->setAccount($this->getUSer());
                $em->persist($checkqr);
                $em->persist($factureSimpleSecurise);
                $em->flush(); //transaction_ref

                
                return $this->redirectToRoute('facturesimple_show', array('id' => $factureSimpleSecurise->getId()));
            }
        }

        // Facture Simple
        $factureSpontaneReport = new FactureSpontane();
        $formFactureSpontaneReport = $this->createForm('AMLA\SqrBundle\Form\FactureSpontaneReportType', $factureSpontaneReport);
        $formFactureSpontaneReport->handleRequest($request);

        if($formFactureSpontaneReport->isSubmitted() && $formFactureSpontaneReport->isValid())
        {
            $em = $this->getDoctrine()->getManager();
            $qte = $request->get('qte');
            $prix = $request->get('prixht'); 
            $tva = $request->get('tva');
            $ir = $request->get('ir'); 
            $designation = $request->get('designation');
            $numeroEncaissement = $request->get('numeroEncaissement');
            $banqueAssocie = $request->get('banqueAssocie');
            $numCompte = $request->get('numCompte');

            switch ($factureSpontaneReport->getModeReglement())
            {
                case 'ORANGE':
                    $factureSpontaneReport->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'VIREMENT':
                    $factureSpontaneReport->setBanqueReglement($banqueAssocie);
                    $factureSpontaneReport->setNumcomptebanqueReglement($numCompte);                    
                break;
                case 'ORABANK':

                    break;
                case 'MOMO':                    
                    $factureSpontaneReport->setTelephoneMomoReglement($numeroEncaissement);
                    break;
                case 'TOUT':

                    break;
                default:
                  //...''
            }


            /*dump($request); dump($factureSpontane->getModeReglement());
            dump($factureSpontane);die;*/
            //dump($request);die;
            for($i = 0; $i < count($designation); $i++)
            {
                $factureSpontaneArticleReport = new FactureSpontaneArticle();
                $factureSpontaneArticleReport->setFactureSpontane($factureSpontaneReport);
                $factureSpontaneArticleReport->setNomArticle($designation[$i]);
                $factureSpontaneArticleReport->setQuantite($qte[$i]);
                $factureSpontaneArticleReport->setPrix($prix[$i]);
                $factureSpontaneArticleReport->setPrixHT($qte[$i] * $prix[$i]);
                $factureSpontaneArticleReport->setTva(($qte[$i] * $prix[$i]) * $tva / 100);
                $factureSpontaneArticleReport->setPrixTtc($factureSpontaneArticleReport->getPrixHT() + $factureSpontaneArticleReport->getTva());
                $em->persist($factureSpontaneArticleReport);
                //dump($factureSpontaneArticle);
                //$em->flush();
                $factureSpontaneReport->setMontantTotalTva($factureSpontaneReport->getMontantTotalTva() + $factureSpontaneArticleReport->getTva());
                $factureSpontaneReport->setMontantTotalHt($factureSpontaneReport->getMontantTotalHt() + $factureSpontaneArticleReport->getPrixHT());
                $factureSpontaneReport->setMontantTotalTtc($factureSpontaneReport->getMontantTotalTtc() + $factureSpontaneArticleReport->getPrixTtc());
            }
            
            //die;
            $factureSpontaneReport->setStatut(0);
            $factureSpontaneReport->setTva($tva);
            $factureSpontaneReport->setIr($ir);
            $factureSpontaneReport->setIrMontant(($factureSpontaneReport->getMontantTotalHt() * $ir) / 100);
            $factureSpontaneReport->setNetApayer(($factureSpontaneReport->getMontantTotalTtc() - $factureSpontaneReport->getIrMontant()));
            $factureSpontaneReport->setAccount($this->getUser());
           
            $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$factureSpontaneReport->getBeneficiaireNiu()]);

            if (empty($frnisseur)) 
            {
                $frnisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$factureSpontaneReport->getBeneficiaireSocialReason()]);
            }
                
            if(!empty($frnisseur))
            {
                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('Reception Facture instantanée');
                $notificationO->setDescription('Une facture instantanée a été émis à votre endroit par le fournisseur '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' - '.$this->getUser()->getFournisseurs()[0]->getNiu().' dont la référence est'.$factureSpontaneReport->getReference(). '. Vous pouvez consulter le détail dans la section facture spontanée reçues');
                $notificationO->setFournisseur($frnisseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }

            /**************Add Notification for sent Bill */
            $notificationI = New Notification();
            $notificationI->setTitle('Emission facture instantanée');
            $notificationI->setDescription('Vous avez émis une nouvelle facture instantanée au fournisseur '.$factureSpontaneReport->getBeneficiaireSocialReason().' '. $factureSpontane->getBeneficiaireNiu().'. La référence pour la facture est '.$factureSpontane->getReference());
            $notificationI->setFournisseur($this->getUser()->getFournisseurs()[0]); 
            $em->persist($notificationI);
            /**************End Add Notification */
           
            $cle = $this->getParameter('api_key');
            $piece = 'Facture instantanée';
            $proprietaire = 'Emetteur: '.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().' '.'Destinataire: '.$factureSpontaneReport->getBeneficiaireNiu().'-'.$factureSpontaneReport->getBeneficiaireSocialReason();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'FACTURE_instantane_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $factureSpontaneReport->setQrCode($checkqr); 
           
            //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/FacturesInstantane/';
            //$target = __DIR__.'/../../../../web/generated/Factures/facture_'.$factureSpontane->getId().'/emetteur_'.$this->getUser()->getFournisseurs()[0]->getRaisonSociale().'/destinataire'.$factureSpontane->getBeneficiaireSocialReason().'/';
            
            $name = $num.'.pdf';
            /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
            die; */
           
            $factureSpontaneReport->setPdf('generated/FacturesInstantane/'.$name);
            $em->persist($checkqr);
            $em->persist($factureSpontaneReport);
            $em->flush();

            $factureSpontaneArticles = $em->getRepository('AMLASqrBundle:FactureSpontaneArticle')->findBy(['factureSpontane'=>$factureSpontaneReport]);
             $pdf = $this->renderView('print/facture_instantane.html.twig', array(
                'factureSpontane' =>$factureSpontaneReport,
                'factureSpontaneArticles' => $factureSpontaneArticleReport,                
                'imageqr'=> $factureSpontaneReport->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));
            try{
                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) {

                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else{
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e){

                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\'émission de la facture');
            }

            //dump($factureSpontaneArticles);die;
            $msg = (new \Swift_Message('CHECKTATOO - Facture simple'))
            ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
            ->setTo($factureSpontaneReport->getBeneficiaireEmail())
            ->setBody(
                $this->renderView(
                    'emails/emissionFactureSpontanee.html.twig',array(
                        'factureSpontane' =>$factureSpontaneReport,
                        'factureSpontaneArticles' => $factureSpontaneArticleReport,
                    )
                ),
                'text/html'
            );
            //->attach(\Swift_Attachment::fromPath($target.$name));
            $this->get('mailer')->send($msg);
            return $this->redirectToRoute('facturespontane_show', array('id' => $factureSpontaneReport->getId()));
        }
        
        return $this->render('facture/emissionfacture.html.twig', array(
            //'receptionWorks' => $receptionTravauxes,
            'formFactureSpontane'=>$formFactureSpontane->createView(),
            'formFactureOtcSecurise'=>$formFactureOtcSecurise->createView(),
            //'factureSimpleSecurise'=>$factureSimpleSecurise->createView(),
            'formFactureOtc'=>$formFactureOtc->createView(),
            'formFactureSpontaneReport'=>$formFactureSpontaneReport->createView(),
            'tva'=>$tvaParam,
            'isParams'=>$isParams,
        ));
    }


    /**
     * Creates a new facture entity.
     *
     * @Route("/{id}/reception/to/facture/", name="facture_reception_new")
     * @Method({"GET", "POST"})
     */
    public function newFactureFromReceptionAction(Request $request, ReceptionTravaux $receptionTravaux)
    {
        
        $em = $this->getDoctrine()->getManager();
        //génération de la facture MPDF
        $facture = new Facture();

        $receptionTravaux->setStatut(2);
        $facture->setReceptionTravaux($receptionTravaux);

        //calcule du montant
        $bonCommande = $receptionTravaux->getBonCommande();
        $tauxValidé= $receptionTravaux->getPourcentageReception();
        $montantFacture= ($bonCommande->getMontant() * $tauxValidé) /100;

        $facture->setMontant($montantFacture);
        //dump($facture);die;
        $bcRP=$bonCommande->getRestePaye();
        $bvNRP=$bcRP-$montantFacture;

        $bonCommande->setRestePaye($bvNRP);

                // Génération du document ATD MPDF*******************************
                
                $this->container->getParameter('api_key');
                $cle = $this->container->getParameter('api_key');
                $piece = 'Facture';
                $proprietaire = 'facture';

                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece, 
                    'proprietaire' => $proprietaire, 

                    'Montant' => $facture->getMontant(),
                    'Reférence' => $facture->getReference(),
                    
                );

                $container = $this->container;
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                
                if($res[0])
                {

                    $qr = $res[0]->qr;
                    $num = $res[0]->niu; 
                }
                
                $newname = 'facture'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $facture->setQrCode($checkqr); 

                //Génération du Bordereau avec MPDF
                $target = __DIR__.'/../../../../web/generated/facture/';
                $name = $facture->getReference().'.pdf';
                /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
                die; */
                $pdf = $this->renderView('facture/facture.html.1.twig', array(
                    'facture' => $facture,
                    //'emeteur'=>$emeteur,
                    'imageqr'=> $facture->getQrCode()->getChemin(),
                    'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                ));
 
                /*$document = new Document();
                $document->setBonCommande($boncommande);
                $boncommande->addDocument($document); */

                try
                {
                    $mpdf = new \Mpdf\Mpdf();
                    $mpdf->WriteHtml($pdf);
                    if (file_exists($target) != 1) 
                    {

                        mkdir($target,0777,true);
                        $mpdf->Output($target.$name, 'F');
                    }else
                    {
                        $mpdf->Output($target.$name, 'F');
                    }

                }catch(MpdfException $e)
                {

                    die($e->getMessage());
                    $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de la facture');
                }                
                // fIN Génération du document facture MPDF*******************************

         $facture->setPdf('generated/facture/'.$name);



        $em->persist($checkqr);
        $em->persist($bonCommande);
        $em->persist($receptionTravaux);
        $em->persist($facture);
        $em->flush();
        
        $this->get('session')->getFlashBag()->add('info', 'La facture a été généré avec succès');

        return $this->redirectToRoute('facture_show', array('id' => $facture->getId()));
        /*return $this->render('facture/new.html.twig', array(
            'facture' => $facture,
            'form' => $form->createView(),
        ));**/
    }

    /**
     * Creates a new facture entity.
     *
     * @Route("/new", name="facture_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $facture = new Facture();
        $form = $this->createForm('AMLA\SqrBundle\Form\FactureType', $facture);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($facture);
            $em->flush();

            return $this->redirectToRoute('facture_show', array('id' => $facture->getId()));
        }

        return $this->render('facture/new.html.twig', array(
            'facture' => $facture,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a facture entity.
     *
     * @Route("/{id}", name="facture_show")
     * @Method("GET")
     */
    public function showAction(Facture $facture)
    {
        $deleteForm = $this->createDeleteForm($facture);

        return $this->render('facture/show.html.twig', array(
            'facture' => $facture,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing facture entity.
     *
     * @Route("/{id}/edit", name="facture_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Facture $facture)
    {
        $deleteForm = $this->createDeleteForm($facture);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\FactureType', $facture);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('facture_edit', array('id' => $facture->getId()));
        }

        return $this->render('facture/edit.html.twig', array(
            'facture' => $facture,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a facture entity.
     *
     * @Route("/{id}", name="facture_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Facture $facture)
    {
        $form = $this->createDeleteForm($facture);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($facture);
            $em->flush();
        }

        return $this->redirectToRoute('facture_index');
    }

    /**
     * Creates a form to delete a facture entity.
     *
     * @param Facture $facture The facture entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Facture $facture)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('facture_delete', array('id' => $facture->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
