<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Exchange;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Exchange controller.
 *
 * @Route("recharge/{_locale}", defaults = {"_locale" = "fr"})
 */
class ExchangeController extends Controller
{
    /**
     * Lists all exchange entities.
     *
     * @Route("/", name="exchange_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $exchanges = $em->getRepository('AMLASqrBundle:Exchange')->findAll();

        return $this->render('exchange/index.html.twig', array(
            'exchanges' => $exchanges,
        ));
    }

    /**
     * Lists all exchange entities.
     *
     * @Route("/mine", name="exchange_index_mine")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $exchanges = $em->getRepository('AMLASqrBundle:Exchange')->findBy(['account'=>$user]);

        return $this->render('exchange/index_mine.html.twig', array(
            'exchanges' => $exchanges,
        ));
    }

    /**
     * Creates a new exchange entity.
     *
     * @Route("/new", name="exchange_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $exchange = new Exchange();
        $form = $this->createForm('AMLA\SqrBundle\Form\ExchangeType', $exchange);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $exchange->setAccount($this->getUser());
            $exchange->setFournisseur($this->getUser()->getCompagnyId());
            $em->persist($exchange);
            $em->flush();

            return $this->redirectToRoute('exchange_show', array('id' => $exchange->getId()));
        }

        return $this->render('exchange/new.html.twig', array(
            'exchange' => $exchange,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a exchange entity.
     *
     * @Route("/{id}", name="exchange_show")
     * @Method("GET")
     */
    public function showAction(Exchange $exchange)
    {
        $deleteForm = $this->createDeleteForm($exchange);

        return $this->render('exchange/show.html.twig', array(
            'exchange' => $exchange,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing exchange entity.
     *
     * @Route("/{id}/edit", name="exchange_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Exchange $exchange)
    {
        $deleteForm = $this->createDeleteForm($exchange);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ExchangeType', $exchange);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('exchange_edit', array('id' => $exchange->getId()));
        }

        return $this->render('exchange/edit.html.twig', array(
            'exchange' => $exchange,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a exchange entity.
     *
     * @Route("/{id}", name="exchange_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Exchange $exchange)
    {
        $form = $this->createDeleteForm($exchange);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($exchange);
            $em->flush();
        }

        return $this->redirectToRoute('exchange_index');
    }

    /**
     * Creates a form to delete a exchange entity.
     *
     * @param Exchange $exchange The exchange entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Exchange $exchange)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('exchange_delete', array('id' => $exchange->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
