<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\EnregistrementPp;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Enregistrementpp controller.
 *
 * @Route("enregistrementpp/{_locale}", defaults = {"_locale" = "fr"})
 */
class EnregistrementPpController extends Controller
{
    /**
     * Lists all enregistrementPp entities.
     *
     * @Route("/", name="enregistrementpp_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $enregistrementPps = $em->getRepository('AMLASqrBundle:EnregistrementPp')->findAll();

        return $this->render('enregistrementpp/index.html.twig', array(
            'enregistrementPps' => $enregistrementPps,
        ));
    }

    /**
     * Creates a new enregistrementPp entity.
     *
     * @Route("/new", name="enregistrementpp_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $enregistrementPp = new Enregistrementpp();
        $form = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPpType', $enregistrementPp);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($enregistrementPp);
            $em->flush();

            return $this->redirectToRoute('enregistrementpp_show', array('id' => $enregistrementPp->getId()));
        }

        return $this->render('enregistrementpp/new.html.twig', array(
            'enregistrementPp' => $enregistrementPp,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a enregistrementPp entity.
     *
     * @Route("/{id}", name="enregistrementpp_show")
     * @Method("GET")
     */
    public function showAction(EnregistrementPp $enregistrementPp)
    {
        $deleteForm = $this->createDeleteForm($enregistrementPp);

        return $this->render('enregistrementpp/show.html.twig', array(
            'enregistrementPp' => $enregistrementPp,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a enregistrementPp entity.
     *
     * @Route("/{id}/in/app", name="enregistrementpp_show_inapp")
     * @Method("GET")
     */
    public function showInAppAction(EnregistrementPp $enregistrementPp)
    {
        $deleteForm = $this->createDeleteForm($enregistrementPp);

        return $this->render('enregistrementpp/show_inapp.html.twig', array(
            'enregistrementPp' => $enregistrementPp,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing enregistrementPp entity.
     *
     * @Route("/{id}/edit", name="enregistrementpp_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, EnregistrementPp $enregistrementPp)
    {
        $deleteForm = $this->createDeleteForm($enregistrementPp);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPpType', $enregistrementPp);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('enregistrementpp_edit', array('id' => $enregistrementPp->getId()));
        }

        return $this->render('enregistrementpp/edit.html.twig', array(
            'enregistrementPp' => $enregistrementPp,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a enregistrementPp entity.
     *
     * @Route("/{id}", name="enregistrementpp_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, EnregistrementPp $enregistrementPp)
    {
        $form = $this->createDeleteForm($enregistrementPp);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($enregistrementPp);
            $em->flush();
        }

        return $this->redirectToRoute('enregistrementpp_index');
    }

    /**
     * Creates a form to delete a enregistrementPp entity.
     *
     * @param EnregistrementPp $enregistrementPp The enregistrementPp entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(EnregistrementPp $enregistrementPp)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('enregistrementpp_delete', array('id' => $enregistrementPp->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
