<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\EnregistrementPm;
use AMLA\SqrBundle\Entity\CheckQr;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\EnregistrementPp;
use Symfony\Component\HttpFoundation\Request;

/**
 * Enregistrementpm controller.
 *
 * @Route("enregistrementpm/{_locale}", defaults = {"_locale" = "fr"})
 */
class EnregistrementPmController extends Controller
{
    /**
     * Lists all enregistrementPm entities.
     *
     * @Route("/", name="enregistrementpm_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $enregistrementPms = $em->getRepository('AMLASqrBundle:EnregistrementPm')->findAll();
        $enregistrementPps = $em->getRepository('AMLASqrBundle:EnregistrementPp')->findAll();

        return $this->render('enregistrementpm/index.html.twig', array(
            'enregistrementPms' => $enregistrementPms,
            'enregistrementPps' => $enregistrementPps,
        ));
    }

    /**
     * Creates a new enregistrementPm entity.
     *
     * @Route("/new", name="enregistrementpm_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $enregistrementPm = new Enregistrementpm();
        $form = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPmType', $enregistrementPm);
        $form->handleRequest($request);
        //$enregistrementPp = new Enregistrementpm();
        //$formPp = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPmPhysiqueType', $enregistrementPp);
        //$formPp->handleRequest($request);

        $enregistrementPp = new EnregistrementPp();
        $formPp = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPpType', $enregistrementPp);
        $formPp->handleRequest($request);

        if ($formPp->isSubmitted() && $formPp->isValid())
        {
            $cle = $this->getParameter('api_key');
            $piece = 'Demande NIU Personne Physique';
            $proprietaire = $enregistrementPp->getNom();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece,
                'proprietaire' => $proprietaire,
                'Raison sociale' => $enregistrementPp->getNom() ,
                'Activite' => $enregistrementPp->getActiviteDeclaree() ,
            );
            // die('in');
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;
            while ($flag == false)
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null)
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10)
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);
                    }
                }
            }

            if($res[0])
            {
                $em = $this->getDoctrine()->getManager();
                $qr = $res[0]->qr;
                $num = $res[0]->niu;

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);
                $enregistrementPp->setQrCode($checkQr);

                $em->persist($checkQr);

                $em->persist($enregistrementPp);
                $em->flush();

                return $this->redirectToRoute('enregistrementpp_show', array('id' => $enregistrementPp->getId()));
            }
        }

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();

            $cle = $this->getParameter('api_key');
            $piece = 'Enregistrement Entreprise Impots';
            $proprietaire = $enregistrementPm->getRaisonSociale().' '.$enregistrementPm->getSigle();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 
                'Raison sociale' => $enregistrementPm->getRaisonSociale(),
                'Sigle' => $enregistrementPm->getSigle(),
            );
           // die('in');
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;  
            while ($flag == false) 
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null) 
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10) 
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);                    
                    }
                }
            }
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);
                $enregistrementPm->setQrCode($checkQr);                                    
                
                $em->persist($checkQr);
                $em->persist($enregistrementPm);
                $em->flush();
    
                return $this->redirectToRoute('enregistrementpm_show', array('id' => $enregistrementPm->getId()));
           }
        }

        return $this->render('enregistrementpm/new.html.twig', array(
            'enregistrementPm' => $enregistrementPm,
            'enregistrementPp' => $enregistrementPp,
            'form' => $form->createView(),
            'formPp' => $formPp->createView(),
        ));
    }


    /**
     * Creates a new enregistrementPm entity.
     *
     * @Route("/new/in/app", name="enregistrementpm_new_inapp")
     * @Method({"GET", "POST"})
     */
    public function newInAppAction(Request $request)
    {
        $enregistrementPm = new Enregistrementpm();
        $form = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPmType', $enregistrementPm);
        $form->handleRequest($request);
        //$enregistrementPp = new Enregistrementpm();
        //$formPp = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPmPhysiqueType', $enregistrementPp);
        //$formPp->handleRequest($request);

        $enregistrementPp = new EnregistrementPp();
        $formPp = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPpType', $enregistrementPp);
        $formPp->handleRequest($request);

        if ($formPp->isSubmitted() && $formPp->isValid())
        {
            $cle = $this->getParameter('api_key');
            $piece = 'Demande NIU Personne Physique';
            $proprietaire = $enregistrementPp->getNom();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece,
                'proprietaire' => $proprietaire,
                'Raison sociale' => $enregistrementPp->getNom() ,
                'Activite' => $enregistrementPp->getActiviteDeclaree() ,
            );
            // die('in');
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;
            while ($flag == false)
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null)
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10)
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);
                    }
                }
            }

            if($res[0])
            {
                $em = $this->getDoctrine()->getManager();
                $qr = $res[0]->qr;
                $num = $res[0]->niu;

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);
                $enregistrementPp->setQrCode($checkQr);

                $em->persist($checkQr);

                $em->persist($enregistrementPp);
                $em->flush();

                return $this->redirectToRoute('enregistrementpp_show', array('id' => $enregistrementPp->getId()));
            }
        }

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();

            $cle = $this->getParameter('api_key');
            $piece = 'Enregistrement Entreprise Impots';
            $proprietaire = $enregistrementPm->getRaisonSociale().' '.$enregistrementPm->getSigle();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece,
                'proprietaire' => $proprietaire,
                'Raison sociale' => $enregistrementPm->getRaisonSociale(),
                'Sigle' => $enregistrementPm->getSigle(),
            );
           // die('in');
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;
            while ($flag == false)
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null)
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10)
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);
                    }
                }
            }

            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu;

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);
                $enregistrementPm->setQrCode($checkQr);

                $em->persist($checkQr);
                $em->persist($enregistrementPm);
                $em->flush();

                return $this->redirectToRoute('enregistrementpm_show', array('id' => $enregistrementPm->getId()));
           }
        }

        return $this->render('enregistrementpm/new_inapp.html.twig', array(
            'enregistrementPm' => $enregistrementPm,
            'enregistrementPp' => $enregistrementPp,
            'form' => $form->createView(),
            'formPp' => $formPp->createView(),
        ));
    }

    /**
     * Finds and displays a enregistrementPm entity.
     *
     * @Route("/{id}", name="enregistrementpm_show")
     * @Method("GET")
     */
    public function showAction(EnregistrementPm $enregistrementPm)
    {
        $deleteForm = $this->createDeleteForm($enregistrementPm);

        return $this->render('enregistrementpm/show.html.twig', array(
            'enregistrementPm' => $enregistrementPm,
            'delete_form' => $deleteForm->createView(),
        ));
    }
    /**
     * Finds and displays a enregistrementPm entity.
     *
     * @Route("/{id}/show/", name="enregistrementpm_show_inapp")
     * @Method("GET")
     */
    public function showInAppAction(EnregistrementPm $enregistrementPm)
    {
        $deleteForm = $this->createDeleteForm($enregistrementPm);

        return $this->render('enregistrementpm/show_inapp.html.twig', array(
            'enregistrementPm' => $enregistrementPm,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing enregistrementPm entity.
     *
     * @Route("/{id}/edit", name="enregistrementpm_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, EnregistrementPm $enregistrementPm)
    {
        $deleteForm = $this->createDeleteForm($enregistrementPm);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\EnregistrementPmType', $enregistrementPm);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('enregistrementpm_edit', array('id' => $enregistrementPm->getId()));
        }

        return $this->render('enregistrementpm/edit.html.twig', array(
            'enregistrementPm' => $enregistrementPm,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a enregistrementPm entity.
     *
     * @Route("/{id}", name="enregistrementpm_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, EnregistrementPm $enregistrementPm)
    {
        $form = $this->createDeleteForm($enregistrementPm);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($enregistrementPm);
            $em->flush();
        }

        return $this->redirectToRoute('enregistrementpm_index');
    }

    /**
     * Creates a form to delete a enregistrementPm entity.
     *
     * @param EnregistrementPm $enregistrementPm The enregistrementPm entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(EnregistrementPm $enregistrementPm)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('enregistrementpm_delete', array('id' => $enregistrementPm->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
