<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Document;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Document controller.
 *
 * @Route("document/{_locale}", defaults = {"_locale" = "fr"})
 */
class DocumentController extends Controller
{
    /**
     * Lists all document entities.
     *
     * @Route("/", name="document_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $documents = $em->getRepository('AMLASqrBundle:Document')->findAll();

        return $this->render('document/index.html.twig', array(
            'documents' => $documents,
        ));
    }

    /**
     * Lists all document entities.
     *
     * @Route("/menu", name="document_menu")
     * @Method("GET")
     */
    public function menuAction()
    {
        //$em = $this->getDoctrine()->getManager();

        //$documents = $em->getRepository('AMLASqrBundle:Document')->findAll();
        //'documents' => $documents,        

        return $this->render('document/menu.html.twig', array());
    }


    /**
     * Lists all document entities.
     *
     * @Route("/all/generated", name="document_generated")
     * @Method("GET")
     */
    public function generatedAllAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $soumissionoffres = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findBy(['fournisseur'=>$fournisseur->getId()]);
        $attestationFs = $em->getRepository('AMLASqrBundle:AttestationVerification')->findBy(['fournisseur'=>$fournisseur->getId()]);
        $attestationVs = $em->getRepository('AMLASqrBundle:AttestationVerification')->findBy(['verificateur'=>$fournisseur->getId()]);
        //dump($attestationF);die; 
        $atds = $em->getRepository('AMLASqrBundle:Atd')->findAll();
        $mouvementatds = $em->getRepository('AMLASqrBundle:MouvementAtd')->findBy(array('statut'=>1));
       
        $bonCommandeRs = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeReceive($fournisseur);

        $bonCommandeSs = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeSent($fournisseur);

        $factureSs = $em->getRepository('AMLASqrBundle:Facture')->getFactureSent($fournisseur);
        $factureRs = $em->getRepository('AMLASqrBundle:Facture')->getFactureReceive($fournisseur);
        
        return $this->render('document/alldocgenerated.html.twig', array(
            'soumissionoffres' => $soumissionoffres,
            'attestationFs' => $attestationFs,
            'attestationVs' => $attestationVs,
            'atds'=>$atds, 
            'mouvementatds'=>$mouvementatds,
            'bonCommandeRs'=>$bonCommandeRs,
            'bonCommandeSs'=>$bonCommandeSs,
            'factureSs'=>$factureSs,
            'factureRs'=>$factureRs,
        ));

    }


    /**
     * Creates a new document entity.
     *
     * @Route("/new", name="document_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $document = new Document();
        $form = $this->createForm('AMLA\SqrBundle\Form\DocumentType', $document);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($document);
            $em->flush();

            return $this->redirectToRoute('document_show', array('id' => $document->getId()));
        }

        return $this->render('document/new.html.twig', array(
            'document' => $document,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a document entity.
     *
     * @Route("/{id}", name="document_show")
     * @Method("GET")
     */
    public function showAction(Document $document)
    {
        $deleteForm = $this->createDeleteForm($document);

        return $this->render('document/show.html.twig', array(
            'document' => $document,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing document entity.
     *
     * @Route("/{id}/edit", name="document_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Document $document)
    {
        $deleteForm = $this->createDeleteForm($document);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\DocumentType', $document);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('document_edit', array('id' => $document->getId()));
        }

        return $this->render('document/edit.html.twig', array(
            'document' => $document,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a document entity.
     *
     * @Route("/{id}", name="document_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Document $document)
    {
        $form = $this->createDeleteForm($document);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($document);
            $em->flush();
        }

        return $this->redirectToRoute('document_index');
    }

    /**
     * Creates a form to delete a document entity.
     *
     * @param Document $document The document entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Document $document)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('document_delete', array('id' => $document->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
