<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Demo;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Demo controller.
 *
 * @Route("demo/{_locale}", defaults = {"_locale" = "fr"})
 */
class DemoController extends Controller
{
    /**
     * Lists all demo entities.
     *
     * @Route("/", name="demo_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $demos = $em->getRepository('AMLASqrBundle:Demo')->findAll();

        return $this->render('demo/index.html.twig', array(
            'demos' => $demos,
        ));
    }

    /**
     * Creates a new demo entity.
     *
     * @Route("/new", name="demo_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $demo = new Demo();
        $form = $this->createForm('AMLA\SqrBundle\Form\DemoType', $demo);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($demo);
            $em->flush();

            return $this->redirectToRoute('demo_show', array('id' => $demo->getId()));
        }

        return $this->render('demo/new.html.twig', array(
            'demo' => $demo,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a demo entity.
     *
     * @Route("/{id}", name="demo_show")
     * @Method("GET")
     */
    public function showAction(Demo $demo)
    {
        $deleteForm = $this->createDeleteForm($demo);

        return $this->render('demo/show.html.twig', array(
            'demo' => $demo,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    

    /**
     * Finds and displays a demo entity.
     *
     * @Route("/template/menu", name="demo_template_menu")
     * @Method("GET")
     */
    public function templateMenuAction(Demo $demo)
    {
        return $this->render('demo/menu.html.twig', array(
        ));
    }

    /**
     * Finds and displays a demo entity.
     *
     * @Route("/attestation/attestation", name="demo_verif")
     * @Method("GET")
     */
    public function verifAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $soumissionoffres = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findBy(['fournisseur'=>$fournisseur->getId()]);
        $attestationFs = $em->getRepository('AMLASqrBundle:AttestationVerification')->findBy(['fournisseur'=>$fournisseur->getId()]);
        $attestationVs = $em->getRepository('AMLASqrBundle:AttestationVerification')->findBy(['verificateur'=>$fournisseur->getId()]);
        //dump($attestationF);die;
        
        return $this->render('demo/attestation.html.twig', array(
            'soumissionoffres' => $soumissionoffres,
            'attestationFs' => $attestationFs,
            'attestationVs' => $attestationVs,
        ));
    }

    /**
     * Finds and displays a demo entity.
     *
     * @Route("/attesto/attesto", name="demo_voir")
     * @Method("GET")
     */
    public function voirAction(Request $request)
    {

        $pdf = $this->renderView('anr/attestation.html.1.twig', array(
            'base_dir' => $this->get('kernel')->getRootDir() . '/../web' . $request->getBasePath(),
            ));

        try{

            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            $mpdf->Output();
    
        }catch(MpdfException $e){
    
            die($e->getMessage());
        }
    }

    /**
     * Displays a form to edit an existing demo entity.
     *
     * @Route("/{id}/edit", name="demo_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Demo $demo)
    {
        $deleteForm = $this->createDeleteForm($demo);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\DemoType', $demo);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('demo_edit', array('id' => $demo->getId()));
        }

        return $this->render('demo/edit.html.twig', array(
            'demo' => $demo,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a demo entity.
     *
     * @Route("/{id}", name="demo_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Demo $demo)
    {
        $form = $this->createDeleteForm($demo);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($demo);
            $em->flush();
        }

        return $this->redirectToRoute('demo_index');
    }

    /**
     * Creates a form to delete a demo entity.
     *
     * @param Demo $demo The demo entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Demo $demo)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('demo_delete', array('id' => $demo->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }



    /**
     * Creates a new demo entity.
     *
     * @Route("/new/invitation", name="demo_new_invitation")
     * @Method({"GET", "POST"})
     */
    public function newInvitationAction(Request $request)
    {
        $demo = new Demo();
        $form = $this->createForm('AMLA\SqrBundle\Form\DemoType', $demo);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($demo);
            $em->flush();

            return $this->redirectToRoute('demo_show', array('id' => $demo->getId()));
        }

        return $this->render('demo/invitation_new.html.twig', array(
            'demo' => $demo,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new demo entity.
     *
     * @Route("/new/fournisseur", name="demo_new_fournisseur")
     * @Method({"GET", "POST"})
     */
    public function newFournisseurAction(Request $request)
    {
        $demo = new Demo();
        $form = $this->createForm('AMLA\SqrBundle\Form\DemoType', $demo);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($demo);
            $em->flush();

            return $this->redirectToRoute('demo_show', array('id' => $demo->getId()));
        }

        return $this->render('demo/fournisseur_new.html.twig', array(
            'demo' => $demo,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new demo entity.
     *
     * @Route("/list/fournisseur", name="demo_list_fournisseur")
     * @Method({"GET", "POST"})
     */
    public function listeFournisseurAction(Request $request)
    {
        $demo = new Demo();
        $form = $this->createForm('AMLA\SqrBundle\Form\DemoType', $demo);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($demo);
            $em->flush();

            return $this->redirectToRoute('demo_show', array('id' => $demo->getId()));
        }

        return $this->render('demo/fournisseur_list.html.twig', array(
            'demo' => $demo,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new demo entity.
     *
     * @Route("/process/suivi-travaux", name="demo_suivi_travaux")
     * @Method({"GET", "POST"})
     */
    public function suiviTravauxAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId(), 'statut'=>1]);

    
        return $this->render('demo/suivitravaux.html.twig', array(
            'offres' => $offres,
        ));
    }
    
    /**
     * Creates a new demo entity.
     *
     * @Route("/process/facturation", name="demo_facturation")
     * @Method({"GET", "POST"})
     */
    public function facturationAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId(), 'statut'=>1]);

    
        return $this->render('demo/facturation.html.twig', array(
            'offres' => $offres,
        ));
    }

    /**
     * Creates a new demo entity.
     *
     * @Route("/process/validationpaiement", name="demo_paiement")
     * @Method({"GET", "POST"})
     */
    public function validationpaiementsAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId(), 'statut'=>1]);

        return $this->render('demo/validationpaiement.html.twig', array(
            'offres' => $offres,
        ));
    }
    
    /**
     * Creates a new demo entity.
     *
     * @Route("/documents/projets", name="demo_document")
     * @Method({"GET", "POST"})
     */
    public function documentsAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId(), 'statut'=>1]);

        return $this->render('demo/documents.html.twig', array(
            'offres' => $offres,
        ));
    }
    
    /**
     * Creates a new demo entity.
     *
     * @Route("/documents/details", name="demo_document_detail")
     * @Method({"GET", "POST"})
     */
    public function documentsDetailsAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);

        $offres = $em->getRepository('AMLASqrBundle:Offre')->findBy(['fournisseur'=>$fournisseur->getId(), 'statut'=>1]);

    
        return $this->render('demo/documents_detail.html.twig', array(
            'offres' => $offres,
        ));
    }


}
