<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Debour;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Debour controller.
 *
 * @Route("debour/{_locale}", defaults = {"_locale" = "fr"})
 */
class DebourController extends Controller
{
    /**
     * Lists all debour entities.
     *
     * @Route("/", name="debour_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $debours = $em->getRepository('AMLASqrBundle:Debour')->findAll();

        return $this->render('debour/index.html.twig', array(
            'debours' => $debours,
        ));
    }
    /**
     * Lists all debour entities.
     *
     * @Route("/mine", name="debour_index_mine")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();

        $debours = $em->getRepository('AMLASqrBundle:Debour')->findBy(['']);
        $debours = $em->getRepository('AMLASqrBundle:Debour')->findBy(['']);

        return $this->render('debour/index_mine.html.twig', array(
            'debours' => $debours,
        ));
    }

    /**
     * Creates a new debour entity.
     *
     * @Route("/new", name="debour_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $debour = new Debour();
        $form = $this->createForm('AMLA\SqrBundle\Form\DebourType', $debour);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();
            $em->persist($debour);
            $em->flush();

            return $this->redirectToRoute('debour_show', array('id' => $debour->getId()));
        }

        return $this->render('debour/new.html.twig', array(
            'debour' => $debour,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a debour entity.
     *
     * @Route("/{id}", name="debour_show")
     * @Method("GET")
     */
    public function showAction(Debour $debour)
    {
        $deleteForm = $this->createDeleteForm($debour);

        return $this->render('debour/show.html.twig', array(
            'debour' => $debour,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing debour entity.
     *
     * @Route("/{id}/edit", name="debour_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Debour $debour)
    {
        $deleteForm = $this->createDeleteForm($debour);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\DebourType', $debour);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid())
        {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('debour_edit', array(
                'id' => $debour->getId()
            ));
        }

        return $this->render('debour/edit.html.twig', array(
            'debour' => $debour,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a debour entity.
     *
     * @Route("/{id}", name="debour_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Debour $debour)
    {
        $form = $this->createDeleteForm($debour);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $em = $this->getDoctrine()->getManager();
            $em->remove($debour);
            $em->flush();
        }

        return $this->redirectToRoute('debour_index');
    }

    /**
     * Creates a form to delete a debour entity.
     *
     * @param Debour $debour The debour entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Debour $debour)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('debour_delete', array(
                'id' => $debour->getId()
            )))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
