<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Dashboard;
use AMLA\SqrBundle\Entity\ImpotVerify;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 

/**
 * Dashboard controller.
 *
 * @Route("/dashboard/{_locale}", defaults = {"_locale" = "fr"})
 */
class DashboardController extends Controller
{
    /**
     * Lists all dashboard entities.
     *
     * @Route("/", name="dashboard_index")
     * @Method({"GET", "POST"})
     */
    public function indexAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $dashboards = $em->getRepository('AMLASqrBundle:Dashboard')->findAll();

        $user = $this->getUser();        

        $fournisseur = $this->getUser()->getCompagnyId();
        //dump($fournisseur);die;
        $freevendings = $em->getRepository('AMLASqrBundle:Freevending')->findOneBy(['fournisseur'=>$fournisseur]);
        return $this->render('dashboard/index_freevending.html.twig', array(
            'user'=>$user,
            'user'=>$user->getCompagnyId(),
            'freevending'=>$freevendings,
        )); 
 
    }
    

    /**
     * Creates a new dashboard entity.
     *
     * @Route("/new", name="dashboard_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $dashboard = new Dashboard();
        $form = $this->createForm('AMLA\SqrBundle\Form\DashboardType', $dashboard);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($dashboard);
            $em->flush();

            return $this->redirectToRoute('dashboard_show', array('id' => $dashboard->getId()));
        }

        return $this->render('dashboard/new.html.twig', array(
            'dashboard' => $dashboard,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a dashboard entity.
     *
     * @Route("/{id}", name="dashboard_show")
     * @Method("GET")
     */
    public function showAction(Dashboard $dashboard)
    {
        $deleteForm = $this->createDeleteForm($dashboard);

        return $this->render('dashboard/show.html.twig', array(
            'dashboard' => $dashboard,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a dashboard entity.
     *
     * @Route("/set/local", name="dashboard_set_local")
     * @Method("GET")
     */
    public function setLocalAction(Request $request)
    {
        $locale = $request->getLocale();
        dump($locale);die;

        return $locale;
    }

    /**
     * Displays a form to edit an existing dashboard entity.
     *
     * @Route("/{id}/edit", name="dashboard_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Dashboard $dashboard)
    {
        $deleteForm = $this->createDeleteForm($dashboard);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\DashboardType', $dashboard);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('dashboard_edit', array('id' => $dashboard->getId()));
        }

        return $this->render('dashboard/edit.html.twig', array(
            'dashboard' => $dashboard,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a dashboard entity.
     *
     * @Route("/{id}", name="dashboard_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Dashboard $dashboard)
    {
        $form = $this->createDeleteForm($dashboard);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($dashboard);
            $em->flush();
        }

        return $this->redirectToRoute('dashboard_index');
    }

    /**
     * Creates a form to delete a dashboard entity.
     *
     * @param Dashboard $dashboard The dashboard entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Dashboard $dashboard)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('dashboard_delete', array('id' => $dashboard->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    private function sqrGetCode(array $post, $action, $critere, $val, $refImpot,$dateImpot)
    {        
        
        $em = $this->getDoctrine()->getManager();
        $cle = $this->container->getParameter('api_key');
        
        $keyParam = array(
            'cle' => $this->container->getParameter('api_key'),
            'pieceqr'=> 'Vérification-'.$action,
            'proprietaire' => $this->getUser()->getNom().' '.$this->getUser()->getPrenom(),
        );
        
        $dataToSend = array_merge($keyParam, $post);
        //dump($post);dump($post['Raison Sociale']);dump($dataToSend);die;

        

        $container = $this->container;
        $api = new SqrApi($container);
        $res = $api->callAPI($dataToSend);

        if($res[0])
        {            
            $qr = $res[0]->qr;
            $num = $res[0]->niu; 

            $impotVerif = new ImpotVerify;

            $impotVerif->setChecktatooNiuRef($num);
            $impotVerif->setChecktatooSqrRef($qr);

            // on nouri l'objet impot vérif
         //$impotVerif->setChecktatooDateGenerated();
            $impotVerif->setVerificationType($action);
            $impotVerif->setCriteria($critere);
            $impotVerif->setDataToVerify($val);
            $impotVerif->setImpotReference($refImpot);
            $impotVerif->setImpotDateGenerated($dateImpot);
            $impotVerif->setAccount($this->getUser());

            switch ($action) 
            {
                case 'ANR':
                {
                    $impotVerif->setAnr($post['Numéro ANR']);
                    $impotVerif->setNiu($post['NIU']);
                    $impotVerif->setRaisonSociale($post['Raison Sociale']);
                    $impotVerif->setDateInsertion($post['Date insertion']);
                    $impotVerif->setDateDelivrance($post['Date de début']);
                    $impotVerif->setMontantDu($post['Montant du']);
                    $impotVerif->setDateExpiration($post['Date de fin']);
                }
                break;
                case 'ATD':
                {
                    $impotVerif->setAtd($post['Numéro ATD']);
                    $impotVerif->setRaisonSociale($post['Raison Sociale']);
                    $impotVerif->setNiu($post['NIU']);
                    //$impotVerif->setDateInsertion($post['Date insertion']);
                    $impotVerif->setMontantDu($post['Montant du']);
                    $impotVerif->setMontantPaye($post['Montant payé']);
                    $impotVerif->setRestePaye($post['Reste à payer']);
                    $impotVerif->setMontantCantonne($post['Montant cantonné']);
                }
                break;
                case 'CONTRIBUABLE':
                {
                    
                    $impotVerif->setNiu($post['NIU']);
                    $impotVerif->setRaisonSociale($post['Raison Sociale']);
                    $impotVerif->setSigle($post['Sigle']);
                    $impotVerif->setActivitePrincipale($post['Activité principale']);
                    $impotVerif->setClasseActvite($post['Classe activité']);
                    $impotVerif->setRegimeFiscal($post['Régime fiscal']);
                    $impotVerif->setFormeJuridique($post['Forme juridique']);        
                    $impotVerif->setTelephone($post['Téléphone']);
                    $impotVerif->setCentreImpot($post['Centre des impots']);
                    $impotVerif->setCentreRegional($post['Centre régional']);
                    $impotVerif->setBoitePostale($post['Boite postale']);
                    $impotVerif->setVille($post['Ville']);
                    //$impotVerif->setCommune($post['commune']);        
                    $impotVerif->setQuartier($post['Quartier']);
                    $impotVerif->setLieuDit($post['Lieu dit']);
                    $impotVerif->setEtat($post['Etat']);
                }
                break;
                default:
                # code...
                //$this->get('session')->getFlashBag()->add('info', 'Une erreur est survenue. Essayez à nouveau.');

                break;

            }

            

            //start attestation vérif
            $newname = 'ATTEST_VERIF'.date('YmdHis',time()).mt_rand(0,1000).'.png';

            $name = 'ATTEST_VERIF_IMPOT'.mt_rand(0,1000).$num.'.pdf';
            $target = __DIR__.'/../../../../web/Production_documentaire/Impots/';

            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            //dump($checkqr);die;
            $impotVerif->setQrCode($checkqr);  
            $impotVerif->setPdf('/Production_documentaire/Impots/'.$name);         

            $pdf = $this->renderView('attestationverification/attestation_verif_impot.html.twig', array(
                'imageqr'=> $impotVerif->getQrCode()->getChemin(),
                'impotVerif' => $impotVerif,
                'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
                ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) {
        
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else{
                    $mpdf->Output($target.$name, 'F');
                }
        
            }catch(MpdfException $e){
        
                die($e->getMessage());
            }
            /// end attestation vérif
            
            $em->persist($checkqr);
            $em->persist($impotVerif);
            $em->flush();
            $result = array(
                'qr' => $qr,
                'niu'=> $num,
            );
           
        }else
        {
            $result=null;
        }
        

        return $result;

    }
}
