<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Conformite;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Conformite controller.
 *
 * @Route("conformite/{_locale}", defaults = {"_locale" = "fr"})
 */
class ConformiteController extends Controller
{
    /**
     * Lists all conformite entities.
     *
     * @Route("/dashboard/global", name="conformite_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $conformites = $em->getRepository('AMLASqrBundle:Conformite')->findAll();

        return $this->render('conformite/index.html.twig', array(
            'conformites' => $conformites,
        ));
    }

    /**
     * Lists all conformite entities.
     *
     * @Route("/dashboard/eneo", name="conformite_index_eneo")
     * @Method("GET")
     */
    public function indexEneoAction()
    {
        $em = $this->getDoctrine()->getManager();
        $opElement = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findOneBy(['id'=>48]);//ENEO

        $conformites = $em->getRepository('AMLASqrBundle:Conformite')->findBy(['operateurConformiteCategoryElement'=>$opElement]);

        return $this->render('conformite/index_eneo.html.twig', array(
            'conformites' => $conformites,
        ));
    }

    /**
     * Lists all conformite entities.
     *
     * @Route("/dashboard/eneo/inapp", name="conformite_index_eneo_in")
     * @Method("GET")
     */
    public function indexEneoInAction()
    {
        $em = $this->getDoctrine()->getManager();
        $opElement = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findOneBy(['id'=>48]);//ENEO

        $conformites = $em->getRepository('AMLASqrBundle:Conformite')->findBy(['operateurConformiteCategoryElement'=>$opElement]);

        return $this->render('conformite/index_eneo_in.html.twig', array(
            'conformites' => $conformites,
        ));
    }

    /**
     * Lists all conformite entities.
     *
     * @Route("/dashboard/bcpme", name="conformite_index_bcpme")
     * @Method("GET")
     */
    public function indexBcpmeAction()
    {
        $em = $this->getDoctrine()->getManager();
        $opElement = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findOneBy(['id'=>3]);//BCPME

        $conformites = $em->getRepository('AMLASqrBundle:Conformite')->findBy(['operateurConformiteCategoryElement'=>$opElement]);

        return $this->render('conformite/index_bcpme.html.twig', array(
            'conformites' => $conformites,
        ));
    }

    /**
     * Creates a new conformite entity.
     *
     * @Route("/new/global", name="conformite_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {

        $conformite = new Conformite();
        $form = $this->createForm('AMLA\SqrBundle\Form\ConformiteType', $conformite);
        $form->handleRequest($request);
        /*dump($request);die;
        //if ($form->isSubmitted() && $form->isValid())
        if ($_POST || $_GET)
        {
            $email = $request->get('email');
            $categorieActivite = $request->get('categorieActivite');
            $partenaire = $request->get('partenaire');
            $valeur1 = $request->get('valeur1');
            $valeur2 = $request->get('valeur2');
            $valeur3 = $request->get('valeur3');
            $nomRaisonSocialActivite = $request->get('nomRaisonSocialActivite');
            $nomRaisonSocialContribuable = $request->get('nomRaisonSocialContribuable');
            $niu = $request->get('niu');

            $em = $this->getDoctrine()->getManager();

            $operateurConformite = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findOneBy(['id'=>$partenaire]);

            // Construction de l'object Conformité.
            $conformite = new Conformite();
            $conformite->setEmail($email);
            $conformite->setValue1($valeur1) ;
            $conformite->setValue2($valeur2) ;
            $conformite->setValue3($valeur3) ;
            $conformite->setNiu($niu);
            $conformite->setOperateurConformiteCategoryElement($operateurConformite) ;
            $conformite->setOperateurConformiteCategory($operateurConformite->getOperateurConformite());

            $em->persist($conformite);
            $em->flush();

            dump($request);die;
            $erreur = 0;
            if($conformite->getNiuStatus() =='OUI' && empty($conformite->getNiu() ))
            {
                $this->get('session')->getFlashBag()->add('danger', 'Une erreur est survenue dans le formulaire. Essayez à nouveau svp');
                $erreur = 1;
            }
            if($erreur==0)
            {


                return $this->redirectToRoute('conformite_show', array('id' => $conformite->getId()));
            }
        }*/

        return $this->render('conformite/new.html.twig', array(
            'conformite' => $conformite,
            'form' => $form->createView(),
        ));
    }


    /**
     * Creates a new conformite entity.
     *
     * @Route("/new/submit/conformite/data", name="conformite_submit")
     * @Method({"GET", "POST"})
     */
    public function newSubmitAction(Request $request)
    {

        //if ($form->isSubmitted() && $form->isValid())
        if ($_POST || $_GET)
        {
            $email = $request->get('email');
            $categorieActivite = $request->get('categorieActivite');
            $partenaire = $request->get('partenaire');
            $valeur1 = $request->get('valeur1');
            $valeur2 = $request->get('valeur2');
            $valeur3 = $request->get('valeur3');
            $nomRaisonSocialActivite = $request->get('nomRaisonSocialActivite');
            $nomRaisonSocialContribuable = $request->get('nomRaisonSocialContribuable');
            $niu = $request->get('niu');
            $source = $request->get('source');

            $em = $this->getDoctrine()->getManager();

            $operateurConformite = $em->getRepository('AMLASqrBundle:OperateurConformiteCategoryElement')->findOneBy(['id'=>$partenaire]);
            // get niu raison sociale from niu given
            $url = 'http://teledeclaration-dgi.cm:1020/api/Contribuable2?niu='.$niu.'&idshare_application=ENEO';
            //dump($url);
            $ch = curl_init();
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_POST => 0,
                //CURLOPT_POSTFIELDS => '',
                CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
                CURLOPT_RETURNTRANSFER => true,
            ];
            curl_setopt_array($ch, $options);
            $responseContribuable = curl_exec($ch);
            $responseContribuable = json_decode($responseContribuable,true);
            curl_close($ch);

            if($responseContribuable[0]['message'] == 'OK')
            {
                // Construction de l'object Conformité.
                $conformite = new Conformite();
                $conformite->setEmail($email);
                $conformite->setValue1($valeur1) ;
                $conformite->setValue2($valeur2) ;
                $conformite->setValue3($valeur3) ;
                $conformite->setNomRaisonSocialeClient('AMLA CAMEROUN');
                $conformite->setNiu($niu);
                $conformite->setSource($source);
                $conformite->setNiuName($responseContribuable[0]['raison_sociale']);
                $conformite->setOperateurConformiteCategoryElement($operateurConformite) ;
                $conformite->setOperateurConformiteCategory($operateurConformite->getOperateurConformiteCategory());

                $em->persist($conformite);

                //$this->get('session')->getFlashBag()->add('success', 'Conformité enregistré avec succèss. Un mail vous sera envoyé avec des instructions pour compléter la procédure.');

                $em->flush();

                // On envoie le mot de passe par mail
                $message = (new \Swift_Message('CHECKTATOO : Demande de confirmation'))
                    ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO']) // sender
                    ->setTo($conformite->getEmail())       // recipient
                    /*->setBody('Vos paramètres de connexion à la plateforme CHECKTATOO sont
                        Login:'  . $user->getLoginUser().'
                        Mot de passe : ' . $passss);*/
                    ->setBody(
                        $this->renderView(
                        // app/Resources/views/Emails/registration.html.twig
                            'conformite/email_send.html.twig',
                            array('conformite' =>$conformite )
                        ),
                        'text/html'
                    );
                $this->get('mailer')->send($message);

                $tabRetour = array(
                    'status' => 'SUCCESS',
                    'message' => 'Conformité enregistré avec succèss. Un mail vous sera envoyé avec des instructions pour compléter la procédure.',
                );

            }else
            {
                $tabRetour = array(
                    'status' => 'FAILED',
                    'message' => 'Une erreur est survenue, vérifiez votre NIU et essayez à nouveau.',
                );
            }

        }else
        {
            $tabRetour = array(
                'status' => 'FAILED',
                'message' => 'Une erreur est survenue. Merci d\'essayer à nouveau',
            );
        }

        $ret = new JsonResponse($tabRetour);
        return $ret;

    }

    /**
     * Creates a new conformite entity.
     *
     * @Route("/new/eneo", name="conformite_new_eneo")
     * @Method({"GET", "POST"})
     */
    public function newEneoAction(Request $request)
    {

        $conformite = new Conformite();
        $form = $this->createForm('AMLA\SqrBundle\Form\ConformiteEneoType', $conformite);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $erreur = 0;
            if($conformite->getNiuStatus() =='OUI' && empty($conformite->getNiu() ))
            {
                $this->get('session')->getFlashBag()->add('danger', 'Une erreur est survenue dans le formulaire. Essayez à nouveau svp');
                $erreur = 1;
            }
            if($erreur==0)
            {
                $em = $this->getDoctrine()->getManager();
                $em->persist($conformite);
                $em->flush();

                return $this->redirectToRoute('conformite_show', array('id' => $conformite->getId()));
            }
        }

        return $this->render('conformite/new_eneo.html.twig', array(
            'conformite' => $conformite,
            'form' => $form->createView(),
        ));
    }


    /**
     * Creates a new conformite entity.
     *
     * @Route("/new/bcpme", name="conformite_new_bcpme")
     * @Method({"GET", "POST"})
     */
    public function newBcpmeAction(Request $request)
    {

        $conformite = new Conformite();
        $form = $this->createForm('AMLA\SqrBundle\Form\ConformiteBcpmeType', $conformite);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $erreur = 0;
            if($conformite->getNiuStatus() =='OUI' && empty($conformite->getNiu() ))
            {
                $this->get('session')->getFlashBag()->add('danger', 'Une erreur est survenue dans le formulaire. Essayez à nouveau svp');
                $erreur = 1;
            }
            if($erreur==0)
            {
                $em = $this->getDoctrine()->getManager();
                $em->persist($conformite);
                $em->flush();

                return $this->redirectToRoute('conformite_show', array('id' => $conformite->getId()));
            }
        }

        return $this->render('conformite/new_bcpme.html.twig', array(
            'conformite' => $conformite,
            'form' => $form->createView(),
        ));
    }


    /**
     * Finds and displays a verification entity.
     *
     * @Route("/verifier/un/niu/aux/impots", name="conformite_niu_only")
     * @Method({"GET", "POST"})
     */
    public function verifyNiuOnlyAction(Request $request)
    {

        $niu = $request->get('niu');
        if($niu)
        {
            $url = 'http://teledeclaration-dgi.cm:1020/api/Contribuable2?niu='.$niu.'&idshare_application=ENEO';
            //dump($url);
            $ch = curl_init();
            $options = [
                CURLOPT_URL => $url,
                CURLOPT_POST => 0,
                //CURLOPT_POSTFIELDS => '',
                CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
                CURLOPT_RETURNTRANSFER => true,
            ];
            curl_setopt_array($ch, $options);
            $responseContribuable = curl_exec($ch);
            $responseContribuable = json_decode($responseContribuable,true);
            curl_close($ch);

            if($responseContribuable[0]['message'] == 'OK')
            {
                /*
                $post = array(
                    'NIU' =>$responseContribuable[0]['niu'],
                    'Raison Sociale' =>$responseContribuable[0]['raison_sociale'],
                    'Sigle' =>$responseContribuable[0]['sigle'],
                    'Activité principale' =>$responseContribuable[0]['activiteprincipale'],
                    'Classe activité' =>$responseContribuable[0]['classeactivite'],
                    'Régime fiscal' =>$responseContribuable[0]['regimefiscal'],
                    'Forme juridique' =>$responseContribuable[0]['formejuridique'],
                    'Téléphone' =>$responseContribuable[0]['telephone'],
                    'Centre des impots' =>$responseContribuable[0]['centre_des_impots'],
                    'Centre régional' =>$responseContribuable[0]['centre_regional'],
                    'Boite postale' =>$responseContribuable[0]['bp'],
                    'Ville' =>$responseContribuable[0]['ville'],
                    'Quartier' =>$responseContribuable[0]['quartier'],
                    'Lieu dit' =>$responseContribuable[0]['lieu_dit'],
                    'Etat' =>$responseContribuable[0]['etat'],
                    'Référence impot' =>$responseContribuable[0]['reference_impot'],
                    'Date Générée' =>$responseContribuable[0]['date_generated'],
                );*/
                $raisonSocialImpot = $this->maskWord($responseContribuable[0]['raison_sociale']);

                $tabRetour = array(
                    'status' => 'SUCCESS',//(empty($amount)) ? 'FAILED' : $amount,
                    'niu' => $responseContribuable[0]['niu'],
                    //'raison_sociale_impots' => $responseContribuable[0]['raison_sociale'],
                    'raison_sociale_impots' => $raisonSocialImpot,
                );

            }else
            {
                $tabRetour = array(
                    'status' => 'FAILED',//(empty($amount)) ? 'FAILED' : $amount,
                    'niu' => $responseContribuable[0]['niu'],
                    'raison_sociale_impots' =>'CE NUMERO N\'EST PAS RECONNU PAR LES IMPOTS',
                );
            }

        }else
        {
            $tabRetour = array(
                'status' => 'FAILED',//(empty($amount)) ? 'FAILED' : $amount,
                'niu' => $niu,
                'raison_sociale_impots' =>null,
                'message' => 'NIU non renseigné',
            );
        }

        $ret = new JsonResponse($tabRetour);
        return $ret;
    }


    /**
     * Finds and displays a conformite entity.
     *
     * @Route("/{id}", name="conformite_show")
     * @Method("GET")
     */
    public function showAction(Conformite $conformite)
    {
        $deleteForm = $this->createDeleteForm($conformite);

        return $this->render('conformite/show.html.twig', array(
            'conformite' => $conformite,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a conformite entity.
     *
     * @Route("/{id}/valider/conformisation/c908e7b8-9611-44ae-95be-5ab5d2cfcdb5/data", name="conformite_valider")
     * @Method("GET")
     */
    public function validateAction(Conformite $conformite)
    {
        if($conformite->getStatut()==0)
        {
            $em = $this->getDoctrine()->getManager();
            $conformite->setStatut(1);
            $em->persist($conformite);
            $em->flush();
            $message = 'Validation  : Votre procédure de conformisation s\'est achevé avec succès.';
            $this->get('session')->getFlashBag()->add('success', 'Validation  : Votre procédure de conformisation s\'est achevé avec succès.');

        }elseif($conformite->getStatut()==1)
        {
            $this->get('session')->getFlashBag()->add('warning', 'Validation  : Votre procédure de conformisation a déjà été validé avec succès.');
            $message = 'Validation  : Votre procédure de conformisation a déjà été validé avec succès.';
        }

        return $this->render('conformite/show.html.twig', array(
            'conformite' => $conformite,
            'message' => $message,
        ));
    }

    /**
     * Displays a form to edit an existing conformite entity.
     *
     * @Route("/{id}/edit", name="conformite_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Conformite $conformite)
    {
        $deleteForm = $this->createDeleteForm($conformite);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ConformiteType', $conformite);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('conformite_edit', array('id' => $conformite->getId()));
        }

        return $this->render('conformite/edit.html.twig', array(
            'conformite' => $conformite,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a conformite entity.
     *
     * @Route("/{id}", name="conformite_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Conformite $conformite)
    {
        $form = $this->createDeleteForm($conformite);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($conformite);
            $em->flush();
        }

        return $this->redirectToRoute('conformite_index');
    }

    /**
     * Creates a form to delete a conformite entity.
     *
     * @param Conformite $conformite The conformite entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Conformite $conformite)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('conformite_delete', array('id' => $conformite->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    public function addX($occurance, $showX)
    {
        $x = null;
        for($i=0; $i<=$occurance - $showX; $i++)
        {
            $x = $x.'X';
        }
        return $x;
    }

    public function maskWord($word)
    {
        $raison_array = str_word_count($word,1);

        $raisonSocialImpot = null;

        foreach($raison_array as $raison)
        {
            $char = substr($raison, 0, 2);
            //$this->addX(strlen($char), 2);
            //$raisonSocialImpot = $raisonSocialImpot.'  '.$char.'XXXX';
            $raisonSocialImpot = $raisonSocialImpot.'  '.$char.$this->addX(strlen($raison), 2);
        }
        return $raisonSocialImpot;
    }
}
