<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ChequeSecure;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Chequesecure controller.
 *
 * @Route("chequesecure")
 */
class ChequeSecureController extends Controller
{
    /**
     * Lists all chequeSecure entities.
     *
     * @Route("/", name="chequesecure_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $chequeSecures = $em->getRepository('AMLASqrBundle:ChequeSecure')->findAll();

        return $this->render('chequesecure/index.html.twig', array(
            'chequeSecures' => $chequeSecures,
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/new", name="chequesecure_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $chequeSecure = new Chequesecure();
        $form = $this->createForm('AMLA\SqrBundle\Form\ChequeSecureType', $chequeSecure);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($chequeSecure);
            $em->flush();

            return $this->redirectToRoute('chequesecure_show', array('id' => $chequeSecure->getId()));
        }

        return $this->render('chequesecure/new.html.twig', array(
            'chequeSecure' => $chequeSecure,
            'form' => $form->createView(),
        ));
    }
    
    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/paiement/par/cheque", name="chequesecure_paiement_par_cheque")
     * @Method({"GET", "POST"})
     */
    public function paiementParChequeAction(Request $request)
    {
        return $this->render('chequesecure/paiement_par_cheque.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/vente", name="chequesecure_vente")
     * @Method({"GET", "POST"})
     */
    public function venteAction(Request $request)
    {
        return $this->render('chequesecure/vente.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/provisionner", name="chequesecure_provisionner")
     * @Method({"GET", "POST"})
     */
    public function provisionnerAction(Request $request)
    {
        return $this->render('chequesecure/provisionner.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/control/transaction", name="chequesecure_control_transaction")
     * @Method({"GET", "POST"})
     */
    public function controlTransactionAction(Request $request)
    {
        return $this->render('chequesecure/controle_transaction.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/verifier/cheque/chequier", name="chequesecure_verifier_cheque_chequier")
     * @Method({"GET", "POST"})
     */
    public function verifierChequeChequierAction(Request $request)
    {
        return $this->render('chequesecure/verification_cheque_chequier.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/retrouver/reference", name="chequesecure_retrouver_reference")
     * @Method({"GET", "POST"})
     */
    public function retrouverReferenceChequierAction(Request $request)
    {
        return $this->render('chequesecure/retrouver_reference.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/signalement", name="chequesecure_signalement")
     * @Method({"GET", "POST"})
     */
    public function signalementAction(Request $request)
    {
        return $this->render('chequesecure/signalement.html.twig', array(
        ));
    }
    
    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/parametrage/plafond", name="chequesecure_parametrage_plafond")
     * @Method({"GET", "POST"})
     */
    public function parametrerPlafondAction(Request $request)
    {
        return $this->render('chequesecure/parametrage_plafond.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/parametrage/signature/multiple", name="chequesecure_parametrage_signature_multiple")
     * @Method({"GET", "POST"})
     */
    public function parametrerSignatureMultipleAction(Request $request)
    {
        return $this->render('chequesecure/parametrage_signature_multiple.html.twig', array(
        ));
    }

    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/emission/cheque", name="chequesecure_emission_cheque")
     * @Method({"GET", "POST"})
     */
    public function emissionChequeAction(Request $request)
    {
        return $this->render('chequesecure/emission_cheque.html.twig', array(
        ));
    }
    
    /**
     * Creates a new chequeSecure entity.
     *
     * @Route("/emission/lettre/cheque", name="chequesecure_emission_lettre_cheque")
     * @Method({"GET", "POST"})
     */
    public function emissionLettreChequeAction(Request $request)
    {
        return $this->render('chequesecure/emission_lettre_cheque.html.twig', array(
        ));
    }

    /**
     * Finds and displays a chequeSecure entity.
     *
     * @Route("/{id}", name="chequesecure_show")
     * @Method("GET")
     */
    public function showAction(ChequeSecure $chequeSecure)
    {
        $deleteForm = $this->createDeleteForm($chequeSecure);

        return $this->render('chequesecure/show.html.twig', array(
            'chequeSecure' => $chequeSecure,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing chequeSecure entity.
     *
     * @Route("/{id}/edit", name="chequesecure_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ChequeSecure $chequeSecure)
    {
        $deleteForm = $this->createDeleteForm($chequeSecure);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ChequeSecureType', $chequeSecure);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('chequesecure_edit', array('id' => $chequeSecure->getId()));
        }

        return $this->render('chequesecure/edit.html.twig', array(
            'chequeSecure' => $chequeSecure,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a chequeSecure entity.
     *
     * @Route("/{id}", name="chequesecure_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ChequeSecure $chequeSecure)
    {
        $form = $this->createDeleteForm($chequeSecure);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($chequeSecure);
            $em->flush();
        }

        return $this->redirectToRoute('chequesecure_index');
    }

    /**
     * Creates a form to delete a chequeSecure entity.
     *
     * @param ChequeSecure $chequeSecure The chequeSecure entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ChequeSecure $chequeSecure)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('chequesecure_delete', array('id' => $chequeSecure->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
