<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\CertificatReception;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Certificatreception controller.
 *
 * @Route("certificatreception/{_locale}", defaults = {"_locale" = "fr"})
 */
class CertificatReceptionController extends Controller
{
    /**
     * Lists all certificatReception entities.
     *
     * @Route("/", name="certificatreception_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $certificatReceptions = $em->getRepository('AMLASqrBundle:CertificatReception')->findAll();

        return $this->render('certificatreception/index.html.twig', array(
            'certificatReceptions' => $certificatReceptions,
        ));
    }

    /**
     * Creates a new certificatReception entity.
     *
     * @Route("/new", name="certificatreception_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $certificatReception = new Certificatreception();
        $form = $this->createForm('AMLA\SqrBundle\Form\CertificatReceptionType', $certificatReception);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($certificatReception);
            $em->flush();

            return $this->redirectToRoute('certificatreception_show', array('id' => $certificatReception->getId()));
        }

        return $this->render('certificatreception/new.html.twig', array(
            'certificatReception' => $certificatReception,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a certificatReception entity.
     *
     * @Route("/{id}", name="certificatreception_show")
     * @Method("GET")
     */
    public function showAction(CertificatReception $certificatReception)
    {
        $deleteForm = $this->createDeleteForm($certificatReception);

        return $this->render('certificatreception/show.html.twig', array(
            'certificatReception' => $certificatReception,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing certificatReception entity.
     *
     * @Route("/{id}/edit", name="certificatreception_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, CertificatReception $certificatReception)
    {
        $deleteForm = $this->createDeleteForm($certificatReception);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\CertificatReceptionType', $certificatReception);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('certificatreception_edit', array('id' => $certificatReception->getId()));
        }

        return $this->render('certificatreception/edit.html.twig', array(
            'certificatReception' => $certificatReception,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a certificatReception entity.
     *
     * @Route("/{id}", name="certificatreception_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, CertificatReception $certificatReception)
    {
        $form = $this->createDeleteForm($certificatReception);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($certificatReception);
            $em->flush();
        }

        return $this->redirectToRoute('certificatreception_index');
    }

    /**
     * Creates a form to delete a certificatReception entity.
     *
     * @param CertificatReception $certificatReception The certificatReception entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(CertificatReception $certificatReception)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('certificatreception_delete', array('id' => $certificatReception->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
