<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\CertificatAvancement;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Certificatavancement controller.
 *
 * @Route("certificatavancement/{_locale}", defaults = {"_locale" = "fr"})
 */
class CertificatAvancementController extends Controller
{
    /**
     * Lists all certificatAvancement entities.
     *
     * @Route("/", name="certificatavancement_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $certificatAvancements = $em->getRepository('AMLASqrBundle:CertificatAvancement')->findAll();

        return $this->render('certificatavancement/index.html.twig', array(
            'certificatAvancements' => $certificatAvancements,
        ));
    }

    /**
     * Creates a new certificatAvancement entity.
     *
     * @Route("/new", name="certificatavancement_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $certificatAvancement = new Certificatavancement();
        $form = $this->createForm('AMLA\SqrBundle\Form\CertificatAvancementType', $certificatAvancement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($certificatAvancement);
            $em->flush();

            return $this->redirectToRoute('certificatavancement_show', array('id' => $certificatAvancement->getId()));
        }

        return $this->render('certificatavancement/new.html.twig', array(
            'certificatAvancement' => $certificatAvancement,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a certificatAvancement entity.
     *
     * @Route("/{id}", name="certificatavancement_show")
     * @Method("GET")
     */
    public function showAction(CertificatAvancement $certificatAvancement)
    {
        $deleteForm = $this->createDeleteForm($certificatAvancement);

        return $this->render('certificatavancement/show.html.twig', array(
            'certificatAvancement' => $certificatAvancement,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing certificatAvancement entity.
     *
     * @Route("/{id}/edit", name="certificatavancement_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, CertificatAvancement $certificatAvancement)
    {
        $deleteForm = $this->createDeleteForm($certificatAvancement);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\CertificatAvancementType', $certificatAvancement);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('certificatavancement_edit', array('id' => $certificatAvancement->getId()));
        }

        return $this->render('certificatavancement/edit.html.twig', array(
            'certificatAvancement' => $certificatAvancement,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a certificatAvancement entity.
     *
     * @Route("/{id}", name="certificatavancement_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, CertificatAvancement $certificatAvancement)
    {
        $form = $this->createDeleteForm($certificatAvancement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($certificatAvancement);
            $em->flush();
        }

        return $this->redirectToRoute('certificatavancement_index');
    }

    /**
     * Creates a form to delete a certificatAvancement entity.
     *
     * @param CertificatAvancement $certificatAvancement The certificatAvancement entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(CertificatAvancement $certificatAvancement)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('certificatavancement_delete', array('id' => $certificatAvancement->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
