<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\CentreRattachement;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Centrerattachement controller.
 *
 * @Route("centrerattachement/{_locale}", defaults = {"_locale" = "fr"})
 */
class CentreRattachementController extends Controller
{
    /**
     * Lists all centreRattachement entities.
     *
     * @Route("/", name="centrerattachement_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $centreRattachements = $em->getRepository('AMLASqrBundle:CentreRattachement')->findAll();

        return $this->render('centrerattachement/index.html.twig', array(
            'centreRattachements' => $centreRattachements,
        ));
    }

    /**
     * Creates a new centreRattachement entity.
     *
     * @Route("/new", name="centrerattachement_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $centreRattachement = new Centrerattachement();
        $form = $this->createForm('AMLA\SqrBundle\Form\CentreRattachementType', $centreRattachement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($centreRattachement);
            $em->flush();

            return $this->redirectToRoute('centrerattachement_show', array('id' => $centreRattachement->getId()));
        }

        return $this->render('centrerattachement/new.html.twig', array(
            'centreRattachement' => $centreRattachement,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a centreRattachement entity.
     *
     * @Route("/{id}", name="centrerattachement_show")
     * @Method("GET")
     */
    public function showAction(CentreRattachement $centreRattachement)
    {
        $deleteForm = $this->createDeleteForm($centreRattachement);

        return $this->render('centrerattachement/show.html.twig', array(
            'centreRattachement' => $centreRattachement,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing centreRattachement entity.
     *
     * @Route("/{id}/edit", name="centrerattachement_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, CentreRattachement $centreRattachement)
    {
        $deleteForm = $this->createDeleteForm($centreRattachement);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\CentreRattachementType', $centreRattachement);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('centrerattachement_edit', array('id' => $centreRattachement->getId()));
        }

        return $this->render('centrerattachement/edit.html.twig', array(
            'centreRattachement' => $centreRattachement,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a centreRattachement entity.
     *
     * @Route("/{id}", name="centrerattachement_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, CentreRattachement $centreRattachement)
    {
        $form = $this->createDeleteForm($centreRattachement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($centreRattachement);
            $em->flush();
        }

        return $this->redirectToRoute('centrerattachement_index');
    }

    /**
     * Creates a form to delete a centreRattachement entity.
     *
     * @param CentreRattachement $centreRattachement The centreRattachement entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(CentreRattachement $centreRattachement)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('centrerattachement_delete', array('id' => $centreRattachement->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
