<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\CelluleEnregistrement;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Celluleenregistrement controller.
 *
 * @Route("celluleenregistrement/{_locale}", defaults = {"_locale" = "fr"})
 */
class CelluleEnregistrementController extends Controller
{
    /**
     * Lists all celluleEnregistrement entities.
     *
     * @Route("/", name="celluleenregistrement_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $celluleEnregistrements = $em->getRepository('AMLASqrBundle:CelluleEnregistrement')->findAll();

        return $this->render('celluleenregistrement/index.html.twig', array(
            'celluleEnregistrements' => $celluleEnregistrements,
        ));
    }

    /**
     * Creates a new celluleEnregistrement entity.
     *
     * @Route("/new", name="celluleenregistrement_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $celluleEnregistrement = new CelluleEnregistrement();
        $form = $this->createForm('AMLA\SqrBundle\Form\CelluleEnregistrementType', $celluleEnregistrement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($celluleEnregistrement);
            $em->flush();

            return $this->redirectToRoute('celluleenregistrement_show', array('id' => $celluleEnregistrement->getId()));
        }

        return $this->render('celluleenregistrement/new.html.twig', array(
            'celluleEnregistrement' => $celluleEnregistrement,
            'form' => $form->createView(),
        ));
    }


    /**
     * Get new celules from impot API entity.
     *
     * @Route("/new/from/impot", name="celluleenregistrement_new_from_impot")
     * @Method({"GET", "POST"})
     */
    public function newFromApiAction(Request $request)
    {
        
        $ret = 0;
        $url = $this->getParameter('api_cellule_enregistrement');

        $ch = curl_init();
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_POST => 0,
            //CURLOPT_POSTFIELDS => '',
            CURLOPT_HTTPHEADER => array('Content-Type: multipart/form-data'),
            CURLOPT_RETURNTRANSFER => true,
        ];
        curl_setopt_array($ch, $options);
        $response = curl_exec($ch);
        $response = json_decode($response,true);
        curl_close($ch);

        $em = $this->getDoctrine()->getManager();
        foreach ($response as $reply) 
        {
            # code...
            $celluleEnregistrements = $em->getRepository('AMLASqrBundle:CelluleEnregistrement')->findOneBy(['code'=>$reply['code'], 'idunitegestion'=>$reply['idunitegestion'], 'libelle'=>$reply['libelle']]);
            if (!$celluleEnregistrements) 
            {
                # code...
                $celluleEnregistrement = new CelluleEnregistrement();
                $celluleEnregistrement->setCode($reply['code']);
                $celluleEnregistrement->setIdunitegestion($reply['idunitegestion']);
                $celluleEnregistrement->setLibelle($reply['libelle']);

                $em->persist($celluleEnregistrement);
                $ret = 1;
                
            }
        }
        $em->flush();
        //dump($response);die;
        
        $ret = new JsonResponse($ret);
        return $ret;
    }

    /**
     * Finds and displays a celluleEnregistrement entity.
     *
     * @Route("/{id}", name="celluleenregistrement_show")
     * @Method("GET")
     */
    public function showAction(CelluleEnregistrement $celluleEnregistrement)
    {
        $deleteForm = $this->createDeleteForm($celluleEnregistrement);

        return $this->render('celluleenregistrement/show.html.twig', array(
            'celluleEnregistrement' => $celluleEnregistrement,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing celluleEnregistrement entity.
     *
     * @Route("/{id}/edit", name="celluleenregistrement_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, CelluleEnregistrement $celluleEnregistrement)
    {
        $deleteForm = $this->createDeleteForm($celluleEnregistrement);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\CelluleEnregistrementType', $celluleEnregistrement);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('celluleenregistrement_edit', array('id' => $celluleEnregistrement->getId()));
        }

        return $this->render('celluleenregistrement/edit.html.twig', array(
            'celluleEnregistrement' => $celluleEnregistrement,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a celluleEnregistrement entity.
     *
     * @Route("/{id}", name="celluleenregistrement_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, CelluleEnregistrement $celluleEnregistrement)
    {
        $form = $this->createDeleteForm($celluleEnregistrement);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($celluleEnregistrement);
            $em->flush();
        }

        return $this->redirectToRoute('celluleenregistrement_index');
    }

    /**
     * Creates a form to delete a celluleEnregistrement entity.
     *
     * @param CelluleEnregistrement $celluleEnregistrement The celluleEnregistrement entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(CelluleEnregistrement $celluleEnregistrement)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('celluleenregistrement_delete', array('id' => $celluleEnregistrement->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
