<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Caution;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Caution controller.
 *
 * @Route("caution/{_locale}", defaults = {"_locale" = "fr"})
 */
class CautionController extends Controller
{
    /**
     * Lists all caution entities.
     *
     * @Route("/", name="caution_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $cautions = $em->getRepository('AMLASqrBundle:Caution')->findAll();

        return $this->render('caution/index.html.twig', array(
            'cautions' => $cautions,
        ));
    }

    /**
     * Creates a new caution entity.
     *
     * @Route("/new", name="caution_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $caution = new Caution();
        $form = $this->createForm('AMLA\SqrBundle\Form\CautionType', $caution);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $caution->setAccount($this->getUser());

            $em = $this->getDoctrine()->getManager();
            $em->persist($caution);
            $em->flush();

            return $this->redirectToRoute('caution_show', array('id' => $caution->getId()));
        }

        return $this->render('caution/new.html.twig', array(
            'caution' => $caution,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a caution entity.
     *
     * @Route("/{id}", name="caution_show")
     * @Method("GET")
     */
    public function showAction(Caution $caution)
    {
        $deleteForm = $this->createDeleteForm($caution);

        return $this->render('caution/show.html.twig', array(
            'caution' => $caution,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing caution entity.
     *
     * @Route("/{id}/edit", name="caution_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Caution $caution)
    {
        $deleteForm = $this->createDeleteForm($caution);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\CautionType', $caution);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('caution_edit', array('id' => $caution->getId()));
        }

        return $this->render('caution/edit.html.twig', array(
            'caution' => $caution,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a caution entity.
     *
     * @Route("/{id}", name="caution_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Caution $caution)
    {
        $form = $this->createDeleteForm($caution);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($caution);
            $em->flush();
        }

        return $this->redirectToRoute('caution_index');
    }

    /**
     * Creates a form to delete a caution entity.
     *
     * @param Caution $caution The caution entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Caution $caution)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('caution_delete', array('id' => $caution->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
