<?php

namespace AMLA\SqrBundle\Controller;

use Mpdf\Mpdf;
use Mpdf\MpdfException;
use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\CheckQr;
use AMLA\SqrBundle\Entity\BonCommande;
use AMLA\SqrBundle\API\SqrApi as SqrApi; 
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\LabelAlignment;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Response\QrCodeResponse;
                                        

/**
 * Boncommande controller.
 *
 * @Route("boncommande/{_locale}", defaults = {"_locale" = "fr"})
 */
class BonCommandeController extends Controller
{
    /**
     * Lists all bonCommande entities.
     *
     * @Route("/", name="boncommande_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
        $bonCommandes = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeUser($fournisseur);

        return $this->render('boncommande/index.html.twig', array(
            'bonCommandes' => $bonCommandes,
        ));
    }

     /**
     * Finds and displays a bonCommande entity.
     *
     * @Route("/receive", name="boncommande_received")
     * @Method("GET")
     */
    public function receiveAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $bonCommandes = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeReceive($fournisseur);

        return $this->render('boncommande/receive.html.twig', array(
            'bonCommandes' => $bonCommandes,
        ));
        
    }

     /**
     * Finds and displays a bonCommande entity.
     *
     * @Route("/sent", name="boncommande_sent")
     * @Method("GET")
     */
    public function sentAction(Request $request)
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]);
        $bonCommandes = $em->getRepository('AMLASqrBundle:BonCommande')->getBonCommandeSent($fournisseur);

        return $this->render('boncommande/sent.html.twig', array(
            'bonCommandes' => $bonCommandes,
        ));
    }

    /**
     * Finds and displays a offre entity.
     *
     * @Route("/{id}/download", name="boncommande_download")
     * @Method("GET")
     */
    public function downloadAction(Request $request, BonCommande $boncommande)
    {
        $em = $this->getDoctrine()->getManager();
        $soummissionoffre = $boncommande->getSoummissionOffre();
        $soumissionoffre = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findOneBy(['id'=>$soummissionoffre->getId()]);
        $fournisseur = $soumissionoffre->getFournisseur();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['id'=>$fournisseur->getId()]);
        $offre = $soumissionoffre->getOffre();
        $offre = $em->getRepository('AMLASqrBundle:Offre')->findOneBy(['id'=>$offre->getId()]);
        /*dump($offre);
        dump($fournisseur);
        dump($soumissionoffre);
        die;*/
        if ($boncommande->getQrCode() != NULL) {

            $pdf = $this->renderView('boncommande/boncommande.html.1.twig', array(
                'commande' => $boncommande,
                'fournisseur' => $fournisseur,
                'offre'=>$offre,
                'imageqr'=> $boncommande->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));

            try{

                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                $mpdf->Output();
    
            }catch(MpdfException $e){
    
                die($e->getMessage());
                //$this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\émission du bon de commande');
            }

        }else{

            $this->get('session')->getFlashBag()->add('danger', 'Ce bon de commande n\'a pas été sécurisé par le SQR');
            return $this->redirectToRoute('dashboard_index');
        }

    }


    /**
     * Creates a new bonCommande entity.
     *
     * @Route("/new", name="boncommande_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {

        $em = $this->getDoctrine()->getManager();
        $offreid = $request->get('offreid');
        $fournisseurid = $request->get('fournisseurid');
        $montant = $request->get('montant');
        $garantie = $request->get('garantie');
        $caution = $request->get('caution');   
        $montantCaution = $request->get('montantCaution');
        if (!$caution) {
            $montantCaution = 0;
        }

        
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($fournisseurid);
        $offre = $em->getRepository('AMLASqrBundle:Offre')->findOneById($offreid);
        $soumissionoffre = $em->getRepository('AMLASqrBundle:SoummissionOffre')->findOneBy(['offre'=>$offre,'fournisseur'=>$fournisseur]);
        $preselection = $em->getRepository('AMLASqrBundle:Preselection')->findOneBy(['offre'=>$offre,'fournisseur'=>$fournisseur]);
        $boncommande = new BonCommande();
        $offre->setStatut(1);
        $soumissionoffre->setOffre($offre);
        $soumissionoffre->setStatut(1);
        $preselection->setStatut(0);
        $boncommande->setSoummissionOffre($soumissionoffre);
        $boncommande->setMontant($montant);
        if ($caution)
        {
            $boncommande->setCautionnement(1);
            $boncommande->setPrixCautionnement($montantCaution);
        }else
        {
            $boncommande->setCautionnement(0);
            $boncommande->setPrixCautionnement(0);
        }
        $boncommande->setRetenueGarantie($garantie);
        $boncommande->setRestePaye($montant);
        
        $cle = 'MW7-ZDT-LDQ';
        $piece = 'Bon de Commande';
        $proprietaire = 'Emetteur: '.$offre->getFournisseur()->getRaisonSociale().' '.'Beneficiaire: '.$fournisseur->getRaisonSociale();

        $post = array(
            'cle' => $cle,
            'pieceqr'=> $piece, 
            'proprietaire' => $proprietaire, 
            'Reference de Offre' => $offre->getReference(),
            'Reference du bon de commande' => $boncommande->getReference(),
            'Objet de Offre' => $offre->getObjet(),
            'Nom de Adjudicateur' => $offre->getFournisseur()->getRaisonSociale(),
            'Nom du titulaire du marche' => $fournisseur->getRaisonSociale(),
            'Cautionnement' =>  $boncommande->getCautionnement()?'Avec Cautionnement':'Sans Cautionnement',
            'Prix du cautionnement' =>  $boncommande->getPrixCautionnement(),
            'Retenue de garantie' => $boncommande->getRetenueGarantie(),
            'Montant HT' =>  $boncommande->getMontant(),
            'Montant TTC' =>  $boncommande->getMontant(),
        );

        $container = $this->container;
        $api = new SqrApi($container);
        $res = $api->callAPI($post);
        
        if($res[0]){

            $qr = $res[0]->qr;
            $num = $res[0]->niu; 
        }
        
        $newname = 'BON_COM_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
        //$checkqr = new CheckQr();
        $checkqr = $api->generateQr($qr,$num,$newname);
        $checkqr->setChemin($newname);
        $boncommande->setQrCode($checkqr); 
        //Génération du Bordereau avec MPDF
        $target = __DIR__.'/../../../../web/generated/BonCommandes/offre_'.$offre->getId().'/emetteur_'.$offre->getFournisseur()->getRaisonSociale().'/beneficiaire_'.$fournisseur->getRaisonSociale().'/';
        $name = 'BON_COMMANDE_'.$boncommande
        ->getReference().'.pdf';
        /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
        die; */
        $pdf = $this->renderView('boncommande/boncommande.html.1.twig', array(
            'commande' => $boncommande,
            'fournisseur' => $fournisseur,
            'offre'=>$offre,
            'imageqr'=> $boncommande->getQrCode()->getChemin(),
            'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
        ));
       /*  $document = new Document();
        $document->setBonCommande($boncommande);
        $boncommande->addDocument($document); */

        try{
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            if (file_exists($target) != 1) {

                mkdir($target,0777,true);
                $mpdf->Output($target.$name, 'F');
            }else{
                $mpdf->Output($target.$name, 'F');
            }

        }catch(MpdfException $e){

            $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de l\émission du bon de commande');
            die($e->getMessage());
        }
        /**************Add Notification */
            $notification = New Notification();
            $notification->setTitle('Nouveau bon de commande');
            $notification->setDescription('Le bon de commande pour le marché de référence'.$boncommande->getSoummissionOffre()->getOffre()->getReference().' vous a été transmis.');
            $notification->setFournisseur($boncommande->getSoummissionOffre()->getfournisseur()); 
            $em->persist($notification);
        /**************End Add Notification */

        $em->persist($checkqr);
        $em->persist($preselection);
        $em->persist($offre);
        $em->persist($soumissionoffre);
        $em->persist($boncommande);
        $em->flush();

        //Envoie des mails
        $msg = (new \Swift_Message('CHECKTATOO - Bon de Commande'))
        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
        ->setTo($fournisseur->getAdresseEmail())
        ->setBody(
            $this->renderView(
                'emails/boncommandereceive.1.html.twig',array(
                    'offre' =>$offre,
                    'commande' => $boncommande,
                    'fournisseur' => $fournisseur,
                )
            ),
            'text/html'
        )
        ->attach(\Swift_Attachment::fromPath($target.$name));
        $this->get('mailer')->send($msg);

        $msg = (new \Swift_Message('CHECKTATOO - Bon de Commande'))
        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
        ->setTo($offre->getFournisseur()->getAdresseEmail())
        ->setBody(
            $this->renderView(
                'emails/boncommandesent.1.html.twig',array(
                    'offre' =>$offre,
                    'commande' => $boncommande,
                    'fournisseur' => $fournisseur,
                )
            ),
            'text/html'
        )
        ->attach(\Swift_Attachment::fromPath($target.$name));
        $this->get('mailer')->send($msg);

        
        $this->get('session')->getFlashBag()->add('info', 'Bon de Commande émis avec succès');        
        $this->addFlash('info','Bon de Commande émis avec succès');

        return $this->redirectToRoute('dashboard_index');
    }

    /**
     * Finds and displays a bonCommande entity.
     *
     * @Route("/{id}", name="boncommande_show")
     * @Method("GET")
     */
    public function showAction(BonCommande $bonCommande)
    {
        $deleteForm = $this->createDeleteForm($bonCommande);

        return $this->render('boncommande/show.html.twig', array(
            'bonCommande' => $bonCommande,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing bonCommande entity.
     *
     * @Route("/{id}/edit", name="boncommande_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, BonCommande $bonCommande)
    {
        $deleteForm = $this->createDeleteForm($bonCommande);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\BonCommandeType', $bonCommande);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) 
        {
            $this->getDoctrine()->getManager()->flush();
            return $this->redirectToRoute('boncommande_edit', array('id' => $bonCommande->getId()));
        }

        return $this->render('boncommande/edit.html.twig', array(
            'bonCommande' => $bonCommande,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a bonCommande entity.
     *
     * @Route("/{id}", name="boncommande_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, BonCommande $bonCommande)
    {
        $form = $this->createDeleteForm($bonCommande);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($bonCommande);
            $em->flush();
        }

        return $this->redirectToRoute('boncommande_index');
    }

    /**
     * Creates a form to delete a bonCommande entity.
     *
     * @param BonCommande $bonCommande The bonCommande entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(BonCommande $bonCommande)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('boncommande_delete', array('id' => $bonCommande->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
