<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\BanqueAssocie;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;

/**
 * Banqueassocie controller.
 *
 * @Route("banqueassocie/{_locale}", defaults = {"_locale" = "fr"})
 */
class BanqueAssocieController extends Controller
{
    /**
     * Lists all banqueAssocie entities.
     *
     * @Route("/", name="banqueassocie_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $banqueAssocies = $em->getRepository('AMLASqrBundle:BanqueAssocie')->findAll();

        return $this->render('banqueassocie/index.html.twig', array(
            'banqueAssocies' => $banqueAssocies,
        ));
    }

    /**
     * Creates a new banqueAssocie entity.
     *
     * @Route("/new", name="banqueassocie_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $banqueAssocie = new Banqueassocie();
        $form = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $banqueAssocie);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($banqueAssocie);
            $em->flush();

            return $this->redirectToRoute('banqueassocie_show', array('id' => $banqueAssocie->getId()));
        }

        return $this->render('banqueassocie/new.html.twig', array(
            'banqueAssocie' => $banqueAssocie,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a banqueAssocie entity.
     *
     * @Route("/{id}", name="banqueassocie_show")
     * @Method("GET")
     */
    public function showAction(BanqueAssocie $banqueAssocie)
    {
        $deleteForm = $this->createDeleteForm($banqueAssocie);

        return $this->render('banqueassocie/show.html.twig', array(
            'banqueAssocie' => $banqueAssocie,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing banqueAssocie entity.
     *
     * @Route("/{id}/edit", name="banqueassocie_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, BanqueAssocie $banqueAssocie)
    {
        $deleteForm = $this->createDeleteForm($banqueAssocie);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\BanqueAssocieType', $banqueAssocie);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('banqueassocie_edit', array('id' => $banqueAssocie->getId()));
        }

        return $this->render('banqueassocie/edit.html.twig', array(
            'banqueAssocie' => $banqueAssocie,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a banqueAssocie entity.
     *
     * @Route("/{id}", name="banqueassocie_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, BanqueAssocie $banqueAssocie)
    {
        $form = $this->createDeleteForm($banqueAssocie);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($banqueAssocie);
            $em->flush();
        }

        return $this->redirectToRoute('banqueassocie_index');
    }

    /**
     * Creates a form to delete a banqueAssocie entity.
     *
     * @param BanqueAssocie $banqueAssocie The banqueAssocie entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(BanqueAssocie $banqueAssocie)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('banqueassocie_delete', array('id' => $banqueAssocie->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
