<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\AttestationVerification;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Attestationverification controller.
 *
 * @Route("attestationverification/{_locale}", defaults = {"_locale" = "fr"})
 */
class AttestationVerificationController extends Controller
{
    /**
     * Lists all attestationVerification entities.
     *
     * @Route("/", name="attestationverification_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $attestationVerifications = $em->getRepository('AMLASqrBundle:AttestationVerification')->findAll();

        return $this->render('attestationverification/index.html.twig', array(
            'attestationVerifications' => $attestationVerifications,
        ));
    }

    /**
     * Creates a new attestationVerification entity.
     *
     * @Route("/new", name="attestationverification_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $attestationVerification = new Attestationverification();
        $form = $this->createForm('AMLA\SqrBundle\Form\AttestationVerificationType', $attestationVerification);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($attestationVerification);
            $em->flush();

            return $this->redirectToRoute('attestationverification_show', array('id' => $attestationVerification->getId()));
        }

        return $this->render('attestationverification/new.html.twig', array(
            'attestationVerification' => $attestationVerification,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a attestationVerification entity.
     *
     * @Route("/{id}", name="attestationverification_show")
     * @Method("GET")
     */
    public function showAction(AttestationVerification $attestationVerification)
    {
        $deleteForm = $this->createDeleteForm($attestationVerification);

        return $this->render('attestationverification/show.html.twig', array(
            'attestationVerification' => $attestationVerification,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing attestationVerification entity.
     *
     * @Route("/{id}/edit", name="attestationverification_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, AttestationVerification $attestationVerification)
    {
        $deleteForm = $this->createDeleteForm($attestationVerification);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\AttestationVerificationType', $attestationVerification);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('attestationverification_edit', array('id' => $attestationVerification->getId()));
        }

        return $this->render('attestationverification/edit.html.twig', array(
            'attestationVerification' => $attestationVerification,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a attestationVerification entity.
     *
     * @Route("/{id}", name="attestationverification_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, AttestationVerification $attestationVerification)
    {
        $form = $this->createDeleteForm($attestationVerification);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($attestationVerification);
            $em->flush();
        }

        return $this->redirectToRoute('attestationverification_index');
    }

    /**
     * Creates a form to delete a attestationVerification entity.
     *
     * @param AttestationVerification $attestationVerification The attestationVerification entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(AttestationVerification $attestationVerification)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('attestationverification_delete', array('id' => $attestationVerification->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
