<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\AtdSuspension;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Atdsuspension controller.
 *
 * @Route("atdsuspension/{_locale}", defaults = {"_locale" = "fr"})
 */
class AtdSuspensionController extends Controller
{
    /**
     * Lists all atdSuspension entities.
     *
     * @Route("/", name="atdsuspension_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $atdSuspensions = $em->getRepository('AMLASqrBundle:AtdSuspension')->findAll();

        return $this->render('atdsuspension/index.html.twig', array(
            'atdSuspensions' => $atdSuspensions,
        ));
    }

    /**
     * Creates a new atdSuspension entity.
     *
     * @Route("/new", name="atdsuspension_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $atdSuspension = new Atdsuspension();
        $form = $this->createForm('AMLA\SqrBundle\Form\AtdSuspensionType', $atdSuspension);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($atdSuspension);
            $em->flush();

            return $this->redirectToRoute('atdsuspension_show', array('id' => $atdSuspension->getId()));
        }

        return $this->render('atdsuspension/new.html.twig', array(
            'atdSuspension' => $atdSuspension,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a atdSuspension entity.
     *
     * @Route("/{id}", name="atdsuspension_show")
     * @Method("GET")
     */
    public function showAction(AtdSuspension $atdSuspension)
    {
        $deleteForm = $this->createDeleteForm($atdSuspension);

        return $this->render('atdsuspension/show.html.twig', array(
            'atdSuspension' => $atdSuspension,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing atdSuspension entity.
     *
     * @Route("/{id}/edit", name="atdsuspension_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, AtdSuspension $atdSuspension)
    {
        $deleteForm = $this->createDeleteForm($atdSuspension);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\AtdSuspensionType', $atdSuspension);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('atdsuspension_edit', array('id' => $atdSuspension->getId()));
        }

        return $this->render('atdsuspension/edit.html.twig', array(
            'atdSuspension' => $atdSuspension,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a atdSuspension entity.
     *
     * @Route("/{id}", name="atdsuspension_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, AtdSuspension $atdSuspension)
    {
        $form = $this->createDeleteForm($atdSuspension);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($atdSuspension);
            $em->flush();
        }

        return $this->redirectToRoute('atdsuspension_index');
    }

    /**
     * Creates a form to delete a atdSuspension entity.
     *
     * @param AtdSuspension $atdSuspension The atdSuspension entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(AtdSuspension $atdSuspension)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('atdsuspension_delete', array('id' => $atdSuspension->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
