<?php

namespace AMLA\SqrBundle\Controller;


use Mpdf\Mpdf;
use Mpdf\MpdfException;
use AMLA\SqrBundle\Entity\CheckQr;
use AMLA\SqrBundle\Entity\Notification;
use AMLA\SqrBundle\Entity\BonCommande;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\Atd;
use AMLA\SqrBundle\Entity\MouvementAtd;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\LabelAlignment;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Response\QrCodeResponse;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Atd controller.
 *
 * @Route("atd/{_locale}", defaults = {"_locale" = "fr"})
 */
class AtdController extends Controller
{
    
    /**
     * Lists all atd entities.
     *
     * @Route("/", name="atd_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $this->updateAtdtatus();
        $atds = $em->getRepository('AMLASqrBundle:Atd')->getAtdCreated();

        return $this->render('atd/index.html.twig', array(
            'atds' => $atds,
        ));
    }//atd_received

    
    /**
     * Lists all atd entities.
     *
     * @Route("/recu", name="atd_received")
     * @Method("GET")
     */
    public function indexReceivedAction()
    {
        $em = $this->getDoctrine()->getManager();
        $this->updateAtdtatus();
        /*$atdss = $em->getRepository('AMLASqrBundle:Atd')->findAll();
        foreach($atdss as $atd){
            if($atd->getResteAPayer()==0){
                $atd->setStatut(2);
                //$atd->setResteAPayer(0);
                $em->persist($atd);
                $em->flush();
            }
        }*/
        $atds = $em->getRepository('AMLASqrBundle:Atd')->getReceivedAtd($this->getUser()->getFournisseurs()[0]);

        return $this->render('atd/received.html.twig', array(
            'atds' => $atds,
        ));
    }

    /**
     * Lists all atd entities.
     *
     * @Route("/show/all", name="atd_index_all")
     * @Method("GET")
     */
    public function indexAllAction()
    {
        $em = $this->getDoctrine()->getManager();
        $this->updateAtdtatus();
        $atds = $em->getRepository('AMLASqrBundle:Atd')->getAtdLeve();

        return $this->render('atd/indexall.html.twig', array(
            'atds' => $atds,
        ));
    }

    /**
     * Creates a new atd entity.
     *
     * @Route("/new", name="atd_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {        
        $this->denyAccessUnlessGranted('ROLE_IMPOT', null, 'Vous n\'avez pas le droit d\'accéder cette page');
        $em = $this->getDoctrine()->getManager();
        $atd = new Atd();
        $role = $this->getUser()->getRole();
        if($role == 1 || $role ==4)
        {
            /*    $form = $this->createForm('AMLA\SqrBundle\Form\AtdType2', $atd);
            }elseif($role ==4)
            {*/
            $form = $this->createForm('AMLA\SqrBundle\Form\AtdType2', $atd);
        }elseif($role ==2)
        {
            $form = $this->createForm('AMLA\SqrBundle\Form\AtdType', $atd);
        }else
        {
            $form = $this->createForm('AMLA\SqrBundle\Form\AtdType', $atd);
        }

        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {            
            //$findMisEnCause = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(array('misEnCause'=>$request->get('amla_sqrbundle_atd')['misEnCause']));
            
            if(isset($request->files->get('amla_sqrbundle_atd')['justificatif']))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('amla_sqrbundle_atd')['justificatif'];

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    //... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $justificatif='ATD/justificatifs/'.$fileName;

                // persist the $product variable or any other work

            }else
            {
                $justificatif=Null;
            }
            
            if(isset($request->files->get('amla_sqrbundle_atd')['certificatNonAppel']))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('amla_sqrbundle_atd')['certificatNonAppel'];

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try 
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $certificatNonAppel='ATD/justificatifs/'.$fileName;
                // ... persist the $product variable or any other work
            }else
            {
                $certificatNonAppel=Null;
            }

            if(isset($request->files->get('amla_sqrbundle_atd')['decisionJustice']))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('amla_sqrbundle_atd')['decisionJustice'];

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try 
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $decisionJustice='ATD/justificatifs/'.$fileName;
                // ... persist the $product variable or any other work
            }else
            {
                $decisionJustice=Null;
            }
           //dump($request);die;
          
            $user = $this->getUser();
            $emeteur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
           // dump($emeteur);die;
            /*if($findMisEnCause)
            {
                $mouvementAtd = new MouvementAtd();

                $mouvementAtd->setAtd($findMisEnCause);
                $mouvementAtd->setEmetteur($emeteur);
                $mouvementAtd->setDecisionJustice($decisionJustice);
                $mouvementAtd->setJustificatif($justificatif);
                $mouvementAtd->setCertificateNonAppel($certificatNonAppel);
                $mouvementAtd->setDateDecision(new \Datetime($request->get('amla_sqrbundle_atd')['dateDecision']));
                $mouvementAtd->setJuridiction($request->get('amla_sqrbundle_atd')['juridiction']);
                $mouvementAtd->setVille($request->get('amla_sqrbundle_atd')['ville']);

                $mouvementAtd->setMontantInit(0);
                $mouvementAtd->setMontantCurrent(0);

                $mouvementAtd->setDateCertificatNonAppel(new \Datetime($request->get('amla_sqrbundle_atd')['dateCertificatNonAppel']));

                $em->persist($mouvementAtd);
                $em->flush();

            }else
            {*/              
                // Génération du document ATD MPDF*******************************
                
                $this->container->getParameter('api_key');
                $cle = $this->container->getParameter('api_key');
                $piece = 'ATD';
                $proprietaire = 'ATD';

                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece, 
                    'proprietaire' => $proprietaire, 

                    'NIU Mis en cause' => $atd->getMisEnCause(),
                    'Nom Mis en cause' => $atd->getNomMisEnCause(),
                    'Montant' => $atd->getMontant(),
                    //'Reférence' => $atd->getReference(),
                    'Emis par' => $atd->getMisEnCause(),                    
                );

                $container = $this->container;
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                
                if($res[0])
                {
                    $qr = $res[0]->qr;
                    $num = $res[0]->niu; 
                }
                
                $newname = 'ATD_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $atd->setQrCode($checkqr); 

                //Génération du Bordereau avec MPDF
                $target = __DIR__.'/../../../../web/generated/Atd/emis/';
                $name = 'emission'.$num.'.pdf';
                /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
                die; */
                $pdf = $this->renderView('atd/docEmission.html.twig', array(
                    'atd' => $atd,
                    'emeteur'=>$emeteur,
                    'imageqr'=> $atd->getQrCode()->getChemin(),
                    'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                ));

            /*  $document = new Document();
                $document->setBonCommande($boncommande);
                $boncommande->addDocument($document); */

                try
                {
                    $mpdf = new \Mpdf\Mpdf();
                    $mpdf->WriteHtml($pdf);
                    if (file_exists($target) != 1) 
                    {
                        mkdir($target,0777,true);
                        $mpdf->Output($target.$name, 'F');
                    }else
                    {
                        $mpdf->Output($target.$name, 'F');
                    }

                }catch(MpdfException $e)
                {
                    die($e->getMessage());
                    $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'ATD');
                }                
                // fIN Génération du document ATD MPDF*******************************
                
                $atd->setResteAPayer($atd->getMontant());
                $atd->setPdf('generated/Atd/emis/'.$name);
                
                $mouvementAtd = new MouvementAtd();

                if($request->get('amla_sqrbundle_atd')['dateDecision'])
                {
                    $dateDecision = new \Datetime($request->get('amla_sqrbundle_atd')['dateDecision']);
                }else
                {
                    $dateDecision = null;
                }

                if(isset($request->get('amla_sqrbundle_atd')['dateCertificatNonAppel']))
                {
                    $dateDCertificatNonAppel = new \Datetime($request->get('amla_sqrbundle_atd')['dateCertificatNonAppel']);
                }else
                {
                    $dateDCertificatNonAppel = null;
                }

                if($request->get('amla_sqrbundle_atd')['juridiction'])
                {
                    $juridiction = $request->get('amla_sqrbundle_atd')['juridiction'];
                }else
                {
                    $juridiction = null;
                }

                if($request->get('amla_sqrbundle_atd')['ville'])
                {
                    $ville = $request->get('amla_sqrbundle_atd')['ville'];
                }else
                {
                    $ville = null;
                }

                $mouvementAtd->setAtd($atd);
                $mouvementAtd->setEmetteur($emeteur);
                $mouvementAtd->setDecisionJustice($decisionJustice);
                $mouvementAtd->setJustificatif($justificatif);
                $mouvementAtd->setCertificateNonAppel($certificatNonAppel);
                $mouvementAtd->setDateDecision($dateDecision);
                $mouvementAtd->setJuridiction($juridiction);
                $mouvementAtd->setVille($ville);

                $mouvementAtd->setMontantInit(0);
                $mouvementAtd->setMontantCurrent($atd->getResteAPayer());

                $mouvementAtd->setDateCertificatNonAppel($dateDCertificatNonAppel);
                //$atd->setQrCode($checkqr);
                $em->persist($checkqr);
                $em->persist($atd);
                $em->persist($mouvementAtd);
                //dump($atd);die;


                $frnisssseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$atd->getMisEnCause()]);

                if (empty($frnisssseur)) 
                {
                    $frnisssseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$atd->getNomMisEnCause()]);
                }
                    
                if(!empty($frnisssseur))
                {
                    /**************Add Notification for received  */
                    $notificationO = New Notification();
                    $notificationO->setTitle('EMISSION ATD');
                    $notificationO->setDescription('Un ATD d\'un montant de '.$atd->getMontant().'FCFA vien d\'être émis à l\'endroit de votre entreprise. Veuillez vous rendre à la section ATD reçus pour avoir plus de détail.');
                    $notificationO->setFournisseur($frnisssseur); 
                    $em->persist($notificationO);
                    /**************End Add Notification */
                }
                $em->flush();
           /* }*/                
                
            //}           
           
            return $this->redirectToRoute('atd_show', array('id' => $atd->getId()));
        }

        return $this->render('atd/new.html.twig', array(
            'atd' => $atd,
            'form' => $form->createView(),
        ));
    }

    

    /**
     * Creates a new atd entity.
     *
     * @Route("/new/relation/affaire", name="atd_new_relation_affaire")
     * @Method({"GET", "POST"})
     */
    public function newRelationAffaireAction(Request $request)
    {        
        $this->denyAccessUnlessGranted('ROLE_IMPOT', null, 'Vous n\'avez pas le droit d\'accéder cette page');
        $em = $this->getDoctrine()->getManager();
        $atd = new Atd();

        if($_POST)
        {
            //$request->get('montant');
           // $request->get('centreCompetence');
            //$request->get('ville');
           
            //$request->get('dateDecision');
            //dump($request);die;
            $atd->setMisEnCause($request->get('niuFormulaire'));
            $atd->setNomMisEnCause($request->get('raisonSocialeFormulaire'));
            $atd->setMontant($request->get('montant'));
            //$atd->setEmeteur();
            $atd->getResteAPayer($request->get('montant'));
            //$atd->setMontantHt();
            //$atd->getCritereDiffusion();
            //$atd->setReferenceDecision();
            //$atd->setDateDecision();
            $atd->setAutoriteCompetente($request->get('centreCompetence'));
            
            if(!empty($request->files->get('decision')))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('decision');

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try 
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $decisionJustice='ATD/justificatifs/'.$fileName;
                // ... persist the $product variable or any other work
            }else
            {
                $decisionJustice=Null;
            }

            $user = $this->getUser();
            $emeteur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
           
            
            $cle = $this->container->getParameter('api_key');
            $piece = 'ATD';
            $proprietaire = 'ATD';

            
            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece, 
                'proprietaire' => $proprietaire, 

                'NIU Mis en cause' => $atd->getMisEnCause(),
                'Nom Mis en cause' => $atd->getNomMisEnCause(),
                'Montant' => $atd->getMontant(),
                //'Reférence' => $atd->getReference(),
                'Emis par' => $atd->getMisEnCause(),                    
            );

            $container = $this->container;
            $api = new SqrApi($container);
            $res = $api->callAPI($post);
            
            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu; 
            }
            
            $newname = 'ATD_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
            //$checkqr = new CheckQr();
            $checkqr = $api->generateQr($qr,$num,$newname);
            $checkqr->setChemin($newname);
            $atd->setQrCode($checkqr); 

            //Génération du Bordereau avec MPDF
            $target = __DIR__.'/../../../../web/generated/Atd/emis/';
            $name = 'emission'.$num.'.pdf';
            /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
            die; */
            $pdf = $this->renderView('atd/docEmission.html.twig', array(
                'atd' => $atd,
                'emeteur'=>$emeteur,
                'imageqr'=> $atd->getQrCode()->getChemin(),
                'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            ));

            try
            {
                $mpdf = new \Mpdf\Mpdf();
                $mpdf->WriteHtml($pdf);
                if (file_exists($target) != 1) 
                {
                    mkdir($target,0777,true);
                    $mpdf->Output($target.$name, 'F');
                }else
                {
                    $mpdf->Output($target.$name, 'F');
                }

            }catch(MpdfException $e)
            {
                die($e->getMessage());
                $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'ATD');
            }                
            // fIN Génération du document ATD MPDF*******************************
            
            $atd->setResteAPayer($atd->getMontant());
            $atd->setPdf('generated/Atd/emis/'.$name);
            
            $mouvementAtd = new MouvementAtd();

            if($request->get('dateDecision'))
            {
                $dateDecision = new \Datetime($request->get('dateDecision'));
            }else
            {
                $dateDecision = null;
            }

            if($request->get('ville'))
            {
                $ville = $request->get('ville');
            }else
            {
                $ville = null;
            }

            
            if($request->get('centreCompetence'))
            {
                $juridiction = $request->get('centreCompetence');
            }else
            {
                $juridiction = null;
            }

            $mouvementAtd->setAtd($atd);
            $mouvementAtd->setEmetteur($emeteur);
            $mouvementAtd->setDecisionJustice($decisionJustice);
            $mouvementAtd->setDateDecision($dateDecision);
            //$mouvementAtd->setJustificatif($justificatif);
            //$mouvementAtd->setCertificateNonAppel($certificatNonAppel);
            $mouvementAtd->setJuridiction($juridiction);
            $mouvementAtd->setVille($ville);

            $mouvementAtd->setMontantInit(0);
            $mouvementAtd->setMontantCurrent($atd->getResteAPayer());

            //$mouvementAtd->setDateCertificatNonAppel($dateDCertificatNonAppel);
            //$atd->setQrCode($checkqr);
            $em->persist($checkqr);
            $em->persist($atd);
            $em->persist($mouvementAtd);
            //dump($atd);die;


            $frnisssseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['niu'=>$atd->getMisEnCause()]);

            if (empty($frnisssseur)) 
            {
                $frnisssseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['raisonSociale'=>$atd->getNomMisEnCause()]);
            }
                
            if(!empty($frnisssseur))
            {
                /**************Add Notification for received  */
                $notificationO = New Notification();
                $notificationO->setTitle('EMISSION ATD');
                $notificationO->setDescription('Un ATD d\'un montant de '.$atd->getMontant().'FCFA vien d\'être émis à l\'endroit de votre entreprise. Veuillez vous rendre à la section ATD reçus pour avoir plus de détail.');
                $notificationO->setFournisseur($frnisssseur); 
                $em->persist($notificationO);
                /**************End Add Notification */
            }
            $em->flush();       

            $this->get('session')->getFlashBag()->add('success', 'ATD émis avec succès');
            
             return $this->redirectToRoute('atd_show', array('id' => $atd->getId()));

        }

        return $this->redirectToRoute('atd_new');
    }
    
    /**
     * Creates a new atd entity.
     *
     * @Route("/approvisionner/{id}", name="atd_approvisionner")
     * @Method({"GET", "POST"})
     */
    public function approvisionnerAction(Request $request, Atd $atd)
    {
        
        $em = $this->getDoctrine()->getManager();
        $mouvementAtd = new MouvementAtd();
        //$role = $this->getUser()->getRole();
      
        $form = $this->createForm('AMLA\SqrBundle\Form\ApprovisionnementType', $mouvementAtd);
        
        //dump($atd);die;
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {            
            //$montant = $request->get('amla_sqrbundle_atd')['montant'];
            $montant = $request->get('montant');
            //dump($montant);die;
            $montantAtd = $atd->getResteAPayer();
            $montantApprovisionne= $montantAtd - $montant;
            //dump($montantApprovisionne);die;
            if($montantAtd>=$montant)
            {                
                $user = $this->getUser();
                $emeteur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
                
                // dump($emeteur);die;            
                //$mouvementAtd = new MouvementAtd();

                $mouvementAtd->setAtd($atd);
                $mouvementAtd->setEmetteur($emeteur);                    
                $mouvementAtd->setMontantInit($montant);
                $mouvementAtd->setMontantCurrent($montantApprovisionne);
                $mouvementAtd->setStatut(1);

                $atd->setStatut(2);
                $atd->setResteAPayer($montantApprovisionne);

                // Génération du document ATD MPDF*********************
                
                $cle = $this->container->getParameter('api_key');
                $piece = 'ATD_Provision';
                $proprietaire = $emeteur->getRaisonSociale();

                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece, 
                    'proprietaire' => $proprietaire, 

                    'NIU Mis en cause' => $atd->getMisEnCause(),
                    'Nom Mis en cause' => $atd->getNomMisEnCause(),
                    'Montant' => $atd->getMontant(),
                    'Reférence ATD' => $atd->getReference(),
                    'Emis par' => $atd->getMisEnCause(),

                    'provisionné par'=>$mouvementAtd->getEmetteur()->getRaisonSociale(),

                );

                $container = $this->container;
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                
                if($res[0])
                {
                    $qr = $res[0]->qr;
                    $num = $res[0]->niu; 
                }
                
                $newname = 'ATD_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
                //$checkqr = new CheckQr();
                $checkqr = $api->generateQr($qr,$num,$newname);
                $checkqr->setChemin($newname);
                $mouvementAtd->setQrCode($checkqr); 

                //Génération du Bordereau avec MPDF
                $target = __DIR__.'/../../../../web/generated/Atd/provision/';
                $name = 'provision'.date('is',time()).mt_rand(0,1000).$atd->getReference().'.pdf';
                /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
                die; */
                $pdf = $this->renderView('atd/docProvision.html.twig', array(
                    'atd' => $atd,
                    'emeteur'=>$emeteur,
                    'mouvementAtd'=>$mouvementAtd,
                    'imageqr'=> $atd->getQrCode()->getChemin(),
                    'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
                ));

                /*$document = new Document();
                $document->setBonCommande($boncommande);
                $boncommande->addDocument($document); */

                try
                {
                    $mpdf = new \Mpdf\Mpdf();
                    $mpdf->WriteHtml($pdf);
                    if (file_exists($target) != 1) 
                    {

                        mkdir($target,0777,true);
                        $mpdf->Output($target.$name, 'F');
                    }else
                    {
                        $mpdf->Output($target.$name, 'F');
                    }

                }catch(MpdfException $e)
                {
                    die($e->getMessage());
                    $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'ATD');
                }                
                    // fIN Génération du document ATD MPDF*******************************

                    $mouvementAtd->setPdf('generated/Atd/provision/'.$name);
                    //$atd->setQrCode($checkqr);
                    $em->persist($checkqr);
                    $em->persist($atd);
                    $em->persist($mouvementAtd);
                    $em->flush();

                    $this->addFlash('info', 'ATD approvisionné avec succès');            
                    
                //}           
                //dump($atd);die;
                return $this->redirectToRoute('atd_show', array('id' => $atd->getId()));
            }else
            {
                //$error = 'Erreur lors de l\'approvisionnement de l\'ATD';
                $this->addFlash('info', 'Erreur lors du cantonnement de l\'ATD : Montant invalide !');
            }
        }

        return $this->render('atd/approvisionner.html.twig', array(
            'atd' => $atd,
            'form' => $form->createView(),
        ));
    }

    /**
     * Creates a new atd entity.
     *
     * @Route("/emission/{id}", name="atd_emission")
     * @Method({"GET", "POST"})
     */
    public function emissionAction(Request $request, Atd $atd)
    {
        
        $em = $this->getDoctrine()->getManager();
        $mouvementAtd = new MouvementAtd();
        //$role = $this->getUser()->getRole();
      
        $form = $this->createForm('AMLA\SqrBundle\Form\AtdType2', $atd);
        
        
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            //dump($request);die;
            $montant = $request->get('amla_sqrbundle_atd')['montant'];
            $montantAtd = $atd->getMontant();
            $montantApprovisionne= $montantAtd + $montant;
            //dump($montantApprovisionne);die;
            $user = $this->getUser();
            $emeteur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
           // dump($emeteur);die;
            $justificatif=null;
                //$mouvementAtd = new MouvementAtd();
            if(isset($request->files->get('amla_sqrbundle_atd')['justificatif']))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('amla_sqrbundle_atd')['justificatif'];

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try 
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $justificatif=$fileName;

                // ... persist the $product variable or any other work
            }
            
            if(isset($request->files->get('amla_sqrbundle_atd')['certificatNonAppel']))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('amla_sqrbundle_atd')['certificatNonAppel'];

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try 
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $certificatNonAppel=$fileName;
                // ... persist the $product variable or any other work
            }

            if(isset($request->files->get('amla_sqrbundle_atd')['decisionJustice']))
            {
                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $request->files->get('amla_sqrbundle_atd')['decisionJustice'];

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try 
                {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) 
                {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                //$atd->setJustificatif($fileName);
                $decisionJustice=$fileName;
                // ... persist the $product variable or any other work
            }

            $mouvementAtd->setAtd($atd);
            $mouvementAtd->setEmetteur($emeteur);
            $mouvementAtd->setDecisionJustice($decisionJustice);
            $mouvementAtd->setJustificatif($justificatif);
            $mouvementAtd->setCertificateNonAppel($certificatNonAppel);
            $mouvementAtd->setDateDecision(new \Datetime($request->get('amla_sqrbundle_atd')['dateDecision']));
            $mouvementAtd->setJuridiction($request->get('amla_sqrbundle_atd')['juridiction']);
            $mouvementAtd->setVille($request->get('amla_sqrbundle_atd')['ville']);

            $mouvementAtd->setMontantInit($montantAtd);
            $mouvementAtd->setMontantCurrent($montantApprovisionne);
            $mouvementAtd->setStatut(0);
            $mouvementAtd->setDateCertificatNonAppel(new \Datetime($request->get('amla_sqrbundle_atd')['dateCertificatNonAppel']));


            $atd->setMontant($montantApprovisionne);
            $em->persist($atd);
            $em->persist($mouvementAtd);
            //dump($atd);dump($mouvementAtd);die;
            $em->flush();
                
            //}           
            //dump($atd);die;
            return $this->redirectToRoute('atd_show', array('id' => $atd->getId()));
        }

        return $this->render('atd/approvisionner.html.twig', array(
            'atd' => $atd,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a atd entity.
     *
     * @Route("/{id}", name="atd_show")
     * @Method("GET")
     */
    public function showAction(Atd $atd)
    {
        $deleteForm = $this->createDeleteForm($atd);

        $mouvementAtds = $atd->getMouvements();
        //dump($mouvementAtds);die;

        return $this->render('atd/show.html.twig', array(
            'atd' => $atd,
            'mouvementAtds' => $mouvementAtds,
            'delete_form' => $deleteForm->createView(),
        ));
    }

     /**
     * Check if atd for user NIU or social reason.
     *
     * @Route("/check/any", name="atd_verify_niu_socialreason")
     * @Method({"GET", "POST"})
     */
    public function checkIfAtdAction(Request $request )
    {
        $em = $this->getDoctrine()->getManager();
        $niu = $request->get('niu');
        $raisonSociale = $request->get('raisonSociale');

        $atd = $em->getRepository('AMLASqrBundle:Atd')->findBy(['misEnCause'=>$niu]);

        if (empty($atd)) 
        {
            $atd = $em->getRepository('AMLASqrBundle:Atd')->findBy(['nomMisEnCause'=>$raisonSociale]);
        }
        
        if ($atd) 
        {
            $reply = 1;
        }else
        {
            $reply = 0;
        }
               
        $response = $reply;
        $response = new JsonResponse($response);
        return $response;
    }

    public function pdfGenerate( Atd $atd, Request $request)
    {

        $this->container->getParameter('api_key');
        $cle = $this->container->getParameter('api_key');
        $piece = 'ATD';
        $proprietaire = 'ATD';

        $post = array(
            'cle' => $cle,
            'pieceqr'=> $piece, 
            'proprietaire' => $proprietaire, 

            'NIU Mis en cause' => $atd->getMisEnCause(),
            'Nom Mis en cause' => $atd->getNomMisEnCause(),
            'Montant' => $atd->getMontant(),
            'Reférence' => $atd->getReference(),
            'Emis par' => $atd->getMisEnCause(),
            
        );

        $container = $this->container;
        $api = new SqrApi($container);
        $res = $api->callAPI($post);
        
        if($res[0])
        {

            $qr = $res[0]->qr;
            $num = $res[0]->niu; 
        }
        
        $newname = 'ATS_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
        //$checkqr = new CheckQr();
        $checkqr = $api->generateQr($qr,$num,$newname);
        $checkqr->setChemin($newname);
        $atd->setQrCode($checkqr); 

        //Génération du Bordereau avec MPDF
        $target = __DIR__.'/../../../../web/generated/Atd/emis/_';
        $name = 'ATD_'.$atd->getReference().'.pdf';
        /* dump($this->get('kernel')->getRootDir().'/web/'.$request->getBasePath().$boncommande->getQrCode()->getChemin());
        die; */
        $pdf = $this->renderView('atd/doc.atd.html.twig', array(
            'atd' => $atd,
            'imageqr'=> $atd->getQrCode()->getChemin(),
            'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
        ));

       /*  $document = new Document();
        $document->setBonCommande($boncommande);
        $boncommande->addDocument($document); */

        try
        {
            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            if (file_exists($target) != 1) 
            {

                mkdir($target,0777,true);
                $mpdf->Output($target.$name, 'F');
            }else
            {
                $mpdf->Output($target.$name, 'F');
            }

        }catch(MpdfException $e)
        {

            die($e->getMessage());
            $this->get('session')->getFlashBag()->add('danger', 'Erreur lors de la génération de l\'ATD');
        }

    }

    /**
     * Displays a form to edit an existing atd entity.
     *
     * @Route("/{id}/edit", name="atd_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Atd $atd)
    {
        $deleteForm = $this->createDeleteForm($atd);
        $atdcloned = clone $atd;
        $atd = new Atd();
        $role = $this->getUser()->getRole();
        if($role == 1)
        {            
            $editForm = $this->createForm('AMLA\SqrBundle\Form\AtdType2', $atd);
        }elseif($role ==2)
        {
            $editForm = $this->createForm('AMLA\SqrBundle\Form\AtdType', $atd);
        }
        //dump($atd);die;
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {

            if(!$atd->getJustificatif())
            {
                $atd->setJustificatif($atdcloned->getJustificatif());
            }else
            {

                // $file stores the uploaded PDF file
                /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
                $file = $atd->getJustificatif();

                $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

                // Move the file to the directory where brochures are stored
                try {
                    $file->move(
                        $this->getParameter('justificatif_directory'),
                        $fileName
                    );
                } catch (FileException $e) {
                    // ... handle exception if something happens during file upload
                }

                // updates the 'brochure' property to store the PDF file name
                // instead of its contents
                $atd->setJustificatif($fileName);
                // ... persist the $product variable or any other work

            }

            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('atd_edit', array('id' => $atd->getId()));
        }

        return $this->render('atd/edit.html.twig', array(
            'atd' => $atd,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a atd entity.
     *
     * @Route("/{id}", name="atd_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Atd $atd)
    {
        $form = $this->createDeleteForm($atd);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($atd);
            $em->flush();
        }

        return $this->redirectToRoute('atd_index');
    }

    /**
     * Creates a form to delete a atd entity.
     *
     * @param Atd $atd The atd entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Atd $atd)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('atd_delete', array('id' => $atd->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }

    /**
     * @return string
     */
    private function generateUniqueFileName()
    {
        // md5() reduces the similarity of the file names generated by
        // uniqid(), which is based on timestamps
        return md5(uniqid());
    }

    private function updateAtdtatus ()
    {
        $em = $this->getDoctrine()->getManager();
        $atdss = $em->getRepository('AMLASqrBundle:Atd')->findAll();
        foreach($atdss as $atd)
        {
            if($atd->getResteAPayer()==0)
            {
                $atd->setStatut(1);
                //$atd->setResteAPayer(0);
                $em->persist($atd);
                $em->flush();
            }
        }
    }

}
