<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Approvisionner;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Approvisionner controller.
 *
 * @Route("approvisionner/{_locale}", defaults = {"_locale" = "fr"})
 */
class ApprovisionnerController extends Controller
{
    /**
     * Lists all approvisionner entities.
     *
     * @Route("/", name="approvisionner_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $approvisionners = $em->getRepository('AMLASqrBundle:Approvisionner')->findAll();

        return $this->render('approvisionner/index.html.twig', array(
            'approvisionners' => $approvisionners,
        ));
    }

    /**
     * Lists all approvisionner entities.
     *
     * @Route("/mine", name="approvisionner_index_mine")
     * @Method("GET")
     */
    public function indexMineAction()
    {
        $em = $this->getDoctrine()->getManager();
        $user = $this->getUser();
        $approvisionners = $em->getRepository('AMLASqrBundle:Approvisionner')->findBy(['account'=>$user]);

        return $this->render('approvisionner/index_mine.html.twig', array(
            'approvisionners' => $approvisionners,
        ));
    }

    /**
     * Creates a new approvisionner entity.
     *
     * @Route("/new", name="approvisionner_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $approvisionner = new Approvisionner();
        $form = $this->createForm('AMLA\SqrBundle\Form\ApprovisionnerType', $approvisionner);
        $form->handleRequest($request);
        $em = $this->getDoctrine()->getManager();

        if ($form->isSubmitted() && $form->isValid()) {
            
            $approvisionner->setAccount($this->getUser());
            $approvisionner->setFournisseur($this->getUser()->getCompagnyId());
            $em->persist($approvisionner);
            $em->flush();

            return $this->redirectToRoute('approvisionner_show', array('id' => $approvisionner->getId()));
        }

        $fournisseur = $this->getUser()->getCompagnyId();
        //dump($fournisseur);die;
        $freevendings = $em->getRepository('AMLASqrBundle:Freevending')->findOneBy(['fournisseur'=>$fournisseur]);

        return $this->render('approvisionner/new.html.twig', array(
            'approvisionner' => $approvisionner,
            'form' => $form->createView(),
            'freevending'=> $freevendings,
        ));
    }

    /**
     * Finds and displays a approvisionner entity.
     *
     * @Route("/{id}", name="approvisionner_show")
     * @Method("GET")
     */
    public function showAction(Approvisionner $approvisionner)
    {
        $deleteForm = $this->createDeleteForm($approvisionner);

        return $this->render('approvisionner/show.html.twig', array(
            'approvisionner' => $approvisionner,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing approvisionner entity.
     *
     * @Route("/{id}/edit", name="approvisionner_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Approvisionner $approvisionner)
    {
        $deleteForm = $this->createDeleteForm($approvisionner);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ApprovisionnerType', $approvisionner);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('approvisionner_edit', array('id' => $approvisionner->getId()));
        }

        return $this->render('approvisionner/edit.html.twig', array(
            'approvisionner' => $approvisionner,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a approvisionner entity.
     *
     * @Route("/{id}", name="approvisionner_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Approvisionner $approvisionner)
    {
        $form = $this->createDeleteForm($approvisionner);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($approvisionner);
            $em->flush();
        }

        return $this->redirectToRoute('approvisionner_index');
    }

    /**
     * Creates a form to delete a approvisionner entity.
     *
     * @param Approvisionner $approvisionner The approvisionner entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Approvisionner $approvisionner)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('approvisionner_delete', array('id' => $approvisionner->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
