<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Api;
use AMLA\SqrBundle\Entity\Atd;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Api controller.
 *
 * @Route("api")
 */
class ApiController extends Controller
{
    /**
     * Lists all api entities.
     *
     * @Route("/", name="api_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $apis = $em->getRepository('AMLASqrBundle:Api')->findAll();

        return $this->render('api/index.html.twig', array(
            'apis' => $apis,
        ));
    }

    /**
     * Lists all api entities.
     *
     * @Route("/bill", name="api_bill_index")
     * @Method("GET")
     */
    public function billAction(Request $request )
    {
        $em = $this->getDoctrine()->getManager();

        ///start attestation vérif
        $name = 'ATTEST_VERIF_IMPOT'.mt_rand(0,1000).'.pdf';
        $target = __DIR__.'/../../../../web/Production_documentaire/factures/';

        $pdf = $this->renderView('api/bill.html.twig', array(
            // 'imageqr'=> $impotVerif->getQrCode()->getChemin(),
            //'impotVerif' => $impotVerif,
            'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
        ));

        try{

            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            if (file_exists($target) != 1)
            {
                mkdir($target,0777,true);
                $mpdf->Output($target.$name, 'F');
            }else
            {
                $mpdf->Output($target.$name, 'F');
            }

        }catch(MpdfException $e)
        {

            die($e->getMessage());
        }

        return $this->render('api/bill.html.twig', array(
            ///'apis' => $apis,
            'base_dir' => $this->get('kernel')->getRootDir().'/../web'.$request->getBasePath(),
            
        ));
    }


    
     /**
     * Add an atd
     *
     * @Route("/add/atd", name="api_add_atd")
     * @Method({"GET", "POST"})
     */
    public function addAtdAction(Request $request )
    {
        $em = $this->getDoctrine()->getManager();

        $numeroAtd = $request->get('numeroAtd');
        $nomMisEnCause = $request->get('nomMisEnCause');
        $misEnCause = $request->get('niuMisEnCause ');
        $montantHt = $request->get('montantHt');
        $montantTtc = $request->get('montantTtc');
        $resteAPayer = $request->get('resteAPayer');
        $devise = $request->get('devise');
        $autoriteCompetente = $request->get('autoriteCompetente');
        $emailAutorite = $request->get('emailAutorite');
        $telephoneAutorite = $request->get('telephoneAutorite');
        $referenceDecision = $request->get('referenceDecision');
        $signataire = $request->get('signataire');
        $dateDecision = $request->get('dateDecision');
        $critereDiffusion = $request->get('critereDiffusion');

        if(!empty($request->files->get('justificatif')))
        {
            // $file stores the uploaded PDF file
            /** @var Symfony\Component\HttpFoundation\File\UploadedFile $file */
            $file = $request->files->get('justificatif');

            $fileName = $this->generateUniqueFileName().'.'.$file->guessExtension();

            // Move the file to the directory where brochures are stored
            try 
            {
                $file->move(
                    $this->getParameter('justificatif_directory'),
                    $fileName
                );
            } catch (FileException $e) 
            {
                // ... handle exception if something happens during file upload
            }

            // updates the 'brochure' property to store the PDF file name
            // instead of its contents
            //$atd->setJustificatif($fileName);
            $justificatif='ATD/justificatifs/'.$fileName;

            // ... persist the $product variable or any other work
        }else
        {
            $justificatif=Null;
        }

        if(!empty($nomMisEnCause) || !empty($nomMisEnCause))
        {
            $atd = new Atd();
            $atd->setMisEnCause($nomMisEnCause);
            $atd->setNomMisEnCause($nomMisEnCause);
            $atd->setMontant($montanttc);
            $atd->setMontantHt($montantHt);
            $atd->setResteAPayer($resteAPayer);
            $atd->setDevise($devise);
            $atd->setAutoriteCompetente($autoriteCompetente);
            $atd->setEmailAutorite($emailAutorite);
            $atd->setTelephoneAutorite($telephoneAutorite);
            $atd->setReferenceDecision($referenceDecision);
            $atd->setSignataire($signataire);
            $atd->setDateDecision($dateDecision);
            $atd->setCritereDiffusion($critereDiffusion);

            $em->flush($atd);
            $em->persist();
        }

        $tabRetour = array(
            'checktatoo_id' => (empty($num)) ? '458-639-485-965' : $num,
            'Numero_atd' => (empty($atdNumber)) ? '2568987855' : $atdNumber,
            'status' => (empty($status)) ? 'OK' : $status,
            'status_message' => (empty($rep)) ? 'ATD émis avec succès' : $rep,
        );

        $response = new JsonResponse($tabRetour);
        return $response;
    }

    
    
     /**
     * Check if atd status 
     *
     * @Route("/check/atd/status", name="api_check_atd_status")
     * @Method({"GET", "POST"})
     */
    public function checkAtdStatusAction(Request $request )
    {
        $em = $this->getDoctrine()->getManager();

        $numeroAtd = $request->get('numeroAtd');
        //$referenceChecktatoo = $request->get('referenceChecktatoo ');        
        
        if(!empty($numeroAtd))
        {
            $atd = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(['numeroAtd'=>$numeroAtd]);

            if(!empty($atd))
            {
                //dump($atd);die;
                $tabRetour = array(
                    'Numero_atd' => $atd->getNumeroAtd(),
                    'statut_atd'=>$atd->getAtdStatus($atd->getStatut()),
                    'reste_a_payer'=>$atd->getResteAPayer(),
                    'status_message' => (empty($rep)) ? 'Success' : $rep,
                );
            }else
            {
                $tabRetour = array(
                    'status_message' => (empty($rep)) ? 'Aucun ATD trouvé pour ce numéro' : $rep,
                );
            }            

        }else
        {
            $tabRetour = array(
                'status_message' => (empty($rep)) ? 'Erreurs lors de l\'envoi des paramètres' : $rep,
            );
        }

        $response = new JsonResponse($tabRetour);
        return $response;
    }
    
    /**
    * Check if atd status 
    *
    * @Route("/suspend/atd/status", name="api_suspend_atd_status")
    * @Method({"GET", "POST"})
    */
   public function suspendAtdStatusAction(Request $request )
   {
       $em = $this->getDoctrine()->getManager();

       $numeroAtd = $request->get('numeroAtd');
       //$referenceChecktatoo = $request->get('referenceChecktatoo ');        
       
       if(!empty($numeroAtd))
       {
           $atd = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(['numeroAtd'=>$numeroAtd]);

           if(!empty($atd))
           {
               $atd->setStatut(4); // suspendre
                $em->persist($atd);
                $em->flush();
               //dump($atd);die;
               $tabRetour = array(
                   'Numero_atd' => $atd->getNumeroAtd(),
                   'statut_atd'=>$atd->getAtdStatus($atd->getStatut()),
                   'reste_a_payer'=>$atd->getResteAPayer(),
                   'status_message' => (empty($rep)) ? 'Statut changé à suspendu avec succès' : $rep,
               );

           }else
           {
               $tabRetour = array(
                   'status_message' => (empty($rep)) ? 'Aucun ATD trouvé pour ce numéro' : $rep,
               );
           }            

       }else
       {
           $tabRetour = array(
               'status_message' => (empty($rep)) ? 'Erreurs lors de l\'envoi des paramètres' : $rep,
           );
       }

       $response = new JsonResponse($tabRetour);
       return $response;
   }


    /**
     * Creates a new api entity.
     *
     * @Route("/new", name="api_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $api = new Api();
        $form = $this->createForm('AMLA\SqrBundle\Form\ApiType', $api);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($api);
            $em->flush();

            return $this->redirectToRoute('api_show', array('id' => $api->getId()));
        }

        return $this->render('api/new.html.twig', array(
            'api' => $api,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a api entity.
     *
     * @Route("/{id}", name="api_show")
     * @Method("GET")
     */
    public function showAction(Api $api)
    {
        $deleteForm = $this->createDeleteForm($api);

        return $this->render('api/show.html.twig', array(
            'api' => $api,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing api entity.
     *
     * @Route("/{id}/edit", name="api_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Api $api)
    {
        $deleteForm = $this->createDeleteForm($api);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ApiType', $api);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('api_edit', array('id' => $api->getId()));
        }

        return $this->render('api/edit.html.twig', array(
            'api' => $api,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a api entity.
     *
     * @Route("/{id}", name="api_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Api $api)
    {
        $form = $this->createDeleteForm($api);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($api);
            $em->flush();
        }

        return $this->redirectToRoute('api_index');
    }

    /**
     * Creates a form to delete a api entity.
     *
     * @param Api $api The api entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Api $api)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('api_delete', array('id' => $api->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
