<?php

namespace AMLA\SqrBundle\Controller;

use Mpdf\Mpdf;
use Mpdf\MpdfException;
use Endroid\QrCode\QrCode;
use AMLA\SqrBundle\Entity\Anr;
use AMLA\SqrBundle\Entity\CheckQr;
use Endroid\QrCode\LabelAlignment;
use AMLA\SqrBundle\Entity\Attestation;
use AMLA\SqrBundle\Entity\Fournissseur;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\Response\QrCodeResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use AMLA\SqrBundle\Entity\AttestationVerification;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Anr controller.
 *
 * @Route("anr/{_locale}", defaults = {"_locale" = "fr"})
 */
class AnrController extends Controller
{
    /**
     * Lists all anr entities.
     *
     * @Route("/", name="anr_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $user = $this->getUser();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
       
        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(array('fournisseur'=>$fournisseur), array('id'=>'asc'));

        return $this->render('anr/index.html.twig', array(
            'anrs' => $anrs,
        ));
    }

    /**
     * Creates a new anr entity.
     *
     * @Route("/new", name="anr_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $anr = new Anr();
        $form = $this->createForm('AMLA\SqrBundle\Form\AnrType', $anr);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            
            $user = $this->getUser();
            $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 
            $anr->setFournisseur($fournisseur);
            //dump($anr);
            
            $dateDebutForm=$form->get('dateDebut')->getData()->format('Y-m-d h:i:s');

            $dateFin = Date("Y-m-d 00:00:00", strtotime($dateDebutForm ." +3 Month"));
            $dateFinFinal = new \Datetime($dateFin);
            //$anr->setDateDebut($form->get('dateDebut')->getData());
            $anr->setDateFin($dateFinFinal);
            
            //dump($anr);die;
            $em->persist($anr);
            $em->flush();

            return $this->redirectToRoute('anr_show', array('id' => $anr->getId()));
        }

        return $this->render('anr/new.html.twig', array(
            'anr' => $anr,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a anr entity.
     *
     * @Route("/{id}", name="anr_show")
     * @Method("GET")
     */
    public function showAction(Anr $anr)
    {
        $deleteForm = $this->createDeleteForm($anr);

        return $this->render('anr/show.html.twig', array(
            'anr' => $anr,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Verify ANRs et niu.
     *
     * @Route("/verify/verify", name="anr_verify")
     * @Method("GET")
     */
    public function verifyAction(Request $request)
    {
       //Vérification
       //Si bon génération du pdf
       $id = $request->get('id');
       
       //user vérifié
        $em = $this->getDoctrine()->getManager();
        $fournisseur = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneById($id);
        //user actif
        $user = $this->getUser();
        $fourni = $em->getRepository('AMLASqrBundle:Fournissseur')->findOneBy(['account'=>$user->getId()]); 

        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(['fournisseur'=>$fournisseur]);

        $datejour = new \Datetime("now");
        $target = __DIR__.'/../../../../web/generated/attestations/verification/entreprise_'.trim($fournisseur->getRaisonSociale()).'/';
        $name = 'ATTEST_VERIF_'.mt_rand(0,1000).'_'.$fournisseur->getNiu().'.pdf';

        // Vérif ATD
        $atd = $em->getRepository('AMLASqrBundle:Atd')->findOneBy(['misEnCause'=>$fournisseur->getNiu()]);
        //dump($atds);die;

        if ($atd != NULL ) 
        {
            if($atd->getMontant() > 0)
            {
                $statutATD = 'OUI';
            }else
            {
                $statutATD = 'NON';
            }                
        }
        else
        {
            $statutATD = 'NON DISPONIBLE';
        }

        //Vérif statut ANR
        $anrs = $em->getRepository('AMLASqrBundle:Anr')->findBy(['fournisseur'=>$fournisseur]);
        //$statutANR = 'EXPIRE';

        if($anrs != NULL)
        {
            foreach ($anrs as $anr) 
            {            
                if($anr->getDateFin() < $datejour)
                {

                    $statutANR = 'NON VALIDE';
                    $verif = false;
                }else
                {

                    $statutANR = 'VALIDE'; 
                    $verif = true;
                    break;
                }
            }

        }else{

            $statutANR = 'NON DISPONIBLE';
            $verif = false;
        }

        $attestationVerif = new AttestationVerification();
        $attestationVerif->setVerificateur($fourni);
        $attestationVerif->setFournisseur($fournisseur);
        //1. Préparation du post pour l'API
        $cle = 'MW7-ZDT-LDQ';
        $piece = 'Attestation de Vérification';
        $proprietaire = 'Vérificateur: '.$fourni->getRaisonSociale().' '.'Vérifié: '.$fournisseur->getRaisonSociale();

        $post = array(
            'cle' => $cle,
            'pieceqr'=> $piece, 
            'proprietaire' => $proprietaire, 
            'Reference de l\'attestation' => $attestationVerif->getReference(),
            'Statut de l\'ANR' =>  $statutANR,
            'Statut de l\'ATD' => $statutATD,
        );
        //2. Requête à l'API
         $container = $this->container;
        $api = new SqrApi($container);
        $res = $api->callAPI($post);
        //3. Récupération de la réponse pour nourrir checkqr
        if($res[0]){

            $qr = $res[0]->qr;
            $num = $res[0]->niu; 
        }
        $newname = 'ATTEST_VERIF'.date('YmdHis',time()).mt_rand(0,1000).'.png';
        $checkqr = $api->generateQr($qr,$num,$newname);
        $checkqr->setChemin($newname);
        //4. Liaison avec attestation vérification
        $attestationVerif->setQrCode($checkqr);
        //5. Création de attestation
        $attestation = new Attestation();
        //6. Liaison avec attestation vérification
        $pdf = $this->renderView('attestationverification/attestation.html.1.twig', array(
            'fournisseur' => $fournisseur,
            'moa' => $fourni,
            'imageqr'=> $attestationVerif->getQrCode()->getChemin(),
            'attestation' => $attestationVerif,
            'anr' =>$statutANR,
            'atd' =>$statutATD,
            'base_dir' => $this->get('kernel')->getRootDir() . '/../web' . $request->getBasePath(),
            ));

        try{

            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            if (file_exists($target) != 1) {
    
                mkdir($target,0777,true);
                $mpdf->Output($target.$name, 'F');
            }else{
                $mpdf->Output($target.$name, 'F');
            }
    
        }catch(MpdfException $e){
    
            die($e->getMessage());
        }

        //7. Envoie des mails
        $msg = (new \Swift_Message('CHECKTATOO - Attestation de vérification'))
        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
        ->setTo($fourni->getAdresseEmail())
        ->setBody(
            $this->renderView(
                'emails/notifattestation.html.twig',array(
                    'verificateur' =>$fourni,
                    'verifie' => $fournisseur,
                )
            ),
            'text/html'
        )
        ->attach(\Swift_Attachment::fromPath($target.$name));
        $this->get('mailer')->send($msg);

        $msg = (new \Swift_Message('CHECKTATOO - Attestation de vérification'))
        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
        ->setTo($fournisseur->getAdresseEmail())
        ->setBody(
            $this->renderView(
                'emails/notifattestation.html.twig',array(
                    'verificateur' =>$fourni,
                    'verifie' => $fournisseur,
                )
            ),
            'text/html'
        )
        ->attach(\Swift_Attachment::fromPath($target.$name));
        $this->get('mailer')->send($msg);

        $attestation->setPath($name);
        $attestation->setSize(0);//filesize($target.$name));
        $attestation->setName($name);
        $attestation->setThumb($name);
        $attestation->setAttestationVerif($attestationVerif);
        $attestationVerif->setPdf('generated/attestations/verification/entreprise_'.trim($fournisseur->getRaisonSociale()).'/'.$name);
        
        $em->persist($checkqr);
        $em->persist($attestationVerif);
        $em->persist($attestation);
        $em->flush();

        $response = ['verification'=>$statutANR];
       
        return new JsonResponse($response);
    }

    /**
     * Displays a form to edit an existing anr entity.
     *
     * @Route("/{id}/edit", name="anr_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Anr $anr)
    {
        $deleteForm = $this->createDeleteForm($anr);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\AnrType', $anr);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('anr_edit', array('id' => $anr->getId()));
        }

        return $this->render('anr/edit.html.twig', array(
            'anr' => $anr,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a anr entity.
     *
     * @Route("/{id}", name="anr_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Anr $anr)
    {
        $form = $this->createDeleteForm($anr);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($anr);
            $em->flush();
        }

        return $this->redirectToRoute('anr_index');
    }

    /**
     * Creates a form to delete a anr entity.
     *
     * @param Anr $anr The anr entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Anr $anr)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('anr_delete', array('id' => $anr->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
