<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Analytique;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Analytique controller.
 *
 * @Route("analytique/{_locale}", defaults = {"_locale" = "fr"})
 */
class AnalytiqueController extends Controller
{
    /**
     * Lists all analytique entities.
     *
     * @Route("/", name="analytique_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $analytique = $em->getRepository('AMLASqrBundle:Analytique')->findOneBy(['id'=>1]);
        if(empty($analytique))
        {
            $analytique = new Analytique();

            $em = $this->getDoctrine()->getManager();
            $em->persist($analytique);
            $em->flush();
        }

        return $this->render('analytique/index.html.twig', array(
            'analytique' => $analytique,
        ));
    }

    /**
     * Creates a new analytique entity.
     *
     * @Route("/new", name="analytique_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $analytique = new Analytique();
        $form = $this->createForm('AMLA\SqrBundle\Form\AnalytiqueType', $analytique);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($analytique);
            $em->flush();

            return $this->redirectToRoute('analytique_show', array('id' => $analytique->getId()));
        }

        return $this->render('analytique/new.html.twig', array(
            'analytique' => $analytique,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a analytique entity.
     *
     * @Route("/{id}", name="analytique_show")
     * @Method("GET")
     */
    public function showAction(Analytique $analytique)
    {
        $deleteForm = $this->createDeleteForm($analytique);

        return $this->render('analytique/show.html.twig', array(
            'analytique' => $analytique,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing analytique entity.
     *
     * @Route("/{id}/edit", name="analytique_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Analytique $analytique)
    {
        $deleteForm = $this->createDeleteForm($analytique);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\AnalytiqueType', $analytique);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('analytique_edit', array('id' => $analytique->getId()));
        }

        return $this->render('analytique/edit.html.twig', array(
            'analytique' => $analytique,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a analytique entity.
     *
     * @Route("/{id}", name="analytique_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Analytique $analytique)
    {
        $form = $this->createDeleteForm($analytique);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($analytique);
            $em->flush();
        }

        return $this->redirectToRoute('analytique_index');
    }

    /**
     * Creates a form to delete a analytique entity.
     *
     * @param Analytique $analytique The analytique entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Analytique $analytique)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('analytique_delete', array('id' => $analytique->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
