<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\Alerte;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Alerte controller.
 *
 * @Route("alerte/{_locale}", defaults = {"_locale" = "fr"})
 */
class AlerteController extends Controller
{
    /**
     * Lists all alerte entities.
     *
     * @Route("/", name="alerte_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $alertes = $em->getRepository('AMLASqrBundle:Alerte')->findAll();

        return $this->render('alerte/index.html.twig', array(
            'alertes' => $alertes,
        ));
    }

    /**
     * Creates a new alerte entity.
     *
     * @Route("/new", name="alerte_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $alerte = new Alerte();
        $form = $this->createForm('AMLA\SqrBundle\Form\AlerteType', $alerte);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($alerte);
            $em->flush();

            return $this->redirectToRoute('alerte_show', array('id' => $alerte->getId()));
        }

        return $this->render('alerte/new.html.twig', array(
            'alerte' => $alerte,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a alerte entity.
     *
     * @Route("/{id}", name="alerte_show")
     * @Method("GET")
     */
    public function showAction(Alerte $alerte)
    {
        $deleteForm = $this->createDeleteForm($alerte);

        return $this->render('alerte/show.html.twig', array(
            'alerte' => $alerte,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing alerte entity.
     *
     * @Route("/{id}/edit", name="alerte_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, Alerte $alerte)
    {
        $deleteForm = $this->createDeleteForm($alerte);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\AlerteType', $alerte);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('alerte_edit', array('id' => $alerte->getId()));
        }

        return $this->render('alerte/edit.html.twig', array(
            'alerte' => $alerte,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a alerte entity.
     *
     * @Route("/{id}", name="alerte_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, Alerte $alerte)
    {
        $form = $this->createDeleteForm($alerte);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($alerte);
            $em->flush();
        }

        return $this->redirectToRoute('alerte_index');
    }

    /**
     * Creates a form to delete a alerte entity.
     *
     * @param Alerte $alerte The alerte entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(Alerte $alerte)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('alerte_delete', array('id' => $alerte->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
