<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\ATDCantonne;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Atdcantonne controller.
 *
 * @Route("atdcantonne/{_locale}", defaults = {"_locale" = "fr"})
 */
class ATDCantonneController extends Controller
{
    /**
     * Lists all aTDCantonne entities.
     *
     * @Route("/", name="atdcantonne_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $aTDCantonnes = $em->getRepository('AMLASqrBundle:ATDCantonne')->findAll();

        return $this->render('atdcantonne/index.html.twig', array(
            'aTDCantonnes' => $aTDCantonnes,
        ));
    }

    /**
     * Creates a new aTDCantonne entity.
     *
     * @Route("/new", name="atdcantonne_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $aTDCantonne = new Atdcantonne();
        $form = $this->createForm('AMLA\SqrBundle\Form\ATDCantonneType', $aTDCantonne);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($aTDCantonne);
            $em->flush();

            return $this->redirectToRoute('atdcantonne_show', array('id' => $aTDCantonne->getId()));
        }

        return $this->render('atdcantonne/new.html.twig', array(
            'aTDCantonne' => $aTDCantonne,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a aTDCantonne entity.
     *
     * @Route("/{id}", name="atdcantonne_show")
     * @Method("GET")
     */
    public function showAction(ATDCantonne $aTDCantonne)
    {
        $deleteForm = $this->createDeleteForm($aTDCantonne);

        return $this->render('atdcantonne/show.html.twig', array(
            'aTDCantonne' => $aTDCantonne,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing aTDCantonne entity.
     *
     * @Route("/{id}/edit", name="atdcantonne_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, ATDCantonne $aTDCantonne)
    {
        $deleteForm = $this->createDeleteForm($aTDCantonne);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\ATDCantonneType', $aTDCantonne);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('atdcantonne_edit', array('id' => $aTDCantonne->getId()));
        }

        return $this->render('atdcantonne/edit.html.twig', array(
            'aTDCantonne' => $aTDCantonne,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a aTDCantonne entity.
     *
     * @Route("/{id}", name="atdcantonne_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, ATDCantonne $aTDCantonne)
    {
        $form = $this->createDeleteForm($aTDCantonne);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($aTDCantonne);
            $em->flush();
        }

        return $this->redirectToRoute('atdcantonne_index');
    }

    /**
     * Creates a form to delete a aTDCantonne entity.
     *
     * @param ATDCantonne $aTDCantonne The aTDCantonne entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(ATDCantonne $aTDCantonne)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('atdcantonne_delete', array('id' => $aTDCantonne->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
