<?php

namespace AMLA\SqrBundle\Controller;

use AMLA\SqrBundle\Entity\AMR;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;use Symfony\Component\HttpFoundation\Request;

/**
 * Amr controller.
 *
 * @Route("amr/{_locale}", defaults = {"_locale" = "fr"})
 */
class AMRController extends Controller
{
    /**
     * Lists all aMR entities.
     *
     * @Route("/", name="amr_index")
     * @Method("GET")
     */
    public function indexAction()
    {
        $em = $this->getDoctrine()->getManager();

        $aMRs = $em->getRepository('AMLASqrBundle:AMR')->findBy(['statut'=>1]);

        return $this->render('amr/index.html.twig', array(
            'aMRs' => $aMRs,
        ));
    }

    /**
     * Lists all aMR entities.
     *
     * @Route("/all", name="amr_index_all")
     * @Method("GET")
     */
    public function indexAllAction()
    {
        $em = $this->getDoctrine()->getManager();

        $aMRs = $em->getRepository('AMLASqrBundle:AMR')->findAll();

        return $this->render('amr/index_all.html.twig', array(
            'aMRs' => $aMRs,
        ));
    }

    /**
     * Creates a new aMR entity.
     *
     * @Route("/new", name="amr_new")
     * @Method({"GET", "POST"})
     */
    public function newAction(Request $request)
    {
        $aMR = new Amr();
        $form = $this->createForm('AMLA\SqrBundle\Form\AMRType', $aMR);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) 
        {
            $em = $this->getDoctrine()->getManager();
            $amrExist = $em->getRepository('AMLASqrBundle:AMR')->findOneBy(['niu'=>$aMR->getNiu(), 'statut'=>1]);
            if(!$amrExist)
            {
                $aMR->setAccount($this->getUser());
                $em->persist($aMR);
                $em->flush();

                $this->get('session')->getFlashBag()->add('success', 'Entreprise mis en recouvrement avec succèss.');
                return $this->redirectToRoute('amr_show', array('id' => $aMR->getId()));

            }else{
                $this->get('session')->getFlashBag()->add('danger', 'Impossible de mettre cette entreprise en recouvrement car elle est déjà mis en recouvrement');
            }

        }

        return $this->render('amr/new.html.twig', array(
            'aMR' => $aMR,
            'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a aMR entity.
     *
     * @Route("/{id}", name="amr_show")
     * @Method("GET")
     */
    public function showAction(AMR $aMR)
    {
        $deleteForm = $this->createDeleteForm($aMR);

        return $this->render('amr/show.html.twig', array(
            'aMR' => $aMR,
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Finds and displays a aMR entity.
     *
     * @Route("/{id}/traitements", name="amr_traiter")
     * @Method("GET")
     */
    public function traiterAction(AMR $aMR)
    {
        $em = $this->getDoctrine()->getManager();
        $aMR->setStatut(0);
        $em->persist($aMR);
        $em->flush();

        return $this->render('amr/show.html.twig', array(
            'aMR' => $aMR,
        ));
    }

    /**
     * Displays a form to edit an existing aMR entity.
     *
     * @Route("/{id}/edit", name="amr_edit")
     * @Method({"GET", "POST"})
     */
    public function editAction(Request $request, AMR $aMR)
    {
        $deleteForm = $this->createDeleteForm($aMR);
        $editForm = $this->createForm('AMLA\SqrBundle\Form\AMRType', $aMR);
        $editForm->handleRequest($request);

        if ($editForm->isSubmitted() && $editForm->isValid()) {
            $this->getDoctrine()->getManager()->flush();

            return $this->redirectToRoute('amr_edit', array('id' => $aMR->getId()));
        }

        return $this->render('amr/edit.html.twig', array(
            'aMR' => $aMR,
            'edit_form' => $editForm->createView(),
            'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a aMR entity.
     *
     * @Route("/{id}", name="amr_delete")
     * @Method("DELETE")
     */
    public function deleteAction(Request $request, AMR $aMR)
    {
        $form = $this->createDeleteForm($aMR);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->remove($aMR);
            $em->flush();
        }

        return $this->redirectToRoute('amr_index');
    }

    /**
     * Creates a form to delete a aMR entity.
     *
     * @param AMR $aMR The aMR entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm(AMR $aMR)
    {
        return $this->createFormBuilder()
            ->setAction($this->generateUrl('amr_delete', array('id' => $aMR->getId())))
            ->setMethod('DELETE')
            ->getForm()
        ;
    }
}
