<?php
namespace AMLA\SqrBundle\API;

use Endroid\QrCode\QrCode;
use AMLA\SqrBundle\Entity\CheckQr;
use Endroid\QrCode\LabelAlignment;
use Endroid\QrCode\ErrorCorrectionLevel;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Session\Session;  
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpKernel\Event\FilterResponseEvent;  


class SqrApi{


    private $container;

    public function __construct(ContainerInterface $container) // <- Add this
    {
        $this->container = $container;
    }

    public function getReceiver()
    {
        return $this->container->getParameter('api_receiver'); // <- Access your param
    }

    public function getHandler()
    {
        return $this->container->getParameter('api_create'); // <- Access your param
    }

    public  function uploadToAPI($file){

        $postData =  array(
            'filename' => basename($file),
            'fileData' => base64_encode(\file_get_contents($file))
        );

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $this->getReceiver());
        curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($curl, CURLOPT_POST, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $postData);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

     /**
     * Call API
     */
    public function callAPI(array $post){

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,$this->getHandler());
        //curl_setopt($curl, CURLOPT_TIMEOUT, 30);
        curl_setopt($ch, CURLOPT_POST,1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $post);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        if (curl_error($ch)) {

            $error_msg = curl_error($ch);
        }
        $res = json_decode(trim($result));
        curl_close($ch);
        return $res;
    }

    /**
     * Generate QR 
     * @param {String $qr,String $num 
     */
    public function generateQr($qr, $num, $newname){

        $imglabel = __DIR__.'/../../../../web/imglabel/';
        $im = imagecreatetruecolor(139, 139);
        $red = imagecolorallocate($im, 0xFF, 0x00, 0x00);
        $black = imagecolorallocate($im, 0x00, 0x00, 0x00);
        $white = imagecolorallocate($im, 0xFF, 0xFF, 0xFF);
        // Définit l'arrière-plan en blanc
        imagefilledrectangle($im, 2, 2, 136, 136, $white);
        // Chemin vers notre fichier de police ttf
        $font_file = __DIR__.'/../../../../web/fonts/arial.ttf';
        // Dessine les textes  en utilisant une police de taille 13
        imagefttext($im, 13, 0, 35, 16, $black, $font_file, 'FREEVENDING');
        imagefttext($im, 12, 0, 30, 134, $black, $font_file, $num);
        $img = 'label.png';
        //On dépose le squelette dans une arborescence du serveur
        if(file_exists($imglabel) != 1){

            mkdir($imglabel ,0777,true);
            imagepng($im, $imglabel.$img);

        }else{

            imagepng($im, $imglabel.$img);
        }
        //On déssine des lignes noires en haut et en bas du squelette pour délimiter la zone où on posera le QR
        $imh = imagecreatefrompng($imglabel.$img);
        imageline($imh, 0, 20, 139, 20, $black);
        if(file_exists($imglabel) != 1){

            mkdir($imglabel ,0777,true);
            imagepng($imh, $imglabel.$img);

        }else{

            imagepng($imh, $imglabel.$img);
        }
        $imd = imagecreatefrompng($imglabel.$img);
        imageline($imd, 0, 119, 139, 119, $black);
        if(file_exists($imglabel) != 1){

            mkdir($imglabel ,0777,true);
            imagepng($imd, $imglabel.$img);

        }else{

            imagepng($imd, $imglabel.$img);
        }
        //On crée l'objet qui permet de persister le QR en BD
        $checkqr = new CheckQr();
        $checkqr->setLibelle($qr);
        $checkqr->setNumero($num);
        //On crée le Qr
        $qrCode = new QrCode($checkqr->getLibelle());
        $qrCode->setSize(100);
        // Set advanced options
        $qrCode->setWriterByName('png');
        $qrCode->setMargin(8);
        $qrCode->setEncoding('UTF-8');
        $qrCode->setErrorCorrectionLevel(new ErrorCorrectionLevel(ErrorCorrectionLevel::HIGH));
        $qrCode->setForegroundColor(['r' => 0, 'g' => 0, 'b' => 0, 'a' => 0]);
        $qrCode->setBackgroundColor(['r' => 255, 'g' => 255, 'b' => 255, 'a' => 0]);
        $qrCode->setRoundBlockSize(true);
        $qrCode->setValidateResult(false);
        //Création du fichier
        $chemin =  $checkqr->getUploadRootDir().'/';

        if(file_exists($chemin) != 1){
            //Stokage de l'image QR et taggage d'avec le niu et le nom de l'application concernée dans le cas où le chemin de stokage n'existe pas    
            mkdir($chemin ,0777,true);
            $qrCode->writeFile($chemin.$newname);
            $dest = imagecreatefrompng($imglabel.$img);
            $src = imagecreatefrompng($chemin.$newname);
            $taille_dest = getimagesize($chemin.$newname);
            $NouvelleLargeur = 95;		 
            // Étape 2 :
            $Reduction = ( ($NouvelleLargeur * 100)/$taille_dest[0] );		 
            // Étape 3 :
            $NouvelleHauteur = ( ($taille_dest[1] * $Reduction)/100 );
            //Etape 1 :
            $NouvelleImage = imagecreatetruecolor($NouvelleLargeur, $NouvelleHauteur) or die ("Erreur");
            //Etape 2 :
            imagecopyresampled($NouvelleImage, $src, 0, 0, 0, 0, $NouvelleLargeur, $NouvelleHauteur, $taille_dest[0], $taille_dest[1]);
            $destx = imagesx($dest);
            $desty = imagesy($dest);
            $largeur_source = imagesx($NouvelleImage);
            $hauteur_source = imagesy($NouvelleImage);
            $pox = $destx - $largeur_source;
            $poy = $desty - $hauteur_source;
            imagecopymerge($dest, $NouvelleImage, $pox/2, $poy/2, 0, 0, $largeur_source, $hauteur_source, 90);

            if(file_exists($chemin.$newname) != 1){

            mkdir($chemin.$newname ,0777,true);
            imagepng($dest, $chemin.$newname);

            }else{

            imagepng($dest, $chemin.$newname);
            }

        }else
        {
            //Stokage de l'image QR et taggage d'avec le niu et le nom de l'application concernée dans le cas où le chemin existe
            $qrCode->writeFile($chemin.$newname);
            $dest = imagecreatefrompng($imglabel.$img);
            $src = imagecreatefrompng($chemin.$newname);
            $taille_dest = getimagesize($chemin.$newname);
            $NouvelleLargeur = 95;		 
            // Étape 2 :
            $Reduction = ( ($NouvelleLargeur * 100)/$taille_dest[0] );		 
            // Étape 3 :
            $NouvelleHauteur = ( ($taille_dest[1] * $Reduction)/100 );
            //Etape 1 :
            $NouvelleImage = imagecreatetruecolor($NouvelleLargeur , $NouvelleHauteur) or die ("Erreur");
            //Etape 2 :
            imagecopyresampled($NouvelleImage , $src, 0, 0, 0, 0, $NouvelleLargeur, $NouvelleHauteur, $taille_dest[0],$taille_dest[1]);
            $destx = imagesx($dest);
            $desty = imagesy($dest);
            $largeur_source = imagesx($NouvelleImage);
            $hauteur_source = imagesy($NouvelleImage);
            $pox = $destx - $largeur_source;
            $poy = $desty - $hauteur_source;
            imagecopymerge($dest, $NouvelleImage, $pox/2, $poy/2, 0, 0, $largeur_source, $hauteur_source, 90);

            if(file_exists($chemin.$newname) != 1){

                mkdir($chemin.$newname ,0777,true);
                imagepng($dest, $chemin.$newname);

            }else
            {

                imagepng($dest, $chemin.$newname);
            }
        }

        /* if(file_exists($chemin) != 1){

            mkdir($chemin ,0777,true);
            $source = imagecreatefrompng($chemin.$newname);

        }else{

            $source = imagecreatefrompng($chemin.$newname);   
        }
        */
        return  $checkqr;
    }
}