<?php

namespace AMLA\ApiBundle\Util;

/**
 * UrlUtil
 */
class UrlUtil
{

    /**
     * Build url and set parameters
     * @param $url
     * @param $allParams
     * @return string
     */
    public static function buildUrl($url, $allParams){
        if(!empty($url)){
            $parsedUrl = parse_url($url);
            // Build params array
            $params = array();
            if(isset($parsedUrl['query']))
                parse_str($parsedUrl['query'], $params);

            foreach ($allParams as $key => $value)
                $params[$key] = $value;

            // Encode all values
            $parsedUrl['query'] = http_build_query($params);

            return  $parsedUrl['path'] . '?' . $parsedUrl['query'];
        }
        return "";
    }

}