<?php

namespace AMLA\ApiBundle\Util;

use AMLA\ApiBundle\Config\Constants;

/**
 * StringUtil
 */
class StringUtil
{

    const DATETIME_FORMAT = 'Y-m-d H:i:s';

    /**
     * Generate token key
     * @param $length
     * @return string
     * @throws \Error
     * @throws \Exception
     * @throws \TypeError
     */
    static function getToken($length = Constants::TOKEN_LENGTH){
        $token = "";
        $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        $codeAlphabet.= "abcdefghijklmnopqrstuvwxyz";
        $codeAlphabet.= "0123456789";
        $max = strlen($codeAlphabet); // edited

        for ($i=0; $i < $length; $i++) {
            $token .= $codeAlphabet[random_int(0, $max-1)];
        }
        $token = base64_encode($token);
        return strtoupper($token);
    }

}