<?php

namespace AMLA\ApiBundle\Controller\User;

use AMLA\ApiBundle\Exception\ResourceNotFoundException;
//use AMLA\ApiBundle\Model\Filter\QueryDataFilter;
//use AMLA\ApiBundle\Model\Representation\Impl\_GastraceCardResource;
//use AMLA\ApiBundle\Model\Representation\Impl\_Sell;
use AMLA\SqrBundle\Entity\EnregistrementPm;
use AMLA\SqrBundle\Entity\EnregistrementPp;
use AMLA\SqrBundle\Entity\Agence;
use AMLA\SqrBundle\Entity\Account;
use AMLA\SqrBundle\Model\AgenceResource;
use FOS\RestBundle\Controller\FOSRestController;
use AMLA\ApiBundle\Common\Secure\TokenAuthenticated;
use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;
use AMLA\SqrBundle\Controller\EnregistrementPmController as EnregPm;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\CheckQr;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

/**
 * UserController
 */
class UserController extends FOSRestController
{

    use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * login
     *
     * @Rest\Post(
     *    path = "login",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function accountLoginAction(Request $request)
    {
        $this->checkApiAccess($request);       
         // Perform login
        $response = $this->apiLogin($request);
        //dump($response);die;
        if ($response == null) 
        {
            $response = array(
                'Etat' =>'FAILED' , 
                'Message' =>'Unknown user' , 
                'login' =>$request->get('login'), 
                //'password' =>$request->get('password'),
            );
        }
        /*if($response == null)
            throw new ResourceNotFoundException(sprintf("Unknown user"));
        */
        return $response;
    }

    /**
     * login
     *
     * @Rest\Post(
     *    path = "signin",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     * @throws ResourceNotFoundException
     */
    public function accountSignAction( Request $request)
    {
        //$resul = $this->checkApiAccess($request);
        //dump($resul);die;       
         // Perform login
        if(empty($resul))
        {
            $response = $this->apiSignIn($request);
            if ($response == null) 
            {
                $response = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>'Unknown user' , 
                    'login' =>$request->get('login'), 
                    //'password' =>$request->get('password'),
                );
            }
        }else
        {
            $response = $resul;
        }
        //dump($response);die;
       
        /*if($response == null)
            throw new ResourceNotFoundException(sprintf("Unknown user"));
        */
        return $response;
    }

    
    /**
     * login
     *
     * @Rest\Post(
     *    path = "signout",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     * @throws ResourceNotFoundException
     */
    public function accountSignOutAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);dump($user instanceof Account); die();
        if (is_object($user))
        {
            $response = $this->apiSignOutUser($user);
        }else
        {
            $response  = $user;
            /*$response  = array(
                'Etat' =>'FAILED' , 
                'Message' =>'An error occured. try again with a valid token', 
            );*/
        }
        return $response;
    }

    
    /**
     * user register
     *
     * @Rest\Post(
     *    path = "register",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function createUserAccountAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
            $em = $this->entityManager();

            $nom = $request->get('nom');
            $prenom = $request->get('prenom');
            $email = $request->get('email');
            $telephone = $request->get('telephone');
            $dateNaiss = $request->get('dateNaiss');
            $numeroPiece = $request->get('numeroPiece');
            $typePiece = $request->get('typePiece');
            $dateExpirationPiece = $request->get('dateExpirationPiece');
            $niu = $request->get('niu');
            $loginUser = $request->get('loginUser');
            $password = $request->get('password');
            //intermédiaire
            //agent
            $typeCompte = $request->get('typeCompte');//2 = freelance 1=réseau
            $role = $request->get('role');

            $account = $em->getRepository("AMLASqrBundle:Account")->findOneBy(array("loginUser" => $loginUser));
            if (empty($account))
            {   
                if(in_array($role, ["41", "42"], true))
                {
                    if (!empty($nom) && !empty($prenom) && !empty($email) && !empty($telephone) && !empty($dateNaiss) && !empty($numeroPiece) && !empty($typePiece) && !empty($dateExpirationPiece) && !empty($niu) && !empty($loginUser) && !empty($password))
                    {
                        
                        $account = new Account();
                        //$account->setSource(5);
                        
                        $account->setNom($nom);
                        $account->setPrenom($prenom);
                        $account->setEmail($email);
                        $account->setTelephone($telephone);
                        $account->setDateNaiss(empty(new \DateTime($request->get('dateNaiss'))) ? '' : new \DateTime($request->get('dateNaiss')));
                        $account->setNumeroPiece($numeroPiece);
                        $account->setTypePiece($typePiece);                
                        $account->setDateExpirationPiece(empty(new \DateTime($request->get('dateExpirationPiece'))) ? '' : new \DateTime($request->get('dateExpirationPiece')));
                        $account->setNiu($niu);
                        $account->setLoginUser($loginUser);
                        $account->setPassword($password);
                        $account->setRole($role);
                        
                        $account->setAgence($user->getAgence());
                        if($user->getRole() == '42')
                        {
                            $account->setIntermediaire($user);
                        }
    
                        //41 AGENT 42 INTERMEDIAIRE 43 CHEF POLE
                        switch ($role)
                        {
                            case '41': //intermédiaire                                
                                $account->setTypeCompte($typeCompte);
                                break;
                            case '43':
                               // $account->setAgence($user->getAgence());
                                break;                        
                            default:
                                # code...
                                break;
                        }
                        
                        $em->persist($account);
                        $em->flush();
    
                        $return = array(
                            'Etat' =>'SUCCESS' , 
                            'Message' =>'Enregistrement effectué avec succès', 
                            'objet' => $account,
                        );
    
                    }else
                    {
                        $return = array(
                            'Etat' =>'FAILED' , 
                            'Message' =>"Champs requis manquants", 
                            //'objet' =>$lienNiuPp,
                        );
                    }
                }else{
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>'Opération non autorisé. Vous ne pouvez pas enregistrer un utilisateur ayant ce rôle', 
                        'role'=>$role,
                    ); 
                }
            }else
            {
                $return = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>'Ce nom d\'utilisateur est déjà utilisé', 
                );  
            }

           
        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    /**
     * user Edit
     *
     * @Rest\Post(
     *    path = "edit",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function EditUserAccountAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
            $nom = $request->get('nom');
            $prenom = $request->get('prenom');
            $email = $request->get('email');
            $telephone = $request->get('telephone');
            $niu = $request->get('niu');

            $em = $this->entityManager();
            //$account->setSource(5);
            
            $account->setNom($nom);
            $account->setPrenom($prenom);
            $account->setEmail($email);
            $account->setTelephone($telephone);
            $account->setNiu($niu);
            
            $em->persist($account);
            $em->flush();

            $return = array(
                'Etat' =>'SUCCESS' , 
                'Message' =>'Modification effectuée avec succès', 
                'objet' => $account,
            );            

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    
    /**
     * user reset
     *
     * @Rest\Post(
     *    path = "reset",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function ResetUserAccountAction(Request $request)
    {
        if ($request->get('login') && !empty($request->get('login')))
        {
            $login = $request->get('login');
            $em = $this->entityManager();
            
            $user = $em->getRepository("AMLASqrBundle:Account")->findOneBy(array("loginUser" => $login));
            if ($user)
            {
                $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                $passss = substr(str_shuffle($chars), 0, 8);
                //$options = [
                //    'cost' => 15 
                //];
                //$pass = password_hash($passss, PASSWORD_BCRYPT, $options);
                $user->setPassword($passss);
                $user->setPwdUpdt(0);
                $em->persist($user);
                $em->flush();
            
                // On envoie le mot de passe par mail
                $message = (new \Swift_Message('CHECKTATOO : Reinitialisation de mot de passe'))
                    ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO']) // sender
                    ->setTo($user->getEmail())       // recipient
                    ->setBody('Vos paramètres de connexion à la plateforme CHECKTATOO sont 
                        Login:'  . $user->getLoginUser().' 
                        Mot de passe : ' . $passss);

                $this->get('mailer')->send($message);

                $return = array(
                    'Etat' =>'SUCCESS' , 
                    'Message' =>'Mot de passe reinitialisé avec succès.', 
                );      

            }else
            {
                $return = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>'Utilisateur introuvable', 
                );  
            }

        }else
        {
            $return = array(
                'Etat' =>'FAILED' , 
                'Message' =>'Paramètres manquants', 
            );  
        }
        
        return $return;
    }
    
    
    /**
     * user solde
     *
     * @Rest\Post(
     *    path = "solde",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function SoldeAccountAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
            $return = array(
                'Etat' =>'SUCCESS' , 
                'Message' =>'Solde recupéré avec succès', 
                'solde' => $user->getSolde(),
            );            

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

}