<?php

namespace AMLA\ApiBundle\Controller\QualificationFiche;

use AMLA\ApiBundle\Exception\ResourceNotFoundException;
//use AMLA\ApiBundle\Model\Filter\QueryDataFilter;
//use AMLA\ApiBundle\Model\Representation\Impl\_GastraceCardResource;
//use AMLA\ApiBundle\Model\Representation\Impl\_Sell;
use AMLA\SqrBundle\Entity\QualificationFiche;
use AMLA\SqrBundle\Entity\Account;
use AMLA\SqrBundle\Model\AgenceResource;
use FOS\RestBundle\Controller\FOSRestController;
use AMLA\ApiBundle\Common\Secure\TokenAuthenticated;
use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;
use AMLA\SqrBundle\Controller\EnregistrementPmController as EnregPm;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\CheckQr;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

/**
 * QualificationFicheController
 */
class QualificationFicheController extends FOSRestController
{

    use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * New fiche
     *
     * @Rest\Post(
     *    path = "new",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return QualificationFiche
     */
    public function newFicheAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request);      
         
        if ($user instanceof Account)
        {
            $em = $this->entityManager();

            $operateurConformiteCategory = $request->get('idSecteur');
            $operateurConformiteCategoryElement = $request->get('idPartenaire');
            $holder = $request->get('holder');
            $custumerType = $request->get('custumerType');
            $numeroContrat = $request->get('numeroContrat');
            $nomProprietaire = $request->get('nomProprietaire');
            $nom = $request->get('nom');
            $prenom = $request->get('prenom');
            $niu = $request->get('niu');
            $telephone = $request->get('telephone');
            $email = $request->get('email');
            $boitePostale = $request->get('boitePostale');
            $dateNaissance = $request->get('dateNaissance');
            $nomMere = $request->get('nomMere');
            $matricule = $request->get('matricule');
            $cniPasportSejour = $request->get('typePiece');
            $numeroPiece = $request->get('numeroPiece');
            $dateExpiration = $request->get('dateExpiration');
            $fiche = $request->get('fiche');
            $source = $request->get('source');


            $paymentChecker = $this->get('PaymentChecker');
            $rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
            if($rstPay['Etat']=='SUCCESS')
            {
                $secteur = $em->getRepository("AMLASqrBundle:OperateurConformiteCategory")->find($operateurConformiteCategory);
                $partenaire = $em->getRepository("AMLASqrBundle:OperateurConformiteCategoryElement")->find($operateurConformiteCategoryElement);
                if (!empty($secteur) && !empty($partenaire))
                {   
                    $qualificationFiche = new QualificationFiche();

                    $qualificationFiche->setOperateurConformiteCategoryElement($partenaire);
                    $qualificationFiche->setOperateurConformiteCategory($secteur);
                    $qualificationFiche->setCustumerType($custumerType);
                    $qualificationFiche->setNumeroContrat($numeroContrat);                
                    $qualificationFiche->setHolder($holder);
                    $qualificationFiche->setNom($nom);
                    $qualificationFiche->setPrenom($prenom);
                    $qualificationFiche->setNiu($niu);
                    $qualificationFiche->setTelephone($telephone);
                    $qualificationFiche->setEmail($email);
                    $qualificationFiche->setBoitePostale($boitePostale);
                    $qualificationFiche->setDateNaissance(empty(new \DateTime($request->get('dateNaissance'))) ? '' : new \DateTime($request->get('dateNaissance')));
                    $qualificationFiche->setNomMere($nomMere);
                    $qualificationFiche->setMatricule($matricule);
                    $qualificationFiche->setNumeroPiece($numeroPiece);
                    $qualificationFiche->setCniPasportSejour($cniPasportSejour);                
                    $qualificationFiche->setDateExpiration(empty(new \DateTime($request->get('dateExpiration'))) ? '' : new \DateTime($request->get('dateExpiration')));
                    $qualificationFiche->setFiche($fiche); 
                    $qualificationFiche->setAccount($user); 
                    $qualificationFiche->setSource($source); 
                    
                    $em->persist($qualificationFiche);
                    $em->flush();

                    $return = array(
                        'Etat' =>'SUCCESS' , 
                        'Message' =>'Enregistrement effectué avec succès', 
                        'objet' => $qualificationFiche,
                    );
        
                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>'Paramètres manquants', 
                    );  
                }
                
            }else
            {
                $return  = $rstPay;
            }

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    /**
     * New fiche
     *
     * @Rest\Get(
     *    path = "list",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return QualificationFiche
     */
    public function listAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request);      
         
        if ($user instanceof Account)
        {
            $em = $this->entityManager();
            
            $qualificationsFiches = $em->getRepository('AMLASqrBundle:QualificationFiche')->findBy(['account'=>$user], ['id'=>'desc']);
            
            if(empty($qualificationsFiches))
            {
                $return = array(
                    'Etat' =>'SUCCESS' , 
                    'Message' =>"Aucun enregistrement trouvé", 
                    //'objet' =>$lienNiuPp,
                );
            }else
            {
                $return = $qualificationsFiches;
            }
        }else
        {
            $return  = $user;
        }
        return $return;
    }

}