<?php

namespace AMLA\ApiBundle\Controller\Niurequestasset;

use AMLA\ApiBundle\Exception\ResourceNotFoundException;
use AMLA\SqrBundle\Entity\EnregistrementPm;
use AMLA\SqrBundle\Entity\EnregistrementPp;
use AMLA\SqrBundle\Entity\Agence;
use AMLA\SqrBundle\Model\AgenceResource;
use FOS\RestBundle\Controller\FOSRestController;
use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;
use AMLA\SqrBundle\Controller\EnregistrementPmController as EnregPm;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\CheckQr;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

/**
 * Niurequestasset
 */
class NiurequestassetController extends FOSRestController
{

    use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * ville
     *
     * @Rest\Post(
     *    path = "ville",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array
     * @throws ResourceNotFoundException
     */
    public function getVillesAction(ParamFetcherInterface $paramFetcher, Request $request)
    {
        $response = $this->entityManager()->getRepository('AMLASqrBundle:ImpotVille')->findBy([],['id'=>'DESC']);
        
        return $response;
    }


}