<?php

namespace AMLA\ApiBundle\Controller\LienNiuPp;

use AMLA\ApiBundle\Exception\ResourceNotFoundException;
//use AMLA\ApiBundle\Model\Filter\QueryDataFilter;
//use AMLA\ApiBundle\Model\Representation\Impl\_GastraceCardResource;
//use AMLA\ApiBundle\Model\Representation\Impl\_Sell;

use Ramsey\Uuid\Uuid;
use AMLA\SqrBundle\Entity\LienNiuPp;
use AMLA\SqrBundle\Entity\EnregistrementPpCkeck;
use AMLA\SqrBundle\Entity\Account;
use AMLA\SqrBundle\Entity\Agence;
use AMLA\SqrBundle\Model\AgenceResource;
use FOS\RestBundle\Controller\FOSRestController;
use AMLA\ApiBundle\Common\Secure\TokenAuthenticated;
use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;
use AMLA\SqrBundle\Controller\EnregistrementPmController as EnregPm;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\CheckQr;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

/**
 * LienNiuPpController
 */
class LienNiuPpController extends FOSRestController
{

    use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * lien niu
     *
     * @Rest\Post(
     *    path = "personnephysique",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function genererUnLienAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
         
            $em = $this->entityManager();
            $nom = $request->get('nom');
            $prenom = $request->get('prenom');
            $email = $request->get('email');
            $telephone = $request->get('telephone');
            $numCni = $request->get('numCni');
            $typePiece = $request->get('typePiece');
            $dateValiditePiece = $request->get('dateValiditePiece');
            $dateNaissance = $request->get('dateNaissance');
            $lieuNaissance = $request->get('lieuNaissance');

            $lienNiuPp = new LienNiuPp();
            $lienNiuPp->setSource(5);
            $paymentChecker = $this->get('PaymentChecker');
            $rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
            if($rstPay['Etat']=='SUCCESS')
            {
                if (!empty($nom) || !empty($telephone))
                {                
                    $lienNiuPp->setAccount($user);
                    $lienNiuPp->setNom($nom);
                    $lienNiuPp->setPrenom($prenom);
                    $lienNiuPp->setEmail($email);
                    $lienNiuPp->setTelephone($telephone);
                    $lienNiuPp->setLieuNaissance($lieuNaissance);
                    $lienNiuPp->setNumeroPiece($numCni);
                    $lienNiuPp->setTypePiece($typePiece);                
                    $lienNiuPp->setDateNaissance(empty(new \DateTime($request->get('dateNaissance'))) ? '' : new \DateTime($request->get('dateNaissance')));
                    $lienNiuPp->setDateExpirationPiece(empty(new \DateTime($request->get('dateValiditePiece'))) ? '' : new \DateTime($request->get('dateValiditePiece')));

                    $em = $this->entityManager();
                    //$em->persist($lienNiuPp);
                    //$em->flush();

                    $cle = $this->getParameter('api_key');
                    $piece = 'Lien spécifique PP';
                    $proprietaire = $lienNiuPp->getNom();
    
                    $post = array(
                        'cle' => $cle,
                        'pieceqr'=> $piece,
                        'proprietaire' => $proprietaire,
                        'Raison sociale' => $lienNiuPp->getNom() ,
                        'Activite' => $lienNiuPp->getActiviteDeclaree() ,
                    );
                    // die('in');
                    $flag = false;
                    $time_start = microtime(true);
                    // Attend pendant un moment
                    //usleep(100);
    
                    $container = $this->container;
                    while ($flag == false)
                    {
                            $api = new SqrApi($container);
                            $res = $api->callAPI($post);
                            if ($res != null)
                            {
                                # code...
                                $flag=true;
                            }else
                            {
                            $time_end = microtime(true);
                            $time = $time_end - $time_start;
                            if ($time >= 10)
                            {
                                # code...
                                $lienNiuPp->setStatus(7);
                                $em->persist($lienNiuPp);
                                $em->flush();
                                //$this->get('session')->getFlashBag()->add('success', 'Votre demande a été enregistré avec succès et sera traité. Vous allez recevoir un mail ultérieurement contenant une référence qui vous permettra de consulter le statut de la demande.');
                                
                                $unavailability = $this->get('UnavailabilityEmailAlert');
                                $unavailability->SqrUnavailable();
                                //return $this->redirectToRoute('lienniupp_show', array('id' => $lienNiuPp->getId()));
                                //throw new \ Exception("Error Processing Request", 1);
                            }
                        }
                    }
        
                    if($res[0])
                    {
                            //dump($res);die;
                            
                            $qr = $res[0]->qr;
                            $num = $res[0]->niu;
        
                            $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';
        
                            $checkQr = new CheckQr();
                            $checkQr = $api->generateQr($qr,$num,$newname);
                            $checkQr->setChemin($newname);
                            $lienNiuPp->setQrCode($checkQr);
                            //$lienNiuPp->setStatus(0);
        
                            $em->persist($checkQr);
                            
                            $em->persist($lienNiuPp);
                            $em->flush();
                    }
        
                    if(!empty($lienNiuPp->getEmail()))
                    { 
                        /************ Envoi du mail d'erreur ****************/
                        $msg = (new \Swift_Message('CHECKTATOO - LIEN DE DEMANDE D’IMMATRICULATION'))
                        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                        ->setTo($lienNiuPp->getEmail())
                        ->setBody(
                            $this->renderView(
                                'emails/lien_specifique.html.twig',array(
                                    'object' =>$lienNiuPp,
                                )
                            ),
                            'text/html'
                        );
                        //->attach(\Swift_Attachment::fromPath($target.$name))
                        $this->get('mailer')->send($msg);
                        /*****************Fin envoi du mail ****************/
                    }
                    
                    $return = array(
                        'Etat' =>'SUCCESS' , 
                        'Message' =>'Enregistrement effectué avec succès', 
                        'objet' => $lienNiuPp,
                    );

                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>"Champs requis manquants", 
                        'objet' =>$lienNiuPp,
                    );
                }
            }else
            {
                $return  = $rstPay;
            }

        }else
        {
            //die('in');
            $return  = $user;
        }
        
        return $return;
    }

    /**
     * lien niu
     *
     * @Rest\Post(
     *    path = "personnephysique/ext",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function genererUnLienSourceExterneAction(Request $request)
    {        
        $em = $this->entityManager();
        $nom = $request->get('nom');
        $prenom = $request->get('prenom');
        $email = $request->get('email');
        $telephone = $request->get('telephone');
        $numCni = $request->get('numCni');
        $typePiece = $request->get('typePiece');
        $dateValiditePiece = $request->get('dateValiditePiece');
        $dateNaissance = $request->get('dateNaissance');
        $lieuNaissance = $request->get('lieuNaissance');
        
        $lienNiuPp = new LienNiuPp();
        $lienNiuPp->setSource(6);
        
            
            if (!empty($nom) || !empty($telephone))
            {                
                //$lienNiuPp->setAccount($user);
                $lienNiuPp->setNom($nom);
                $lienNiuPp->setPrenom($prenom);
                $lienNiuPp->setEmail($email);
                $lienNiuPp->setTelephone($telephone);
                $lienNiuPp->setLieuNaissance($lieuNaissance);
                $lienNiuPp->setNumeroPiece($numCni);
                $lienNiuPp->setTypePiece($typePiece);                
                $lienNiuPp->setDateNaissance(empty(new \DateTime($request->get('dateNaissance'))) ? '' : new \DateTime($request->get('dateNaissance')));
                $lienNiuPp->setDateExpirationPiece(empty(new \DateTime($request->get('dateValiditePiece'))) ? '' : new \DateTime($request->get('dateValiditePiece')));

                $em = $this->entityManager();
                //$em->persist($lienNiuPp);
                //$em->flush();

                $cle = $this->getParameter('api_key');
                $piece = 'Lien spécifique PP';
                $proprietaire = $lienNiuPp->getNom();

                $post = array(
                    'cle' => $cle,
                    'pieceqr'=> $piece,
                    'proprietaire' => $proprietaire,
                    'Raison sociale' => $lienNiuPp->getNom() ,
                    'Activite' => $lienNiuPp->getActiviteDeclaree() ,
                );
                // die('in');
                $flag = false;
                $time_start = microtime(true);
                // Attend pendant un moment
                //usleep(100);

                $container = $this->container;
                while ($flag == false)
                {
                    $api = new SqrApi($container);
                    $res = $api->callAPI($post);
                    if ($res != null)
                    {
                        # code...
                        $flag=true;
                    }else
                    {
                        $time_end = microtime(true);
                        $time = $time_end - $time_start;
                        if ($time >= 10)
                        {
                            # code...
                            $lienNiuPp->setStatus(7);
                            $em->persist($lienNiuPp);
                            $em->flush();
                            //$this->get('session')->getFlashBag()->add('success', 'Votre demande a été enregistré avec succès et sera traité. Vous allez recevoir un mail ultérieurement contenant une référence qui vous permettra de consulter le statut de la demande.');
                            
                            $unavailability = $this->get('UnavailabilityEmailAlert');
                            $unavailability->SqrUnavailable();
                            //return $this->redirectToRoute('lienniupp_show', array('id' => $lienNiuPp->getId()));
                            //throw new \ Exception("Error Processing Request", 1);
                        }
                    }
                }

                if($res[0])
                {
                    //dump($res);die;
                    
                    $qr = $res[0]->qr;
                    $num = $res[0]->niu;

                    $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                    $checkQr = new CheckQr();
                    $checkQr = $api->generateQr($qr,$num,$newname);
                    $checkQr->setChemin($newname);
                    $lienNiuPp->setQrCode($checkQr);
                    //$lienNiuPp->setStatus(0);

                    $em->persist($checkQr);
                    
                    $em->persist($lienNiuPp);
                    $em->flush();
                }

                if(!empty($lienNiuPp->getEmail()))
                { 
                    /************ Envoi du mail d'erreur ****************/
                    $msg = (new \Swift_Message('CHECKTATOO - LIEN DE DEMANDE D’IMMATRICULATION'))
                    ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
                    ->setTo($lienNiuPp->getEmail())
                    ->setBody(
                        $this->renderView(
                            'emails/lien_specifique.html.twig',array(
                                'object' =>$lienNiuPp,
                            )
                        ),
                        'text/html'
                    );
                    //->attach(\Swift_Attachment::fromPath($target.$name))
                    $this->get('mailer')->send($msg);
                    /*****************Fin envoi du mail ****************/
                }
                    
                $return = array(
                    'Etat' =>'SUCCESS' , 
                    'Message' =>'Enregistrement effectué avec succès', 
                    'objet' => $lienNiuPp,
                );

            }else
            {
                $return = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>"Champs requis manquants", 
                    'objet' =>$lienNiuPp,
                );
            }
           

        return $return;
    }
    
    /**
     * login
     *
     * @Rest\Post(
     *    path = "personnephysique/list",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function getGeneratedLinksRecordsAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
            //dump($user);die;
            $em = $this->entityManager();
            if(!empty($user->getRole()))
            {
                switch ($user->getRole()) 
                {
                    case '41'://uba agent
                        $lienNiuPps = $em->getRepository('AMLASqrBundle:LienNiuPp')->findby(['account'=>$user],['id'=>'desc']);
                        break;
                    default:
                        $lienNiuPps = $em->getRepository('AMLASqrBundle:LienNiuPp')->findby(['account'=>$user],['id'=>'desc']);
                        break;
                }         
                $return  = $lienNiuPps;
            }
            

        }else
        {
            //die('in');
            $return  = $user;
        }
        
        return $return;
    }

    /**
     * lien niu
     *
     * @Rest\Post(
     *    path = "demande/lien",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return User
     */
    public function demanderUnLienAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {            
            $paymentChecker = $this->get('PaymentChecker');
            $rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
            if($rstPay['Etat']=='SUCCESS')
            {
                $em = $this->entityManager();
                $niu = $request->get('niu');
                $lien = $request->get('lien');

                if (!empty($niu) && !empty($lien))
                {
                    switch ($lien) 
                    {
                        case 'MODIFICATION':
                            # code...
                            $modif = new EnregistrementPpCkeck();
                            $modif->setNiu($niu);
                            //$modif->setUuid($val);
                            $modif->setStatus(3); // lien modification
                            
                            $uuid = Uuid::uuid4();
                            $val = $uuid->toString();
                            
                            $modif->setUuid($val);
                            
                            $em->persist($modif);
                            $em->flush();
                            $lienG ="/enregistrementppckeck/".$val."/demande/modification/contribuable";
                            break;
                        case 'CONFORMISATION':
                            # code...
                            $return = array(
                                'Etat' =>'FAILED' , 
                                'Message' =>"module en développement...", 
                            );
                            break;                    
                        default:
                            # code...
                            $return = array(
                                'Etat' =>'FAILED' , 
                                'Message' =>"paramètre(s) requis manquants", 
                            );
                            break;
                    }
                                
                    $return = array(
                        'Etat' =>'SUCCESS' , 
                        'Message' =>'lien spécifique generé avec succès', 
                        'lien' => $lienG,
                    );

                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>"paramètre(s) requis manquants", 
                    );
                }

            }else
            {
                $return  = $rstPay;
            }
                

        }else
        {
            //die('in');
            $return  = $user;
        }
        
        return $return;
    }

}
