<?php

namespace AMLA\ApiBundle\Controller\Enregistrement;

use AMLA\ApiBundle\Exception\ResourceNotFoundException;
//use AMLA\ApiBundle\Model\Filter\QueryDataFilter;
//use AMLA\ApiBundle\Model\Representation\Impl\_GastraceCardResource;
//use AMLA\ApiBundle\Model\Representation\Impl\_Sell;
use AMLA\SqrBundle\Entity\EnregistrementPm;
use AMLA\SqrBundle\Entity\EnregistrementPp;
use AMLA\SqrBundle\Entity\Agence;
use AMLA\SqrBundle\Entity\Account;
use AMLA\SqrBundle\Model\AgenceResource;
use FOS\RestBundle\Controller\FOSRestController;
use AMLA\ApiBundle\Common\Secure\TokenAuthenticated;
use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;
use AMLA\SqrBundle\Controller\EnregistrementPmController as EnregPm;
use AMLA\SqrBundle\API\SqrApi as SqrApi;
use AMLA\SqrBundle\Entity\CheckQr;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

/**
 * EnregistrementController
 */
class EnregistrementController extends FOSRestController
{

    use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    private function mailer()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * Create enregistrementPm
     *
     * @Rest\Post(
     *    path = "personne/morale",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of enregistrementPm
     */
    public function createNiuPersonneMoraleAction(Request $request)
    {
        //dump($agenceResource); die();
        $user = $this->checkUserApiAccess($request); 
        //dump($user);dump($user instanceof Account); die();
        if ($user instanceof Account)
        {
            $paymentChecker = $this->get('PaymentChecker');
            $rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
            if($rstPay['Etat']=='SUCCESS')
            {
                //$paymentChecker = $this->get('PaymentChecker');
                //$rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
                        
                //dump($user); die();
                $em = $this->entityManager();
                $enregistrementPm = new EnregistrementPm();
                $enregistrementPm->setAccount($user);
                $data = $this->mergeRequestDataPersonneMorale($request, $enregistrementPm);
                if (empty($data['err_string'])) 
                {
                    $return = array(
                        'Etat' =>'SUCCESS' , 
                        'Message' =>'Enregistrement effectué avec succès', 
                        'objet' =>$data['enregistrementPm'],
                    );

                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>$data['err_string'], 
                        'objet' =>$data['enregistrementPm'],
                    );
                }
            }else
            {
                $return  = $rstPay;
            }

        }else
        {
            $return  = $user;
        }
            
        //dump($data);die;
        //$agences = $em->getRepository('AMLASqrBundle:EnregistrementPm')->findBy([],['id'=>'DESC']);
        
        /*$em->persist($agenceResource->chefAgence);
        $agenceResource->agence->setChefAgenceEntity($agenceResource->chefAgence);
        $em->flush();*/
        
        return $return;
    }

    /**
     * Create enregistrementPp
     *
     * @Rest\Post(
     *    path = "personne/physique",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of enregistrementPp
     */
    public function createNiuPersonnePhysiqueAction(Request $request)
    {
        //dump($agenceResource); die();
        //$this->checkApiAccess($request);
        $user=null;
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
            $paymentChecker = $this->get('PaymentChecker');
            $rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
            if($rstPay['Etat']=='SUCCESS')
            {
                $em = $this->entityManager();
                $enregistrementPp = new EnregistrementPp();            
                $enregistrementPp->setAccount($user);
                $data = $this->mergeRequestDataPersonnePhysique($request, $enregistrementPp);
                if (empty($data['err_string'])) 
                {
                    $return = array(
                        'Etat' =>'SUCCESS' , 
                        'Message' =>'Enregistrement effectué avec succès', 
                        'objet' =>$data['enregistrementPp'],
                    );
                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>$data['err_string'], 
                        'objet' =>$data['enregistrementPp'],
                    );
                }
            }else
            {
                $return  = $rstPay;
            }

        }else
        {
            $return  = $user;
        }

        return $return;

    }

    /**
     * check status of pp and pm
     *
     * @Rest\Post(
     *    path = "checkstatus",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of enregistrementPp
     */
    public function checkStatusPpOrPmAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 
        //dump($user);die;
        if ($user instanceof Account)
        {
            $paymentChecker = $this->get('PaymentChecker');
            $rstPay = $paymentChecker->checkAmountAndDebitForTransactionMobile($request, $user);
            if($rstPay['Etat']=='SUCCESS')
            {

                $em = $this->entityManager();
                $reference = $request->get("reference_demande");
                if($reference)
                {
                    $result = $em->getRepository('AMLASqrBundle:EnregistrementPm')->getDemandStatusNumeroPm($reference);
                
                    if(empty($result))
                    {
                        $result = $em->getRepository('AMLASqrBundle:EnregistrementPp')->getDemandStatusNumeroPp($reference);
                    }
        
                    if($result)
                    {
                        $return = array(
                            'Etat' =>'SUCCESS' , 
                            'Message' =>'Demande retrouvée avec succès', 
                            'objet' =>$result[0],
                        );
                    }else
                    {
                        $return = array(
                            'Etat' =>'FAILED' , 
                            'Message' =>'Enregistrement introuvable', 
                            'reference' =>$reference,
                        );  
                    }
                   
                }else{
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>'Paramètres manquants', 
                    );  
                }
            }else
            {
                $return  = $rstPay;
            }
          
        }else
        {
            $return  = $user;
        }

        return $return;

    }

    private function mergeRequestDataPersonneMorale($request, $enregistrementPm)
    {

        $em = $this->entityManager();
        $err_string = null;

        if ($request->get('raisonSociale') && !empty($request->get('raisonSociale'))) 
        {
            $enregistrementPm->setRaisonSociale($request->get('raisonSociale'));
        }else
        {
            $err_string.= "raisonSociale absent, ";
        }

        if ($request->get('sigle') && !empty($request->get('sigle'))) 
        {
            $enregistrementPm->setSigle($request->get('sigle'));
        }else
        {
            $err_string.= "sigle absent, ";
        }
        
        if ($request->get('dateCreation') && !empty($request->get('dateCreation'))) 
        {
            $enregistrementPm->setDateCreation(new \DateTime($request->get('dateCreation')));
        }else
        {
            $err_string.= "dateCreation absent, ";
        }
            
        if ($request->get('lieuCreation') && !empty($request->get('lieuCreation'))) 
        {
            $enregistrementPm->setLieuCreation($request->get('lieuCreation'));
        }else
        {
            $err_string.= "lieuCreation absent, ";
        }

        if ($request->get('nomDirigeant') && !empty($request->get('nomDirigeant'))) 
        {
            $enregistrementPm->setNomDirigeant($request->get('nomDirigeant'));
        }else
        {
            $err_string.= "nomDirigeant absent, ";
        }

        if ($request->get('formeJuridique')  && !empty($request->get('formeJuridique'))) 
        {
            $formeJ = $em->getRepository('AMLASqrBundle:ImpotFormeJuridique')->findOneBy(['idFormeJuridique'=>$request->get('formeJuridique')]);
            if ($formeJ){
                $enregistrementPm->setFormeJuridique($formeJ);
            }else{
                $err_string.= "Forme juridique introuvable, ";
            }
        }else
        {
            $err_string.= "formeJuridique absent, ";
        }

        if ($request->get('regime')  && !empty($request->get('regime'))) {
            $regimeI = $em->getRepository('AMLASqrBundle:ImpotRegimeFiscal')->findOneBy(['idRegimeFiscal'=>$request->get('regime')]);
            if ($regimeI){
                $enregistrementPm->setRegime($regimeI);
            }else{
                $err_string.= "Régime fiscal introuvable, ";
            }
        }else{
            $err_string.= "regime absent, ";
        }

        if ($request->get('activiteDeclaree') && !empty($request->get('activiteDeclaree'))) 
        {
            $enregistrementPm->setActiviteDeclaree($request->get('activiteDeclaree'));
        }else
        {
            $err_string.= "activiteDeclaree absent, ";
        }

        if ($request->get('pays')  && !empty($request->get('pays'))) 
        {
            $paysI = $em->getRepository('AMLASqrBundle:ImpotPays')->findOneBy(['idPays'=>$request->get('pays')]);
            if ($regimeI){
                $enregistrementPm->setPays($paysI);
            }else{
                $err_string.= "pays introuvable, ";
            }
        }else
        {
            $err_string.= "pays absent, ";
        }
        
        if ($request->get('centreDeRattachement')  && !empty($request->get('centreDeRattachement'))) 
        {
             $centreRattachementI = $em->getRepository('AMLASqrBundle:ImpotCentreImpot')->findOneBy(['idUniteGestion'=>$request->get('centreDeRattachement')]);
            if ($centreRattachementI){
                $enregistrementPm->setCentreDeRattachement($centreRattachementI);
            }else{
                $err_string.= "centre de rattachement introuvable, ";
            }
        }else
        {
            $err_string.= "centreDeRattachement absent, ";
        }
        
        if ($request->get('regionAdministration')  && !empty($request->get('regionAdministration'))) 
        {
             $regionAdministrationI = $em->getRepository('AMLASqrBundle:ImpotRegion')->findOneBy(['idRegion'=>$request->get('regionAdministration')]);
            if ($regionAdministrationI){
                $enregistrementPm->setRegionAdministration($regionAdministrationI);
            }else{
                $err_string.= "region administration introuvable, ";
            }
        }else
        {
            $err_string.= "regionAdministration absent, ";
        }
        
        if ($request->get('departement')  && !empty($request->get('departement'))) 
        { 
            $departementI = $em->getRepository('AMLASqrBundle:ImpotDepartement')->findOneBy(['idDepartement'=>$request->get('departement')]);
            if ($departementI){
                $enregistrementPm->setDepartement($departementI);
            }else{
                $err_string.= "departement introuvable, ";
            }
        }else
        {
            $err_string.= "departement absent, ";
        }

        if ($request->get('ville')  && !empty($request->get('ville'))) 
        {
            $villeI = $em->getRepository('AMLASqrBundle:ImpotVille')->findOneBy(['idVille'=>$request->get('ville')]);
            if ($villeI){
                $enregistrementPm->setVille($villeI);
            }else{
                $err_string.= "ville introuvable, ";
            }
        }else
        {
            $err_string.= "ville absent, ";
        }

        if ($request->get('commune')  && !empty($request->get('commune'))) 
        {
            $communeI = $em->getRepository('AMLASqrBundle:ImpotCommune')->findOneBy(['idCommune'=>$request->get('commune')]);
            if ($communeI){
                $enregistrementPm->setCommune($communeI);
            }else{
                $err_string.= "commune introuvable, ";
            }
        }else
        {
            $err_string.= "commune absent, ";
        }

        if ($request->get('quartier')  && !empty($request->get('quartier'))) 
        {
            $quartierI = $em->getRepository('AMLASqrBundle:ImpotQuartier')->findOneBy(['idQuartier'=>$request->get('quartier')]);
            if ($quartierI){
                $enregistrementPm->setQuartier($quartierI);
            }else{
                $err_string.= "quartier introuvable, ";
            }
        }else
        {
            $err_string.= "quartier absent, ";
        }

        if ($request->get('lieuDit') && !empty($request->get('lieuDit'))) 
        {
            $enregistrementPm->setLieuDit($request->get('lieuDit'));
        }else
        {
            $err_string.= "lieuDit absent, ";
        }

        if ($request->get('boitePostale')) 
        {
            $enregistrementPm->setBoitePostale($request->get('boitePostale'));
        }else
        {
            $err_string.= "boitePostale absent, ";
        }
        
        if ($request->get('telephone') && !empty($request->get('telephone'))) 
        {
            $enregistrementPm->setTelephone($request->get('telephone'));
        }else
        {
            $err_string.= "telephone absent, ";
        }
        
        if ($request->get('email') && !empty($request->get('email'))) 
        {
            $enregistrementPm->setEmail($request->get('email'));
        }else
        {
            $err_string.= "email absent, ";
        }
        
        if ($request->get('observation')) 
        {
            $enregistrementPm->setObservation($request->get('observation'));
        }else
        {
            $err_string.= "observation absent, ";
        }
        
        if ($request->get('typePiece') && !empty($request->get('typePiece'))) 
        {
            $enregistrementPm->setTypePiece($request->get('typePiece'));
        }else
        {
            $err_string.= "typePiece absent, ";
        }
        
        if ($request->get('numeroPiece') && !empty($request->get('numeroPiece'))) 
        {
            $numeroPiece = $em->getRepository('AMLASqrBundle:EnregistrementPm')->findOneBy(['numeroPiece'=>$request->get('numeroPiece')]);
            if (empty($numeroPiece)){
                $enregistrementPm->setNumeroPiece($request->get('numeroPiece'));
            }else{
                $err_string.= "Numéro de pièce déjà utilisé, ";
            }
        }else
        {
            $err_string.= "numeroPiece absent, ";
        }
        
        if ($request->get('dateExpirationPiece') && !empty($request->get('dateExpirationPiece'))) 
        {
            $enregistrementPm->setDateExpirationPiece(new \DateTime($request->get('dateExpirationPiece')));
        }else
        {
            $err_string.= "dateExpirationPiece absent, ";
        }

        if ($request->get('imagePiece1') && !empty($request->get('imagePiece1'))) 
        {
            $enregistrementPm->setImagePiece1($request->get('imagePiece1'));
        }else
        {
            $err_string.= "imagePiece1 absent, ";
        }

        if ($request->get('imagePiece2') && !empty($request->get('imagePiece2'))) 
        {
            $enregistrementPm->setImagePiece2($request->get('imagePiece2'));
        }else
        {
            $err_string.= "imagePiece2 absent, ";
        }

        if (empty($err_string)) 
        {
            $enregistrementPm = $this->sendDataToSqrPersonneMorale($enregistrementPm);
        }

        $retour = array(
            'err_string' =>$err_string ,
            'enregistrementPm' =>$enregistrementPm,
        );

        return  $retour;

    }

    private function mergeRequestDataPersonnePhysique($request, $enregistrementPp)
    {

        $em = $this->entityManager();
        $err_string = null;

        if ($request->get('nom') && !empty($request->get('nom'))) 
        {
            $enregistrementPp->setNom($request->get('nom'));
        }else
        {
            $err_string.= "nom absent, ";
        }

        if ($request->get('prenom') && !empty($request->get('prenom'))) 
        {
            $enregistrementPp->setPrenom($request->get('prenom'));
        }else
        {
            $err_string.= "prenom absent, ";
        }

        if ($request->get('sexe') && !empty($request->get('sexe'))) 
        {
            $enregistrementPp->setSexe($request->get('sexe'));
        }else
        {
            $err_string.= "sexe absent, ";
        }
        
        if ($request->get('dateNaissance') && !empty($request->get('dateNaissance'))) 
        {
            $enregistrementPp->setDateNaissance(new \DateTime($request->get('dateNaissance')));
        }else
        {
            $err_string.= "dateNaissance absent, ";
        }
        
        if ($request->get('lieuNaissance') && !empty($request->get('lieuNaissance'))) 
        {
            $enregistrementPp->setLieuNaissance($request->get('lieuNaissance'));
        }else
        {
            $err_string.= "lieuNaissance absent, ";
        }

        if ($request->get('regime')  && !empty($request->get('regime'))) {
            $regimeI = $em->getRepository('AMLASqrBundle:ImpotRegimeFiscal')->findOneBy(['idRegimeFiscal'=>$request->get('regime')]);
            if ($regimeI){
                $enregistrementPp->setRegime($regimeI);
            }else{
                $err_string.= "Régime fiscal introuvable, ";
            }
        }else{
            $err_string.= "regime absent, ";
        }

        if ($request->get('activiteDeclaree') && !empty($request->get('activiteDeclaree'))) 
        {
            $enregistrementPp->setActiviteDeclaree($request->get('activiteDeclaree'));
        }else
        {
            $err_string.= "activiteDeclaree absent, ";
        }

        if ($request->get('pays')  && !empty($request->get('pays'))) 
        {
            $paysI = $em->getRepository('AMLASqrBundle:ImpotPays')->findOneBy(['idPays'=>$request->get('pays')]);
            if ($regimeI){
                $enregistrementPp->setPays($paysI);
            }else{
                $err_string.= "pays introuvable, ";
            }
        }else
        {
            $err_string.= "pays absent, ";
        }
        
        if ($request->get('centreDeRattachement')  && !empty($request->get('centreDeRattachement'))) 
        {
             $centreRattachementI = $em->getRepository('AMLASqrBundle:ImpotCentreImpot')->findOneBy(['idUniteGestion'=>$request->get('centreDeRattachement')]);
            if ($centreRattachementI){
                $enregistrementPp->setCentreDeRattachement($centreRattachementI);
            }else{
                $err_string.= "centre de rattachement introuvable, ";
            }
        }else
        {
            $err_string.= "centreDeRattachement absent, ";
        }
        
        if ($request->get('regionAdministration')  && !empty($request->get('regionAdministration'))) 
        {
             $regionAdministrationI = $em->getRepository('AMLASqrBundle:ImpotRegion')->findOneBy(['idRegion'=>$request->get('regionAdministration')]);
            if ($regionAdministrationI){
                $enregistrementPp->setRegionAdministration($regionAdministrationI);
            }else{
                $err_string.= "region administration introuvable, ";
            }
        }else
        {
            $err_string.= "regionAdministration absent, ";
        }
        
        if ($request->get('departement')  && !empty($request->get('departement'))) 
        { 
            $departementI = $em->getRepository('AMLASqrBundle:ImpotDepartement')->findOneBy(['idDepartement'=>$request->get('departement')]);
            if ($departementI){
                $enregistrementPp->setDepartement($departementI);
            }else{
                $err_string.= "departement introuvable, ";
            }
        }else
        {
            $err_string.= "departement absent, ";
        }

        if ($request->get('ville')  && !empty($request->get('ville'))) 
        {
            $villeI = $em->getRepository('AMLASqrBundle:ImpotVille')->findOneBy(['idVille'=>$request->get('ville')]);
            if ($villeI){
                $enregistrementPp->setVille($villeI);
            }else{
                $err_string.= "ville introuvable, ";
            }
        }else
        {
            $err_string.= "ville absent, ";
        }

        if ($request->get('commune')  && !empty($request->get('commune'))) 
        {
            $communeI = $em->getRepository('AMLASqrBundle:ImpotCommune')->findOneBy(['idCommune'=>$request->get('commune')]);
            if ($communeI){
                $enregistrementPp->setCommune($communeI);
            }else{
                $err_string.= "commune introuvable, ";
            }
        }else
        {
            $err_string.= "commune absent, ";
        }

        if ($request->get('quartier')  && !empty($request->get('quartier'))) 
        {
            $quartierI = $em->getRepository('AMLASqrBundle:ImpotQuartier')->findOneBy(['idQuartier'=>$request->get('quartier')]);
            if ($quartierI)
            {
                $enregistrementPp->setQuartier($quartierI);
            }else
            {
                $err_string.= "quartier introuvable, ";
            }
        }else
        {
            $err_string.= "quartier absent, ";
        }

        if ($request->get('situationMatrimoniale')  && !empty($request->get('situationMatrimoniale'))) 
        {
            $situationMatrimonialeI = $em->getRepository('AMLASqrBundle:ImpotEtatCivil')->findOneBy(['idEtatCivil'=>$request->get('situationMatrimoniale')]);
            if ($situationMatrimonialeI){
                $enregistrementPp->setSituationMatrimoniale($situationMatrimonialeI);
            }else{
                $err_string.= "situationMatrimoniale introuvable, ";
            }
        }else
        {
            $err_string.= "situationMatrimoniale absent, ";
        }

        if ($request->get('lieuDit') && !empty($request->get('lieuDit'))) 
        {
            $enregistrementPp->setLieuDit($request->get('lieuDit'));
        }else
        {
            $err_string.= "lieuDit absent, ";
        }

        if ($request->get('boitePostale')) 
        {
            $enregistrementPp->setBoitePostale($request->get('boitePostale'));
        }else
        {
            $err_string.= "boitePostale absent, ";
        }

        if ($request->get('nomMere') && !empty($request->get('nomMere'))) 
        {
            $enregistrementPp->setNomMere($request->get('nomMere'));
        }else
        {
            $err_string.= "nomMere absent, ";
        }

        if ($request->get('prenomMere')) 
        {
            $enregistrementPp->setPrenomMere($request->get('prenomMere'));
        }else
        {
            $err_string.= "prenomMere absent, ";
        }

        if ($request->get('nomPere') && !empty($request->get('nomPere'))) 
        {
            $enregistrementPp->setNomPere($request->get('nomPere'));
        }else
        {
            $err_string.= "nomPere absent, ";
        }

        if ($request->get('prenomPere')) 
        {
            $enregistrementPp->setPrenomPere($request->get('prenomPere'));
        }else
        {
            $err_string.= "prenomPere absent, ";
        }
        
        if ($request->get('telephone') && !empty($request->get('telephone'))) 
        {
            $enregistrementPp->setTelephone($request->get('telephone'));
        }else
        {
            $err_string.= "telephone absent, ";
        }
        
        if ($request->get('email') && !empty($request->get('email'))) 
        {
            $enregistrementPp->setEmail($request->get('email'));
        }else
        {
            $err_string.= "email absent, ";
        }
        
        if ($request->get('observation')) 
        {
            $enregistrementPp->setObservation($request->get('observation'));
        }else
        {
            $err_string.= "observation absent, ";
        }
        
        if ($request->get('typePiece') && !empty($request->get('typePiece'))) 
        {
            $enregistrementPp->setTypePiece($request->get('typePiece'));
        }else
        {
            $err_string.= "typePiece absent, ";
        }
        
        if ($request->get('numeroPiece') && !empty($request->get('numeroPiece'))) 
        {
            $numeroPiece = $em->getRepository('AMLASqrBundle:EnregistrementPp')->findOneBy(['numeroPiece'=>$request->get('numeroPiece')]);
            if (empty($numeroPiece)){
                $enregistrementPp->setNumeroPiece($request->get('numeroPiece'));
            }else{
                $err_string.= "Numéro de pièce déjà utilisé, ";
            }
        }else
        {
            $err_string.= "numeroPiece absent, ";
        }

        if ($request->get('dateExpirationPiece') && !empty($request->get('dateExpirationPiece')))
        {
            $enregistrementPp->setDateExpirationPiece(new \DateTime($request->get('dateExpirationPiece')));
        }else
        {
            $err_string.= "dateExpirationPiece absent, ";
        }

        if ($request->get('imagePiece1') && !empty($request->get('imagePiece1'))) 
        {
            $enregistrementPp->setImagePiece1($request->get('imagePiece1'));
        }else
        {
            $err_string.= "imagePiece1 absent, ";
        }

        if ($request->get('imagePiece2') && !empty($request->get('imagePiece2'))) 
        {
            $enregistrementPp->setImagePiece2($request->get('imagePiece2'));
        }else
        {
            $err_string.= "imagePiece2 absent, ";
        }

        if (empty($err_string)) 
        {
            $enregistrementPp = $this->sendDataToSqrPersonnePhysique($enregistrementPp);
        }
        //dump($enregistrementPp);die;
        $retour = array(
            'err_string' =>$err_string ,
            'enregistrementPp' =>$enregistrementPp,
        );

        return  $retour;
    }
    
    private function sendDataToSqrPersonnePhysique($enregistrementPp)
    {
        // envoyer les donées à SQR
            $cle = $this->getParameter('api_key');
            $piece = 'Demande NIU Personne Physique';
            $proprietaire = $enregistrementPp->getNom();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece,
                'proprietaire' => $proprietaire,
                'Raison sociale' => $enregistrementPp->getNom() ,
                'Activite' => $enregistrementPp->getActiviteDeclaree() ,
            );
            // die('in');
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;
            while ($flag == false)
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null)
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10)
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);
                    }
                }
            }

            if($res[0])
            {

                $em = $this->entityManager();
                $qr = $res[0]->qr;
                $num = $res[0]->niu;

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);
                $enregistrementPp->setQrCode($checkQr);

                $em->persist($checkQr);

                $em->persist($enregistrementPp);
                $em->flush();


                $mail = $this->genDocAndRecepitMailPp($enregistrementPp);
            }

            return $enregistrementPp;
    }

    private function sendDataToSqrPersonneMorale($enregistrementPm)
    {
        // envoyer les donées à SQR
           $em = $this->entityManager();

            $cle = $this->getParameter('api_key');
            $piece = 'Demande NIU Personne morale';
            $proprietaire = $enregistrementPm->getRaisonSociale().' '.$enregistrementPm->getSigle();

            $post = array(
                'cle' => $cle,
                'pieceqr'=> $piece,
                'proprietaire' => $proprietaire,
                'Raison sociale' => $enregistrementPm->getRaisonSociale(),
                'Sigle' => $enregistrementPm->getSigle(),
            );
           // die('in');
            $flag = false;
            $time_start = microtime(true);
            // Attend pendant un moment
            //usleep(100);

            $container = $this->container;
            while ($flag == false)
            {
                $api = new SqrApi($container);
                $res = $api->callAPI($post);
                if ($res != null)
                {
                    # code...
                    $flag=true;
                }else
                {
                    $time_end = microtime(true);
                    $time = $time_end - $time_start;
                    if ($time >= 10)
                    {
                        # code...
                        throw new \ Exception("Error Processing Request", 1);
                    }
                }
            }

            if($res[0])
            {
                $qr = $res[0]->qr;
                $num = $res[0]->niu;

                $newname = 'verification_terminal_'.date('YmdHis',time()).mt_rand(0,1000).'.png';

                $checkQr = new CheckQr();
                $checkQr = $api->generateQr($qr,$num,$newname);
                $checkQr->setChemin($newname);
                $enregistrementPm->setQrCode($checkQr);

                //To send mail
                //dump($enregistrementPm);die;
                //$enregPm = new EnregPm();
                //$enregistrementPm = $enregPm->genDocAndRecepitMailPm($enregistrementPm);
                
                $em->persist($checkQr);
                $em->persist($enregistrementPm);

                $em->flush();
                $mail = $this->genDocAndRecepitMailPm($enregistrementPm);
           }

            return $enregistrementPm;
    }

    private function genDocAndRecepitMailPm($object )
    {
        /************************************** Start gen doc ********************************/
        ///start attestation vérif
        $name = 'ATTEST_IMMAT_EN_ATTENTE_IMPOT'.$object->getNumeroPiece().'.pdf';
        $target = __DIR__.'/../../../../../web/generated/attestations/immatriculation/';

        $pdf = $this->renderView('print/attestation_immatriculation_en_attente_pm.html.twig', array(
            'object'=>$object,
            'imageqr'=> $object->getQrCode()->getChemin(),
            'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
         ));
        
        try{

            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            if (file_exists($target) != 1)
            {
                mkdir($target,0777,true);
                $mpdf->Output($target.$name, 'F');
            }else
            {
                $mpdf->Output($target.$name, 'F');
            }

        }catch(MpdfException $e)
        {

            die($e->getMessage());
        }
        /*************************************end doc gen *************************/
        $em = $this->getDoctrine()->getManager();
        $object->getQrCode()->setPdf1($name);        
        $em->persist($object);
        $em->flush();
        /******************Envoi du mail de confirmation de soumission****************
        $msg = (new \Swift_Message('CHECKTATOO - DEMANDE DE NIU EN COURS DE TRAITEMENT'))
        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
        ->setTo($object->getEmail())
        ->setBody(
            $this->renderView(
                'emails/accuse_immatriculation_en_attente_pm.html.twig',array(
                    'object' =>$object,
                )
            ),
            'text/html'
        )
        ->attach(\Swift_Attachment::fromPath($target.$name));
        $this->get('mailer')->send($msg);
        /******************Fin envoi du mail *************************/
        return $object;
    }

    public function genDocAndRecepitMailPp($object )
    {

        /************************************** Start gen doc ********************************/

        ///start attestation vérif
        $name = 'ATTEST_IMMAT_EN_ATTENTE_IMPOT'.$object->getNumeroPiece().'.pdf';
        $target = __DIR__.'/../../../../../web/generated/attestations/immatriculation/';

        $pdf = $this->renderView('print/attestation_immatriculation_en_attente_pp.html.twig', array(
            'object'=>$object,
            'imageqr'=> $object->getQrCode()->getChemin(),
            'base_dir' => $this->get('kernel')->getRootDir() . '/../web',
         ));
        try{

            $mpdf = new \Mpdf\Mpdf();
            $mpdf->WriteHtml($pdf);
            if (file_exists($target) != 1)
            {
                mkdir($target,0777,true);
                $mpdf->Output($target.$name, 'F');
            }else
            {
                $mpdf->Output($target.$name, 'F');
            }

        }catch(MpdfException $e)
        {

            die($e->getMessage());
        }

        /*************************************end doc gen *************************/
        $em = $this->getDoctrine()->getManager();
        $object->getQrCode()->setPdf1($name);        
        $em->persist($object);
        $em->flush();
        /******************Envoi du mail de confirmation de soumission****************
        $msg = (new \Swift_Message('CHECKTATOO - DEMANDE DE NIU EN COURS DE TRAITEMENT'))
        ->setFrom(['internet.amlacm@gmail.com' => 'CHECKTATOO'])
        ->setTo($object->getEmail())
        ->setBody(
            $this->renderView(
                'emails/accuse_immatriculation_en_attente_pp.html.twig',array(
                    'object' =>$object,
                )
            ),
            'text/html'
        )
        ->attach(\Swift_Attachment::fromPath($target.$name));
        $this->get('mailer')->send($msg);
        /******************Fin envoi du mail *************************/
        return $object;
    }
}