<?php

namespace AMLA\ApiBundle\Controller\Approvisionnement;

use AMLA\ApiBundle\Exception\ResourceNotFoundException;
//use AMLA\ApiBundle\Model\Filter\QueryDataFilter;
//use AMLA\ApiBundle\Model\Representation\Impl\_GastraceCardResource;
//use AMLA\ApiBundle\Model\Representation\Impl\_Sell;
use AMLA\SqrBundle\Entity\Approvisionnement;
use AMLA\SqrBundle\Entity\Account;
use AMLA\SqrBundle\Model\AgenceResource;
use FOS\RestBundle\Controller\FOSRestController;
use AMLA\ApiBundle\Common\Secure\TokenAuthenticated;
use AMLA\ApiBundle\Config\Constants;

use FOS\RestBundle\Request\ParamFetcherInterface;
use Symfony\Component\HttpFoundation\Request;
use FOS\RestBundle\Controller\Annotations as Rest;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\ParamConverter;

/**
 * ApprovisionnementController
 */
class ApprovisionnementController extends FOSRestController
{

    use TokenAuthenticated;

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    private function mailer()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * New approvisionnement MOMO OM
     *
     * @Rest\Post(
     *    path = "new",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of approvisionnement
     */
    public function approvisionnerFromOMMOMOAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 

        if ($user instanceof Account)
        {
        	$amount = intval($request->get('amount'));
        	$operator = $request->get('operator');
        	$reference = $request->get('reference');

        	if(!empty($amount) && !empty($operator) && !empty($reference))
        	{
 
            	$em = $this->entityManager();

            	$user->setSolde($user->getSolde() + $amount);

		        $em->persist($user);
		        $em->flush();

		        $return = array(
                    'Etat' =>'SUCCESS' , 
                    'Message' =>'Approvisionnement effectué avec succès', 
                    'solde' =>$user->getSolde(),
                );

        	}else
        	{
        		$return = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>"Paramètre(s) manquant(s)", 
                );
        	}

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    /**
     * Approvisionnement list
     *
     * @Rest\Post(
     *    path = "list/emis",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of approvisionnement
     */
    public function listEmisAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 

        if ($user instanceof Account)
        {
        	$em = $this->getDoctrine()->getManager();

        	$approvisionnements = $em->getRepository('AMLASqrBundle:Approvisionnement')->getApprovisionnementEmisForUser($user);
        	$return = array(
                    'Etat' =>'SUCCESS' , 
                    'Message' =>"Liste des demandes d'approvisionnement émises recupéré avec succès", 
                    'objet' =>$approvisionnements,
                );

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    
    /**
     * Approvisionnement list
     *
     * @Rest\Post(
     *    path = "list/recus",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of approvisionnement
     */
    public function listRecusAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 

        if ($user instanceof Account)
        {
        	$em = $this->getDoctrine()->getManager();

        	$approvisionnements = $em->getRepository('AMLASqrBundle:Approvisionnement')->getApprovisionnementRecusForUser($user);
        	$return = array(
                    'Etat' =>'SUCCESS' , 
                    'Message' =>"Liste des demandes d'approvisionnement reçues recupéré avec succès", 
                    'objet' =>$approvisionnements,
                );

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    /**
     * Demander un approvisionnement
     *
     * @Rest\Post(
     *    path = "demander",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of approvisionnement
     */
    public function demanderUnApprovisionnementAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 

        if ($user instanceof Account)
        {
        	$niu = $request->get('niu');
        	$montant = $request->get('montant');

        	if(!empty($niu) && !empty($montant))
        	{
                $em = $this->entityManager();
                $account = $em->getRepository('AMLASqrBundle:Account')->findOneBy(['loginUser'=>$niu]); // get user by login

                if($account)
                {
                    $approvisionnement = new Approvisionnement();
                    $em = $this->entityManager();
                    $approvisionnement->setAccount($user);
                    $approvisionnement->setParrain($account);
                    $approvisionnement->setMontantDemande(intVal($montant));
    
                    $em->persist($approvisionnement);
                    $em->flush();
    
                    $return = array(
                        'Etat' =>'SUCCESS' , 
                        'Message' =>"Demande d'approvisionnement effectué avec succès", 
                        'solde_demandeur' =>$user->getSolde(),
                    );
                    
                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>"le NIU ne correspond à aucun compte du système...", 
                    );
                }               

        	}else
        	{
        		$return = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>"Paramètre(s) manquant(s)", 
                );
        	}

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

    
    
    /**
     * Demander un approvisionnement
     *
     * @Rest\Post(
     *    path = "traiter/demande",
     *    name = ""
     * )
     * @Rest\View(StatusCode = 200, serializerGroups={"exclude_again", "exclude"})
     * @param Request $request
     * @return array of approvisionnement
     */
    public function traiterUneDemandeApprovisionnementAction(Request $request)
    {
        $user = $this->checkUserApiAccess($request); 

        if ($user instanceof Account)
        {
        	$id = intval($request->get('id'));
        	$status = intVal($request->get('status')); //1 = ok 2 rejected
        	$amount = intVal($request->get('amount'));
        	$comment = $request->get('comment');

        	if(!empty($id) && !empty($status) && !empty($amount) && !empty($comment))
        	{
                $em = $this->entityManager();
                $approvisionnement = $em->getRepository('AMLASqrBundle:Approvisionnement')->find($id);

                if($approvisionnement)
                {   
                    if($status === 1 || $status===2)
                    {
                        $approvisionnement->setStatus($status);
                        $approvisionnement->setCommentaire($comment);
                        if($status == 1)
                        {
                            $parain = $approvisionnement->getParrain();
                            if($parain->getSolde() > $amount)
                            {
                                $approvisionnement->setMontantAccorde($amount);
                                $acc = $approvisionnement->getAccount();
                                $parain->setSolde($parain->getSolde() - $amount);
                                $acc->setSolde($acc->getSolde() + $amount);
                                $em->persist($acc);
                                $em->persist($parain);

                                $return = array(
                                    'Etat' =>'SUCCESS' , 
                                    'Message' =>'Approvisionnement traité avec succès', 
                                    'solde' =>$user->getSolde(),
                                );
                            }else
                            {
                                $return = array(
                                    'Etat' =>'FAILED' , 
                                    'Message' =>"Votre solde est insuffisant pour la transaction",
                                ); 
                            }

                        }
                        $em->persist($approvisionnement);
                        $em->flush();
    
                        

                    }else
                    {
                        $return = array(
                            'Etat' =>'FAILED' , 
                            'Message' =>"Le status n'est pas valide", 
                        );
                    }
                   
                }else
                {
                    $return = array(
                        'Etat' =>'FAILED' , 
                        'Message' =>"le NIU ne correspond à aucun compte du système...", 
                    );
                }
            	
        	}else
        	{
        		$return = array(
                    'Etat' =>'FAILED' , 
                    'Message' =>"Paramètre(s) manquant(s)", 
                );
        	}

        }else
        {
            $return  = $user;
        }
        
        return $return;
    }

}