<?php

namespace AMLA\ApiBundle\Common\Secure;

use AMLA\ApiBundle\Config\Constants;
use AMLA\ApiBundle\Exception\ForBiddenException;
use Doctrine\ORM\EntityManager;
use Symfony\Component\HttpFoundation\Request;
use AMLA\SqrBundle\Entity\Account;
use AMLA\ApiBundle\Util\StringUtil;

/**
 * TokenAuthenticated
 * Used to check the validity of the token for each request
 */
trait TokenAuthenticated
{

    private $privateKey = "73FDF4BEE5EAA6526CA937E9C2C6B";

    private $authentinovKey = "7799b4c7-c6a3-42a9-877e-327cf770bb07";

    private function publicKeys()
    {
        return array($this->authentinovKey);
    }

    private function entityManager()
    {
        return $this->getDoctrine()->getManager();
    }

    /**
     * Find user by login
     *
     * @param $login
     * @return User|null
     */
    public function apiFindByLogin( $login)
    {   
        $em = $this->entityManager();
        return $em->getRepository('AMLASqrBundle:Account')->findOneBy(['loginUser'=>$login]);
    }

    /**
     * Check api access
     *
     * @param Request $request
     * @return bool
     * @throws ForBiddenException
     */
    public function checkApiAccess(Request $request)
    {
        $key = $request->headers->get(Constants::TOKEN_KEY);
        if (empty($key) || $key != $this->privateKey)
        {
            return array(
                'Etat' =>'FAILED',
                'Message' =>'This action requires authorization. Check your access key.',
            );

            //throw new ForBiddenException("This action requires authorization. Check your access key.");
        }
            
    }

    /**
     * Check user api access
     *
     * @param EntityManager $em
     * @param Request $request
     * @return bool
     * @throws ForBiddenException
     */
    public function checkUserApiAccess(Request $request)
    {
        $em = $this->entityManager();
        $token = $request->headers->get(Constants::TOKEN_KEY);
        //$userRepository = $em->getRepository(sprintf(Constants::WEB_REPO, "User"));

        $user = $this->apiCheckUserByToken($token);
        //$user = $userRepository->apiCheckUserByToken($userId, $token);

        if ($user == null)
        {
            return array(
                'Etat' =>'FAILED' , 
                'Message' =>'This action requires authorization. Check your access key.' , 
            );
            //throw new ForBiddenException("This action requires authorization. Check your access key.");
        }
            
        return $user;
    }

    /**
     * Check public access
     *
     * @param Request $request
     * @throws ForBiddenException
     */
    public function checkPublicAccess(Request $request)
    {
        $key = $request->headers->get(Constants::TOKEN_KEY);

        if (!in_array($key, $this->publicKeys())){
            return array(
                'Etat' =>'FAILED' , 
                'Message' =>'This action requires authorization. Check your access key.', 
            );
            //throw new ForBiddenException("This action requires authorization. Check your access key.");
        }
            
    }

    /**
     * Check public access
     *
     * @param Request $request
     * @throws ForBiddenException
     */
    public function apiCheckUserByToken($tokepn)
    {
        $em = $this->entityManager();
        $user = $em->getRepository('AMLASqrBundle:Account')->findOneBy(['token'=>$tokepn]);
        //dump($tokepn);dump($user);die;
        if (empty($user) || empty($tokepn))
        {
            return array(
                'Etat' =>'FAILED' , 
                'Message' =>'This action requires authorization. Check your access key and set a valid token.' , 
            );
            //throw new ForBiddenException("This action requires authorization. Check your access key and set token.");
        }
            
        return $user;
    }

    
    /**
     * Check public access
     *
     * @param Account $user
     * @throws ForBiddenException
     */
    public function apiSignOutUser(Account $user)
    {
        //$user = null;
        //dump($tokepn);dump($user);die;
        if (!empty($user))
        {
            $em = $this->entityManager();
            $user->setToken(null);
            $em->merge($user);
            $em->flush();

            return array(
                'Etat' =>'SUCCESS' , 
                'Message' =>'Sign out completed successfully.', 
            );
        }
        /*elseif($user)
        {
            return array(
                'Etat' =>'FAILED' , 
                'Message' =>'This action requires authorization. Check your access key and set a valid token.' , 
            );
        }*/
            
        return $user;
    }

    /**
     * Log in user
     *
     * @param LoginResource $login
     * @param null $fcmToken
     * @return User|null
     */
    public function apiLogin(Request $request)
    {
        $em = $this->entityManager();
        $loginResponse = null;

        $login = $request->get('login');
        $password = $request->get('password');

        if (empty($login) && empty($password)) 
        {
            return array(
                'Etat' =>'FAILED' , 
                'Message' =>'The Login or password parameter is absent. Check your parameter key.', 
            );
            //throw new ForBiddenException("The Login or password parameter is absent. Check your parameter key.");
        }

        $user = $this->apiFindByLogin($login);
        if ($user != null && $user->checkPassword($password)) 
        {
            // Handle token
            $user = $this->handleTokenForLogin($user);
            $em->merge($user);
            $em->flush();

            $loginResponse = $user;
        } else {
            $loginResponse = null;
        }

        return $loginResponse;
    }
    

    /**
     * Log in user
     *
     * @param LoginResource $login
     * @param null $fcmToken
     * @return User|null
     */
    public function apiSignIn(Request $request)
    {
        $em = $this->entityManager();
        $loginResponse = null;

        $login = $request->get('login');
        $password = $request->get('password');

        if (empty($login) && empty($password)) 
        {
            return array(
                'Etat' =>'FAILED' , 
                'Message' =>'The Login or password parameter is absent. Check your parameter key.', 
            );
            //throw new ForBiddenException("The Login or password parameter is absent. Check your parameter key.");
        }

        $user = $this->apiFindByLogin($login);
        if ($user != null && $user->checkPassword($password)) 
        {
            // Handle token
            $user = $this->handleTokenForLogin($user);
            $em->merge($user);
            $em->flush();

            $loginResponse = ["token"=>$user->getToken()];

        } else {
            $loginResponse = null;
        }

        return $loginResponse;
    }


    /**
     * Check user by token or Id
     *
     * @param $userId
     * @param $tokenValue
     * @return User|null
     */
    public function apiCheckUserByIdOrToken($userId, $tokenValue)
    {
        $em = $this->entityManager();
        $user = $em->getRepository('AMLASqrBundle:Account')->find($userId);

        if($user != null)
        {
            if($user->getToken() != null && $user->getToken() == $tokenValue)
                return $user;
        }

        return null;
    }

    // Util function */

    public function handleTokenForLogin(Account $user)
    {
        $em = $this->entityManager();
        $flag = false;
        while ($flag == false) 
        {
            $token = $this->generateToken();

            $userExistToken = $em->getRepository('AMLASqrBundle:Account')->findOneBy(['token'=>$token]);
            if (!$userExistToken) 
            {
                $flag = true;
                $user->setToken($token);
            }
        }

        return $user;
    }

    public function generateToken ()
    {
        $token = StringUtil::getToken();
        return $token;
    }
}
