<?php

namespace AMLA\ApiBundle\Common\Docs;

use Mpdf\HTMLParserMode;
use Mpdf\Mpdf;
use Mpdf\Output\Destination;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * SlipDoc
 */
class SlipDoc extends BaseDoc
{

    const slipDir = "Attachment/Slip/";

    /**
     * SlipDoc constructor.
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        parent::__construct($container);
    }

    private function getSlipDir()
    {
        return $this->buildDocDir(SlipDoc::slipDir);
    }

    /**
     * Build new slip doc
     *
     * @param $fileContent
     * @return string
     */
    public function genericSlip($fileContent){
        $mpdf = new Mpdf([
            'format' => [190, 236],
            'orientation' => 'P'
        ]);

        // Encode
        $mpdf->allow_charset_conversion=true;
        $mpdf->charset_in='UTF-8';

        $stylesheet = file_get_contents($this->getExtraDir() . 'generic_slip_style.css');

        $mpdf->WriteHTML($stylesheet, HTMLParserMode::HEADER_CSS);
        $mpdf->WriteHTML(utf8_encode($fileContent), HTMLParserMode::HTML_BODY);


        $filePath = md5(uniqid()) . '.pdf';
        $fileName = $this->getSlipDir() . $filePath;
        $mpdf->Output($fileName, Destination::FILE);

        return $filePath;
    }

}