<?php

namespace AMLA\ApiBundle\Common\Docs;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * BaseDoc
 */
class BaseDoc
{

    protected $container;

    protected $webAssets;
    protected $webDir;
    protected $extraDir;

    /**
     * Default constructor
     *
     * @param ContainerInterface $container
     */
    public function __construct(ContainerInterface $container)
    {
        if($container == null)
            throw new \LogicException("Invalid value for container :: null given");

        $this->container = $container;
        $this->webAssets = $this->container->getParameter("web_assets");
        $this->webDir = $this->container->getParameter("web_dir");
        $this->extraDir = $this->webAssets . "extra/";
    }

    /**
     * Creates a destination directory for docs
     *
     * @param $dirName
     * @return string
     */
    public function buildDocDir($dirName)
    {
        $docDir = $this->webDir . $dirName;

        if (!file_exists($docDir) || !is_dir($docDir)) {
            mkdir($docDir, 0777, true);
        }

        return $docDir;
    }

    // Getters and setters

    /**
     * @return ContainerInterface
     */
    public function getContainer()
    {
        return $this->container;
    }

    /**
     * @param ContainerInterface $container
     */
    public function setContainer($container)
    {
        $this->container = $container;
    }

    /**
     * @return mixed
     */
    public function getWebDir()
    {
        return $this->webDir;
    }

    /**
     * @param mixed $webDir
     */
    public function setWebDir($webDir)
    {
        $this->webDir = $webDir;
    }

    /**
     * @return mixed
     */
    public function getWebAssets()
    {
        return $this->webAssets;
    }

    /**
     * @param mixed $webAssets
     */
    public function setWebAssets($webAssets)
    {
        $this->webAssets = $webAssets;
    }

    /**
     * @return string
     */
    public function getExtraDir()
    {
        return $this->extraDir;
    }

    /**
     * @param string $extraDir
     */
    public function setExtraDir($extraDir)
    {
        $this->extraDir = $extraDir;
    }

}